/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kotlin.io.FilesKt;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.FileUtils;
import org.gradle.internal.classpath.MethodHandleUtils;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.CallInterceptorRegistry;
import org.gradle.internal.classpath.intercept.ClassBoundCallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;
import org.gradle.internal.configuration.inputs.AccessTrackingEnvMap;
import org.gradle.internal.configuration.inputs.AccessTrackingProperties;
import org.gradle.internal.configuration.inputs.InstrumentedInputs;
import org.gradle.internal.configuration.inputs.InstrumentedInputsListener;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptor;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.internal.lazy.Lazy;

public class Instrumented {
    private static final Lazy<MethodHandle> FILESKT_READ_TEXT_DEFAULT = MethodHandleUtils.lazyKotlinStaticDefaultHandle(FilesKt.class, "readText", String.class, File.class, Charset.class);
    private static final Lazy<MethodHandle> FILES_READ_STRING_PATH = Lazy.locking().of(() -> MethodHandleUtils.findStaticOrThrowError(Files.class, "readString", MethodType.methodType(String.class, Path.class)));
    private static final Lazy<MethodHandle> FILES_READ_STRING_PATH_CHARSET = Lazy.locking().of(() -> MethodHandleUtils.findStaticOrThrowError(Files.class, "readString", MethodType.methodType(String.class, Path.class, Charset.class)));

    private static InstrumentedInputsListener listener() {
        return InstrumentedInputs.listener();
    }

    @Deprecated
    public static List<CallInterceptor> getCallInterceptors() {
        return Arrays.asList(new SystemGetPropertyInterceptor(), new SystemSetPropertyInterceptor(), new SystemGetPropertiesInterceptor(), new SystemSetPropertiesInterceptor(), new SystemClearPropertyInterceptor(), new IntegerGetIntegerInterceptor(), new LongGetLongInterceptor(), new BooleanGetBooleanInterceptor(), new SystemGetenvInterceptor(), new RuntimeExecInterceptor(), new ProcessGroovyMethodsExecuteInterceptor(), new ProcessBuilderStartInterceptor(), new ProcessBuilderStartPipelineInterceptor());
    }

    public static void groovyCallSites(CallSiteArray array, BytecodeInterceptorFilter interceptorFilter) {
        for (org.codehaus.groovy.runtime.callsite.CallSite callSite : array.array) {
            array.array[callSite.getIndex()] = CallInterceptorRegistry.getGroovyCallDecorator(interceptorFilter).maybeDecorateGroovyCallSite(callSite);
        }
    }

    public static CallSite bootstrapInstrumentationOnly(MethodHandles.Lookup caller, String callType, MethodType type, String name, int flags) {
        return CallInterceptorRegistry.getGroovyCallDecorator(BytecodeInterceptorFilter.INSTRUMENTATION_ONLY).maybeDecorateIndyCallSite(IndyInterface.bootstrap((MethodHandles.Lookup)caller, (String)callType, (MethodType)type, (String)name, (int)flags), caller, callType, name, flags);
    }

    public static CallSite bootstrapAll(MethodHandles.Lookup caller, String callType, MethodType type, String name, int flags) {
        return CallInterceptorRegistry.getGroovyCallDecorator(BytecodeInterceptorFilter.ALL).maybeDecorateIndyCallSite(IndyInterface.bootstrap((MethodHandles.Lookup)caller, (String)callType, (MethodType)type, (String)name, (int)flags), caller, callType, name, flags);
    }

    public static String systemProperty(String key, String consumer) {
        return Instrumented.systemProperty(key, null, consumer);
    }

    public static String systemProperty(String key, @Nullable String defaultValue, String consumer) {
        String value = System.getProperty(key);
        Instrumented.systemPropertyQueried(key, value, consumer);
        return value == null ? defaultValue : value;
    }

    public static Properties systemProperties(final String consumer) {
        return new AccessTrackingProperties(System.getProperties(), new AccessTrackingProperties.Listener(){

            public void onAccess(Object key, @Nullable Object value) {
                if (key instanceof String && (value == null || value instanceof String)) {
                    Instrumented.systemPropertyQueried(Instrumented.convertToString(key), Instrumented.convertToString(value), consumer);
                }
            }

            public void onChange(Object key, Object newValue) {
                Instrumented.listener().systemPropertyChanged(key, newValue, consumer);
            }

            public void onRemove(Object key) {
                Instrumented.listener().systemPropertyRemoved(key, consumer);
            }

            public void onClear() {
                Instrumented.listener().systemPropertiesCleared(consumer);
            }
        });
    }

    public static String setSystemProperty(String key, String value, String consumer) {
        String oldValue = System.setProperty(key, value);
        Instrumented.systemPropertyQueried(key, oldValue, consumer);
        Instrumented.listener().systemPropertyChanged((Object)key, (Object)value, consumer);
        return oldValue;
    }

    public static String clearSystemProperty(String key, String consumer) {
        String oldValue = System.clearProperty(key);
        Instrumented.systemPropertyQueried(key, oldValue, consumer);
        Instrumented.listener().systemPropertyRemoved((Object)key, consumer);
        return oldValue;
    }

    public static void setSystemProperties(Properties properties, String consumer) {
        Instrumented.listener().systemPropertiesCleared(consumer);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> Instrumented.listener().systemPropertyChanged(k, v, consumer)));
        System.setProperties(properties);
    }

    public static Integer getInteger(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key);
    }

    public static Integer getInteger(String key, int defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Long getLong(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key);
    }

    public static Long getLong(String key, long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static boolean getBoolean(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Boolean.getBoolean(key);
    }

    public static String getenv(String key, String consumer) {
        String value = System.getenv(key);
        Instrumented.envVariableQueried(key, value, consumer);
        return value;
    }

    public static Map<String, String> getenv(String consumer) {
        return new AccessTrackingEnvMap((key, value) -> Instrumented.envVariableQueried(Instrumented.convertToString(key), value, consumer));
    }

    public static Process exec(Runtime runtime, String command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command);
    }

    public static Process exec(Runtime runtime, String[] command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp);
    }

    public static Process exec(Runtime runtime, String[] command, String[] envp, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp);
    }

    public static Process exec(Runtime runtime, String command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp, dir);
    }

    public static Process exec(Runtime runtime, String[] command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return runtime.exec(command, envp, dir);
    }

    public static Process execute(String command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command);
    }

    public static Process execute(String[] command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command);
    }

    public static Process execute(List<?> command, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command);
    }

    public static Process execute(String command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command, (String[])envp, (File)dir);
    }

    public static Process execute(String command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String)command, envp, (File)dir);
    }

    public static Process execute(String[] command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command, (String[])envp, (File)dir);
    }

    public static Process execute(String[] command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute((String[])command, envp, (File)dir);
    }

    public static Process execute(List<?> command, String[] envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command, (String[])envp, (File)dir);
    }

    public static Process execute(List<?> command, List<?> envp, File dir, String consumer) throws IOException {
        Instrumented.externalProcessStarted(command, consumer);
        return ProcessGroovyMethods.execute(command, envp, (File)dir);
    }

    public static Process start(ProcessBuilder builder, String consumer) throws IOException {
        Instrumented.externalProcessStarted(builder.command(), consumer);
        return builder.start();
    }

    public static void fileSystemEntryObserved(File file, String consumer) {
        Instrumented.listener().fileSystemEntryObserved(file, consumer);
    }

    public static boolean fileExists(File file, String consumer) {
        Instrumented.fileSystemEntryObserved(file, consumer);
        return file.exists();
    }

    public static boolean fileIsFile(File file, String consumer) {
        Instrumented.fileSystemEntryObserved(file, consumer);
        return file.isFile();
    }

    public static boolean fileIsDirectory(File file, String consumer) {
        Instrumented.fileSystemEntryObserved(file, consumer);
        return file.isDirectory();
    }

    public static void directoryContentObserved(File file, String consumer) {
        Instrumented.listener().directoryContentObserved(file, consumer);
    }

    public static File[] fileListFiles(File file, String consumer) {
        Instrumented.directoryContentObserved(file, consumer);
        return file.listFiles();
    }

    public static File[] fileListFiles(File file, FileFilter fileFilter, String consumer) {
        Instrumented.directoryContentObserved(file, consumer);
        return file.listFiles(fileFilter);
    }

    public static File[] fileListFiles(File file, FilenameFilter fileFilter, String consumer) {
        Instrumented.directoryContentObserved(file, consumer);
        return file.listFiles(fileFilter);
    }

    public static String kotlinIoFilesKtReadText(File receiver, Charset charset, String consumer) {
        Instrumented.listener().fileOpened(receiver, consumer);
        return FilesKt.readText((File)receiver, (Charset)charset);
    }

    public static String kotlinIoFilesKtReadTextDefault(File receiver, Charset charset, int defaultMask, Object defaultMarker, String consumer) throws Throwable {
        Instrumented.listener().fileOpened(receiver, consumer);
        return ((MethodHandle)FILESKT_READ_TEXT_DEFAULT.get()).invokeExact(receiver, charset, defaultMask, defaultMarker);
    }

    public static String filesReadString(Path file, String consumer) throws Throwable {
        FileUtils.tryReportFileOpened(file, consumer);
        return ((MethodHandle)FILES_READ_STRING_PATH.get()).invokeExact(file);
    }

    public static String filesReadString(Path file, Charset charset, String consumer) throws Throwable {
        FileUtils.tryReportFileOpened(file, consumer);
        return ((MethodHandle)FILES_READ_STRING_PATH_CHARSET.get()).invokeExact(file, charset);
    }

    public static String groovyFileGetText(File file, String consumer) throws IOException {
        Instrumented.listener().fileOpened(file, consumer);
        return ResourceGroovyMethods.getText((File)file);
    }

    public static String groovyFileGetText(File file, String charset, String consumer) throws IOException {
        Instrumented.listener().fileOpened(file, consumer);
        return ResourceGroovyMethods.getText((File)file, (String)charset);
    }

    public static List<Process> startPipeline(List<ProcessBuilder> pipeline, String consumer) throws IOException {
        try {
            for (ProcessBuilder builder : pipeline) {
                Instrumented.externalProcessStarted(builder.command(), consumer);
            }
            Object result = ProcessBuilder.class.getMethod("startPipeline", List.class).invoke(null, pipeline);
            return (List)result;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new NoSuchMethodError("Cannot find method ProcessBuilder.startPipeline");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unexpected exception thrown by ProcessBuilder.startPipeline", e);
        }
    }

    public static void fileObserved(File file, String consumer) {
        Instrumented.listener().fileObserved(Instrumented.absoluteFileOf(file), consumer);
    }

    public static void fileOpened(File file, String consumer) {
        Instrumented.listener().fileOpened(Instrumented.absoluteFileOf(file), consumer);
    }

    private static File absoluteFileOf(File file) {
        return file.isAbsolute() ? file : new File(Instrumented.currentDir(), file.getPath());
    }

    private static File currentDir() {
        return SystemProperties.getInstance().getCurrentDir();
    }

    public static void fileOpened(String path, String consumer) {
        Instrumented.fileOpened(new File(path), consumer);
    }

    private static void envVariableQueried(String key, String value, String consumer) {
        Instrumented.listener().envVariableQueried(key, value, consumer);
    }

    private static void systemPropertyQueried(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, System.getProperty(key), consumer);
    }

    private static void systemPropertyQueried(String key, @Nullable String value, String consumer) {
        Instrumented.listener().systemPropertyQueried(key, (Object)value, consumer);
    }

    private static void externalProcessStarted(String command, String consumer) {
        Instrumented.listener().externalProcessStarted(command, consumer);
    }

    private static void externalProcessStarted(String[] command, String consumer) {
        Instrumented.externalProcessStarted(Instrumented.joinCommand(command), consumer);
    }

    private static void externalProcessStarted(List<?> command, String consumer) {
        Instrumented.externalProcessStarted(Instrumented.joinCommand(command), consumer);
    }

    private static String convertToString(Object arg) {
        if (arg instanceof CharSequence) {
            return ((CharSequence)arg).toString();
        }
        return (String)arg;
    }

    private static String joinCommand(String[] command) {
        return String.join((CharSequence)" ", command);
    }

    private static String joinCommand(List<?> command) {
        return command.stream().map(String::valueOf).collect(Collectors.joining(" "));
    }

    private static class ProcessBuilderStartPipelineInterceptor
    extends ClassBoundCallInterceptor {
        public ProcessBuilderStartPipelineInterceptor() {
            super(ProcessBuilder.class, InterceptScope.methodsNamed("startPipeline"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1 && invocation.getArgument(0) instanceof List) {
                return Instrumented.startPipeline((List)invocation.getArgument(0), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class ProcessBuilderStartInterceptor
    extends CallInterceptor
    implements BytecodeInterceptor.InstrumentationInterceptor {
        ProcessBuilderStartInterceptor() {
            super(InterceptScope.methodsNamed("start"));
        }

        @Override
        public Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver instanceof ProcessBuilder) {
                return Instrumented.start((ProcessBuilder)receiver, consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class ProcessGroovyMethodsExecuteInterceptor
    extends CallInterceptor
    implements BytecodeInterceptor.InstrumentationInterceptor {
        protected ProcessGroovyMethodsExecuteInterceptor() {
            super(InterceptScope.methodsNamed("execute"));
        }

        @Override
        public Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object fileArg;
            Object envpArg;
            int nonCommandArgsOffset;
            boolean isStaticCall = invocation.getReceiver().equals(ProcessGroovyMethods.class);
            int argsCount = invocation.getArgsCount();
            int nonCommandArgsCount = argsCount - (nonCommandArgsOffset = isStaticCall ? 1 : 0);
            if (nonCommandArgsCount != 0 && nonCommandArgsCount != 2) {
                return invocation.callOriginal();
            }
            Object commandArg = isStaticCall ? invocation.getArgument(0) : invocation.getReceiver();
            Optional<Process> result = this.tryCallExecute(commandArg, envpArg = invocation.getOptionalArgument(nonCommandArgsOffset), fileArg = invocation.getOptionalArgument(nonCommandArgsOffset + 1), consumer);
            if (result.isPresent()) {
                return result.get();
            }
            return invocation.callOriginal();
        }

        private Optional<Process> tryCallExecute(Object commandArg, @Nullable Object envpArg, @Nullable Object fileArg, String consumer) throws Throwable {
            if (fileArg == null || fileArg instanceof File) {
                File file = (File)fileArg;
                if (commandArg instanceof CharSequence) {
                    String command = Instrumented.convertToString(commandArg);
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, consumer));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, consumer));
                    }
                } else if (commandArg instanceof String[]) {
                    String[] command = (String[])commandArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, consumer));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, consumer));
                    }
                } else if (commandArg instanceof List) {
                    List command = (List)commandArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        return Optional.of(Instrumented.execute(command, (String[])envpArg, file, consumer));
                    }
                    if (envpArg instanceof List) {
                        return Optional.of(Instrumented.execute(command, (List)envpArg, file, consumer));
                    }
                }
            }
            return Optional.empty();
        }
    }

    private static class RuntimeExecInterceptor
    extends CallInterceptor
    implements BytecodeInterceptor.InstrumentationInterceptor {
        public RuntimeExecInterceptor() {
            super(InterceptScope.methodsNamed("exec"));
        }

        @Override
        public Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Optional<Process> result;
            int argsCount = invocation.getArgsCount();
            if (1 <= argsCount && argsCount <= 3 && (result = this.tryCallExec(invocation.getReceiver(), invocation.getArgument(0), invocation.getOptionalArgument(1), invocation.getOptionalArgument(2), consumer)).isPresent()) {
                return result.get();
            }
            return invocation.callOriginal();
        }

        private Optional<Process> tryCallExec(Object runtimeArg, Object commandArg, @Nullable Object envpArg, @Nullable Object fileArg, String consumer) throws Throwable {
            if (runtimeArg instanceof Runtime) {
                Runtime runtime = (Runtime)runtimeArg;
                if (fileArg == null || fileArg instanceof File) {
                    File file = (File)fileArg;
                    if (envpArg == null || envpArg instanceof String[]) {
                        String[] envp = (String[])envpArg;
                        if (commandArg instanceof CharSequence) {
                            String command = Instrumented.convertToString(commandArg);
                            return Optional.of(Instrumented.exec(runtime, command, envp, file, consumer));
                        }
                        if (commandArg instanceof String[]) {
                            String[] command = (String[])commandArg;
                            return Optional.of(Instrumented.exec(runtime, command, envp, file, consumer));
                        }
                    }
                }
            }
            return Optional.empty();
        }
    }

    private static class SystemGetenvInterceptor
    extends ClassBoundCallInterceptor {
        public SystemGetenvInterceptor() {
            super(System.class, InterceptScope.methodsNamed("getenv"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 0: {
                    return Instrumented.getenv(consumer);
                }
                case 1: {
                    return Instrumented.getenv(Instrumented.convertToString(invocation.getArgument(0)), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemClearPropertyInterceptor
    extends ClassBoundCallInterceptor {
        public SystemClearPropertyInterceptor() {
            super(System.class, InterceptScope.methodsNamed("clearProperty"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                return Instrumented.clearSystemProperty(Instrumented.convertToString(invocation.getArgument(0)), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemSetPropertiesInterceptor
    extends ClassBoundCallInterceptor {
        public SystemSetPropertiesInterceptor() {
            super(System.class, InterceptScope.methodsNamed("setProperties"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                Instrumented.setSystemProperties((Properties)invocation.getArgument(0), consumer);
                return null;
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemGetPropertiesInterceptor
    extends ClassBoundCallInterceptor {
        public SystemGetPropertiesInterceptor() {
            super(System.class, InterceptScope.readsOfPropertiesNamed("properties"), InterceptScope.methodsNamed("getProperties"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 0) {
                return Instrumented.systemProperties(consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemSetPropertyInterceptor
    extends ClassBoundCallInterceptor {
        public SystemSetPropertyInterceptor() {
            super(System.class, InterceptScope.methodsNamed("setProperty"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 2) {
                return Instrumented.setSystemProperty(Instrumented.convertToString(invocation.getArgument(0)), Instrumented.convertToString(invocation.getArgument(1)), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class SystemGetPropertyInterceptor
    extends ClassBoundCallInterceptor {
        public SystemGetPropertyInterceptor() {
            super(System.class, InterceptScope.methodsNamed("getProperty"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 1: {
                    return Instrumented.systemProperty(invocation.getArgument(0).toString(), consumer);
                }
                case 2: {
                    return Instrumented.systemProperty(invocation.getArgument(0).toString(), Instrumented.convertToString(invocation.getArgument(1)), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class BooleanGetBooleanInterceptor
    extends ClassBoundCallInterceptor {
        public BooleanGetBooleanInterceptor() {
            super(Boolean.class, InterceptScope.methodsNamed("getBoolean"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            if (invocation.getArgsCount() == 1) {
                return Instrumented.getBoolean(invocation.getArgument(0).toString(), consumer);
            }
            return invocation.callOriginal();
        }
    }

    private static class LongGetLongInterceptor
    extends ClassBoundCallInterceptor {
        public LongGetLongInterceptor() {
            super(Long.class, InterceptScope.methodsNamed("getLong"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 1: {
                    return Instrumented.getLong(invocation.getArgument(0).toString(), consumer);
                }
                case 2: {
                    return Instrumented.getLong(invocation.getArgument(0).toString(), (Long)invocation.getArgument(1), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class IntegerGetIntegerInterceptor
    extends ClassBoundCallInterceptor {
        public IntegerGetIntegerInterceptor() {
            super(Integer.class, InterceptScope.methodsNamed("getInteger"));
        }

        @Override
        protected Object doInterceptSafe(Invocation invocation, String consumer) throws Throwable {
            switch (invocation.getArgsCount()) {
                case 1: {
                    return Instrumented.getInteger(invocation.getArgument(0).toString(), consumer);
                }
                case 2: {
                    return Instrumented.getInteger(invocation.getArgument(0).toString(), (Integer)invocation.getArgument(1), consumer);
                }
            }
            return invocation.callOriginal();
        }
    }
}

