/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.attr;

import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.util.StringUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MutableAttributeHolder
extends AttributeHolder {
    @Nonnull
    public MutableConvertibleValues<Object> getAttributes();

    @Nonnull
    default public MutableAttributeHolder setAttribute(@Nonnull CharSequence name, @Nullable Object value) {
        if (StringUtils.isNotEmpty(name)) {
            if (value == null) {
                this.getAttributes().remove(name.toString());
            } else {
                this.getAttributes().put(name.toString(), value);
            }
        }
        return this;
    }

    @Nonnull
    default public <T> Optional<T> removeAttribute(@Nonnull CharSequence name, @Nonnull Class<T> type) {
        if (StringUtils.isNotEmpty(name)) {
            String key = name.toString();
            Optional<Object> value = this.getAttribute(key, type);
            value.ifPresent(o -> this.getAttributes().remove(key));
            return value;
        }
        return Optional.empty();
    }
}

