/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.AbstractBeanMethod;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.beans.AbstractExecutableBeanMethod;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
final class BeanMethodWriter
extends AbstractClassFileWriter
implements Named {
    protected static final Method METHOD_INVOKE_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanMethod.class, (String)"invokeInternal", (Class[])new Class[]{Object.class, Object[].class}));
    private static final Type TYPE_BEAN_PROPERTY = Type.getType(AbstractExecutableBeanMethod.class);
    private final MethodElement methodElement;
    private final Type type;
    private final ClassWriter classWriter;
    private final BeanIntrospectionWriter introspectionWriter;
    private final HashMap<String, GeneratorAdapter> loadTypeMethods = new HashMap();
    private final Map<String, Integer> defaults = new HashMap<String, Integer>();

    @Internal
    BeanMethodWriter(@NonNull BeanIntrospectionWriter introspectionWriter, Type introspectionType, int index, MethodElement methodElement) {
        super(methodElement, methodElement.getDeclaringType());
        this.type = JavaModelUtils.getTypeReference(ClassElement.of(introspectionType.getClassName() + "$$exec" + index));
        this.classWriter = new ClassWriter(3);
        this.methodElement = methodElement;
        this.introspectionWriter = introspectionWriter;
    }

    public Type getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.type.getClassName();
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream classOutput = classWriterOutputVisitor.visitClass(this.getName(), this.getOriginatingElements());){
            this.startFinalClass((ClassVisitor)this.classWriter, this.type.getInternalName(), TYPE_BEAN_PROPERTY);
            this.writeConstructor();
            this.writeInvoke();
            this.finalizeClass(classOutput);
        }
    }

    private void writeInvoke() {
        GeneratorAdapter invokeMethod = this.startPublicMethod(this.classWriter, METHOD_INVOKE_INTERNAL);
        ClassElement returnType = this.methodElement.getReturnType();
        ParameterElement[] parameters = this.methodElement.getParameters();
        List<ParameterElement> argumentTypes = Arrays.asList(parameters);
        String methodDescriptor = BeanMethodWriter.getMethodDescriptor(returnType, argumentTypes);
        invokeMethod.loadArg(0);
        BeanMethodWriter.pushCastToType((MethodVisitor)invokeMethod, this.introspectionWriter.getBeanType());
        for (int i = 0; i < parameters.length; ++i) {
            ParameterElement parameter = parameters[i];
            invokeMethod.loadArg(1);
            invokeMethod.push(i);
            invokeMethod.visitInsn(50);
            BeanMethodWriter.pushCastToType((MethodVisitor)invokeMethod, parameter.getType());
        }
        ClassElement declaringType = this.methodElement.getDeclaringType();
        invokeMethod.visitMethodInsn(declaringType.isInterface() ? 185 : 182, JavaModelUtils.getTypeReference(declaringType).getInternalName(), this.methodElement.getName(), methodDescriptor, declaringType.isInterface());
        if (returnType.getName().equals("void")) {
            invokeMethod.visitInsn(1);
        } else {
            BeanMethodWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)invokeMethod);
        }
        invokeMethod.returnValue();
        invokeMethod.visitMaxs(1, 1);
        invokeMethod.visitEnd();
    }

    private void finalizeClass(OutputStream classOutput) throws IOException {
        for (GeneratorAdapter generator : this.loadTypeMethods.values()) {
            generator.visitMaxs(3, 1);
            generator.visitEnd();
        }
        classOutput.write(this.classWriter.toByteArray());
    }

    private void writeConstructor() {
        GeneratorAdapter constructor = this.startConstructor((ClassVisitor)this.classWriter, BeanIntrospection.class);
        ClassElement genericReturnType = this.methodElement.getGenericReturnType();
        constructor.loadThis();
        constructor.loadArg(0);
        if (genericReturnType.isPrimitive() && !genericReturnType.isArray()) {
            String constantName = genericReturnType.getName().toUpperCase(Locale.ENGLISH);
            Type type = Type.getType(Argument.class);
            constructor.getStatic(type, constantName, type);
        } else {
            BeanMethodWriter.pushCreateArgument(this.introspectionWriter.getBeanType().getClassName(), this.type, this.classWriter, constructor, "R", genericReturnType, genericReturnType.getAnnotationMetadata(), genericReturnType.getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        constructor.push(this.methodElement.getName());
        AnnotationMetadata annotationMetadata = this.methodElement.getAnnotationMetadata();
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            annotationMetadata = ((AnnotationMetadataHierarchy)annotationMetadata).getDeclaredMetadata();
        }
        if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)annotationMetadata;
            for (ParameterElement pe : this.methodElement.getParameters()) {
                DefaultAnnotationMetadata.contributeDefaults(defaultMetadata, pe.getAnnotationMetadata());
            }
            if (defaultMetadata.isEmpty()) {
                constructor.visitInsn(1);
            } else {
                AnnotationMetadataWriter.instantiateNewMetadata(this.type, this.classWriter, constructor, defaultMetadata, this.defaults, this.loadTypeMethods);
            }
        } else {
            constructor.visitInsn(1);
        }
        BeanMethodWriter.pushBuildArgumentsForMethod(this.introspectionWriter.getBeanType().getClassName(), this.type, this.classWriter, constructor, Arrays.asList(this.methodElement.getParameters()), new HashMap<String, Integer>(), this.loadTypeMethods);
        this.invokeConstructor((MethodVisitor)constructor, AbstractExecutableBeanMethod.class, BeanIntrospection.class, Argument.class, String.class, AnnotationMetadata.class, Argument[].class);
        constructor.visitInsn(177);
        constructor.visitMaxs(20, 2);
        constructor.visitEnd();
    }
}

