/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.web.rest.render;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import grails.core.support.proxy.ProxyHandler;
import grails.rest.render.ContainerRenderer;
import grails.rest.render.Renderer;
import grails.rest.render.RendererRegistry;
import grails.util.GrailsClassUtils;
import grails.web.mime.MimeType;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.grails.plugins.web.rest.render.html.DefaultHtmlRenderer;
import org.grails.plugins.web.rest.render.json.DefaultJsonRenderer;
import org.grails.plugins.web.rest.render.xml.DefaultXmlRenderer;
import org.grails.web.gsp.io.GrailsConventionGroovyPageLocator;
import org.grails.web.util.ClassAndMimeTypeRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;

public class DefaultRendererRegistry
extends ClassAndMimeTypeRegistry<Renderer, RendererCacheKey>
implements RendererRegistry {
    private Map<ContainerRendererCacheKey, Renderer> containerRenderers;
    private Cache<ContainerRendererCacheKey, Renderer<?>> containerRendererCache;
    @Autowired(required=false)
    private GrailsConventionGroovyPageLocator groovyPageLocator;
    @Autowired(required=false)
    private ProxyHandler proxyHandler;
    private String modelSuffix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public DefaultRendererRegistry() {
        String string;
        Cache cache;
        ConcurrentHashMap<ContainerRendererCacheKey, Renderer> concurrentHashMap = new ConcurrentHashMap<ContainerRendererCacheKey, Renderer>();
        this.containerRenderers = concurrentHashMap;
        this.containerRendererCache = cache = Caffeine.newBuilder().initialCapacity(500).maximumSize((long)1000).build();
        this.modelSuffix = string = "";
    }

    @PostConstruct
    public void initialize() {
        this.addDefaultRenderer(new DefaultXmlRenderer<Object>(Object.class, this.groovyPageLocator, this));
        this.addDefaultRenderer(new DefaultJsonRenderer<Object>(Object.class, this.groovyPageLocator, this));
        DefaultHtmlRenderer<Object> defaultHtmlRenderer = new DefaultHtmlRenderer<Object>(Object.class);
        String string = this.modelSuffix;
        defaultHtmlRenderer.setSuffix(string);
        ProxyHandler proxyHandler = this.proxyHandler;
        defaultHtmlRenderer.setProxyHandler(proxyHandler);
        this.addDefaultRenderer(defaultHtmlRenderer);
        DefaultHtmlRenderer<Object> allHtmlRenderer = new DefaultHtmlRenderer<Object>(Object.class, MimeType.ALL);
        String string2 = this.modelSuffix;
        allHtmlRenderer.setSuffix(string2);
        ProxyHandler proxyHandler2 = this.proxyHandler;
        allHtmlRenderer.setProxyHandler(proxyHandler2);
        this.addDefaultRenderer(allHtmlRenderer);
        this.containerRenderers.put(new ContainerRendererCacheKey(this, Errors.class, Object.class, MimeType.XML), new DefaultXmlRenderer<Errors>(Errors.class));
        this.containerRenderers.put(new ContainerRendererCacheKey(this, Errors.class, Object.class, MimeType.TEXT_XML), new DefaultXmlRenderer<Errors>(Errors.class));
        this.containerRenderers.put(new ContainerRendererCacheKey(this, Errors.class, Object.class, MimeType.JSON), new DefaultJsonRenderer<Errors>(Errors.class));
        this.containerRenderers.put(new ContainerRendererCacheKey(this, Errors.class, Object.class, MimeType.TEXT_JSON), new DefaultJsonRenderer<Errors>(Errors.class));
        DefaultHtmlRenderer<Errors> defaultContainerHtmlRenderer = new DefaultHtmlRenderer<Errors>(Errors.class);
        String string3 = this.modelSuffix;
        defaultContainerHtmlRenderer.setSuffix(string3);
        ProxyHandler proxyHandler3 = this.proxyHandler;
        defaultContainerHtmlRenderer.setProxyHandler(proxyHandler3);
        this.containerRenderers.put(new ContainerRendererCacheKey(this, Errors.class, Object.class, MimeType.HTML), defaultContainerHtmlRenderer);
        this.containerRenderers.put(new ContainerRendererCacheKey(this, Errors.class, Object.class, MimeType.ALL), defaultContainerHtmlRenderer);
    }

    @Autowired(required=false)
    public void setRenderers(Renderer ... renderers) {
        Renderer r2 = null;
        Renderer[] rendererArray = renderers;
        if (renderers != null) {
            for (Renderer r2 : rendererArray) {
                this.addRenderer(r2);
            }
        }
    }

    @Override
    public <T> void addRenderer(Renderer<T> renderer) {
        if (renderer instanceof ContainerRenderer) {
            ContainerRenderer cr = (ContainerRenderer)ScriptBytecodeAdapter.castToType(renderer, ContainerRenderer.class);
            this.addContainerRenderer(cr.getComponentType(), cr);
        } else {
            Class<T> targetType = renderer.getTargetType();
            this.addToRegisteredObjects(targetType, renderer);
        }
    }

    @Override
    public void addDefaultRenderer(Renderer<Object> renderer) {
        MimeType mt2 = null;
        MimeType[] mimeTypeArray = renderer.getMimeTypes();
        if (mimeTypeArray != null) {
            for (MimeType mt2 : mimeTypeArray) {
                this.registerDefault(mt2, renderer);
                this.removeFromCache(renderer.getTargetType(), mt2);
            }
        }
    }

    @Override
    public void addContainerRenderer(Class objectType, Renderer renderer) {
        MimeType mt2 = null;
        MimeType[] mimeTypeArray = renderer.getMimeTypes();
        if (mimeTypeArray != null) {
            for (MimeType mt2 : mimeTypeArray) {
                ContainerRendererCacheKey key = new ContainerRendererCacheKey(this, renderer.getTargetType(), objectType, mt2);
                this.containerRendererCache.invalidate((Object)key);
                this.containerRenderers.put(key, renderer);
            }
        }
    }

    @Override
    public <T> Renderer<T> findRenderer(MimeType mimeType, T object) {
        return (Renderer)ScriptBytecodeAdapter.castToType((Object)this.findMatchingObjectForMimeType(mimeType, object), Renderer.class);
    }

    @Override
    public <C, T> Renderer<C> findContainerRenderer(MimeType mimeType, Class<C> containerType, T object) {
        Class<? extends Object> clazz;
        if (object == null) {
            return (Renderer)ScriptBytecodeAdapter.castToType(null, Renderer.class);
        }
        if (this.proxyHandler != null) {
            Object object2 = this.proxyHandler.unwrapIfProxy(object);
            object = object2;
        }
        Class<? extends Object> originalTargetClass = object instanceof Class ? ShortTypeHandling.castToClass(object) : object.getClass();
        originalTargetClass = clazz = this.getTargetClassForContainer(originalTargetClass, object);
        ContainerRendererCacheKey originalKey = new ContainerRendererCacheKey(this, containerType, originalTargetClass, mimeType);
        Renderer renderer = (Renderer)this.containerRendererCache.getIfPresent((Object)originalKey);
        if (renderer == null) {
            ContainerRendererCacheKey key = originalKey;
            Class<? extends Object> targetClass = originalTargetClass;
            while (targetClass != null) {
                ContainerRendererCacheKey containerRendererCacheKey;
                Renderer renderer2 = this.containerRenderers.get(key);
                renderer = (Renderer)ScriptBytecodeAdapter.castToType((Object)renderer2, Renderer.class);
                if (renderer != null) break;
                key = containerRendererCacheKey = new ContainerRendererCacheKey(this, containerType, targetClass, mimeType);
                Renderer renderer3 = this.containerRenderers.get(key);
                renderer = (Renderer)ScriptBytecodeAdapter.castToType((Object)renderer3, Renderer.class);
                if (renderer != null) break;
                Class[] containerInterfaces = GrailsClassUtils.getAllInterfacesForClass(containerType);
                Class i2 = null;
                Class[] classArray = containerInterfaces;
                if (containerInterfaces != null) {
                    for (Class i2 : classArray) {
                        ContainerRendererCacheKey containerRendererCacheKey2;
                        key = containerRendererCacheKey2 = new ContainerRendererCacheKey(this, i2, targetClass, mimeType);
                        Renderer renderer4 = this.containerRenderers.get(key);
                        renderer = (Renderer)ScriptBytecodeAdapter.castToType((Object)renderer4, Renderer.class);
                        if (!(renderer != null)) continue;
                        break;
                    }
                }
                if (ScriptBytecodeAdapter.compareEqual(targetClass, Object.class)) break;
                Class<? extends Object> clazz2 = targetClass.getSuperclass();
                targetClass = clazz2;
            }
            if (renderer == null) {
                Class[] interfaces = GrailsClassUtils.getAllInterfacesForClass(originalTargetClass);
                Class i = null;
                Class[] classArray = interfaces;
                if (interfaces != null) {
                    int n = classArray.length;
                    int n2 = 0;
                    block2: while (n2 < n) {
                        ContainerRendererCacheKey containerRendererCacheKey;
                        i = classArray[n2];
                        ++n2;
                        key = containerRendererCacheKey = new ContainerRendererCacheKey(this, containerType, i, mimeType);
                        Renderer renderer5 = this.containerRenderers.get(key);
                        renderer = (Renderer)ScriptBytecodeAdapter.castToType((Object)renderer5, Renderer.class);
                        if (DefaultTypeTransformation.booleanUnbox((Object)renderer)) break;
                        Class[] containerInterfaces = GrailsClassUtils.getAllInterfacesForClass(containerType);
                        Class ci2 = null;
                        Class[] classArray2 = containerInterfaces;
                        if (containerInterfaces == null) continue;
                        for (Class ci2 : classArray2) {
                            ContainerRendererCacheKey containerRendererCacheKey3;
                            key = containerRendererCacheKey3 = new ContainerRendererCacheKey(this, ci2, i, mimeType);
                            Renderer renderer6 = this.containerRenderers.get(key);
                            renderer = (Renderer)ScriptBytecodeAdapter.castToType((Object)renderer6, Renderer.class);
                            if (!(renderer != null)) continue;
                            break block2;
                        }
                    }
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)renderer)) {
                this.containerRendererCache.put((Object)originalKey, (Object)renderer);
            }
        }
        return renderer;
    }

    protected Class<? extends Object> getTargetClassForContainer(Class containerClass, Object object) {
        Class<?> targetClass = containerClass;
        if (containerClass.isArray()) {
            Class<?> clazz;
            targetClass = clazz = containerClass.getComponentType();
        } else if (object instanceof Iterable) {
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                Iterator iterator = DefaultGroovyMethods.iterator((Object)object);
                Object first = iterator.next();
                if (DefaultTypeTransformation.booleanUnbox(first)) {
                    if (this.proxyHandler != null) {
                        Object object2 = this.proxyHandler.unwrapIfProxy(first);
                        first = object2;
                    }
                    Class<?> clazz = first.getClass();
                    targetClass = clazz;
                }
            }
        } else if (object instanceof Map) {
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                Object first = ((Map)object).values().iterator().next();
                if (DefaultTypeTransformation.booleanUnbox(first)) {
                    if (this.proxyHandler != null) {
                        Object object3 = this.proxyHandler.unwrapIfProxy(first);
                        first = object3;
                    }
                    Class<?> clazz = first.getClass();
                    targetClass = clazz;
                }
            }
        } else if (object instanceof BeanPropertyBindingResult) {
            Object target = ((BeanPropertyBindingResult)ScriptBytecodeAdapter.castToType((Object)object, BeanPropertyBindingResult.class)).getTarget();
            if (DefaultTypeTransformation.booleanUnbox((Object)target)) {
                if (this.proxyHandler != null) {
                    Object object4;
                    target = object4 = this.proxyHandler.unwrapIfProxy(target);
                }
                Class<?> clazz = target.getClass();
                targetClass = clazz;
            }
        }
        return targetClass;
    }

    @Override
    public boolean isContainerType(Class<?> aClass) {
        Reference aClass2 = new Reference(aClass);
        public final class _isContainerType_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference aClass;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isContainerType_closure1(Object _outerInstance, Object _thisObject, Reference aClass) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.aClass = reference = aClass;
            }

            public Object doCall(ContainerRendererCacheKey key) {
                return key.getContainerType().isAssignableFrom(ShortTypeHandling.castToClass((Object)this.aClass.get()));
            }

            public Object call(ContainerRendererCacheKey key) {
                return this.doCall(key);
            }

            @Generated
            public Class getaClass() {
                return ShortTypeHandling.castToClass((Object)this.aClass.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isContainerType_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.any(this.containerRenderers.keySet(), (Closure)new _isContainerType_closure1(this, this, aClass2));
    }

    public RendererCacheKey createCacheKey(Class type, MimeType mimeType) {
        return new RendererCacheKey(this, type, mimeType);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DefaultRendererRegistry.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DefaultRendererRegistry.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DefaultRendererRegistry.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultRendererRegistry.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public GrailsConventionGroovyPageLocator getGroovyPageLocator() {
        return this.groovyPageLocator;
    }

    @Generated
    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator grailsConventionGroovyPageLocator) {
        this.groovyPageLocator = grailsConventionGroovyPageLocator;
    }

    @Generated
    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    @Generated
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    @Generated
    public String getModelSuffix() {
        return this.modelSuffix;
    }

    @Generated
    public void setModelSuffix(String string) {
        this.modelSuffix = string;
    }

    @ToString
    @EqualsAndHashCode
    public class RendererCacheKey
    implements GroovyObject {
        private Class clazz;
        private MimeType mimeType;
        final /* synthetic */ DefaultRendererRegistry this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public RendererCacheKey(DefaultRendererRegistry $p$, Class clazz, MimeType mimeType) {
            MimeType mimeType2;
            Class clazz2;
            MetaClass metaClass;
            DefaultRendererRegistry defaultRendererRegistry;
            this.this$0 = defaultRendererRegistry = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.clazz = clazz2 = clazz;
            this.mimeType = mimeType2 = mimeType;
        }

        @Generated
        public RendererCacheKey(DefaultRendererRegistry $p$, Class clazz) {
            this($p$, clazz, null);
        }

        @Generated
        public RendererCacheKey(DefaultRendererRegistry $p$) {
            this($p$, null, null);
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("org.grails.plugins.web.rest.render.DefaultRendererRegistry$RendererCacheKey(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getClazz()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getMimeType()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getClazz(), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getClazz());
            }
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getMimeType(), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getMimeType());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof RendererCacheKey;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof RendererCacheKey)) {
                return false;
            }
            RendererCacheKey otherTyped = (RendererCacheKey)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getClazz(), (Object)otherTyped.getClazz())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getMimeType(), (Object)otherTyped.getMimeType()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$2(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(RendererCacheKey.class, DefaultRendererRegistry.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            this.this$0.this$dist$set$2(name, value);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultRendererRegistry.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$2(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(RendererCacheKey.class, DefaultRendererRegistry.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != RendererCacheKey.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Class getClazz() {
            return this.clazz;
        }

        @Generated
        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }

        @Generated
        public MimeType getMimeType() {
            return this.mimeType;
        }

        @Generated
        public void setMimeType(MimeType mimeType) {
            this.mimeType = mimeType;
        }
    }

    @ToString
    @EqualsAndHashCode
    public class ContainerRendererCacheKey
    implements GroovyObject {
        private Class containerType;
        private Class clazz;
        private MimeType mimeType;
        final /* synthetic */ DefaultRendererRegistry this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public ContainerRendererCacheKey(DefaultRendererRegistry $p$, Class containerType, Class clazz, MimeType mimeType) {
            MimeType mimeType2;
            Class clazz2;
            Class clazz3;
            MetaClass metaClass;
            DefaultRendererRegistry defaultRendererRegistry;
            this.this$0 = defaultRendererRegistry = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.containerType = clazz3 = containerType;
            this.clazz = clazz2 = clazz;
            this.mimeType = mimeType2 = mimeType;
        }

        @Generated
        public ContainerRendererCacheKey(DefaultRendererRegistry $p$, Class containerType, Class clazz) {
            this($p$, containerType, clazz, null);
        }

        @Generated
        public ContainerRendererCacheKey(DefaultRendererRegistry $p$, Class containerType) {
            this($p$, containerType, null, null);
        }

        @Generated
        public ContainerRendererCacheKey(DefaultRendererRegistry $p$) {
            this($p$, null, null, null);
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("org.grails.plugins.web.rest.render.DefaultRendererRegistry$ContainerRendererCacheKey(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getContainerType()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getClazz()));
            Boolean bl5 = $toStringFirst;
            if (bl5 == null ? false : bl5) {
                Boolean bl6;
                $toStringFirst = bl6 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getMimeType()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getContainerType(), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getContainerType());
            }
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getClazz(), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getClazz());
            }
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getMimeType(), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getMimeType());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof ContainerRendererCacheKey;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContainerRendererCacheKey)) {
                return false;
            }
            ContainerRendererCacheKey otherTyped = (ContainerRendererCacheKey)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getContainerType(), (Object)otherTyped.getContainerType())) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getClazz(), (Object)otherTyped.getClazz())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getMimeType(), (Object)otherTyped.getMimeType()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$2(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ContainerRendererCacheKey.class, DefaultRendererRegistry.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            this.this$0.this$dist$set$2(name, value);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultRendererRegistry.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$2(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ContainerRendererCacheKey.class, DefaultRendererRegistry.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ContainerRendererCacheKey.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Class getContainerType() {
            return this.containerType;
        }

        @Generated
        public void setContainerType(Class clazz) {
            this.containerType = clazz;
        }

        @Generated
        public Class getClazz() {
            return this.clazz;
        }

        @Generated
        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }

        @Generated
        public MimeType getMimeType() {
            return this.mimeType;
        }

        @Generated
        public void setMimeType(MimeType mimeType) {
            this.mimeType = mimeType;
        }
    }
}

