/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.mpp;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.mpp.FirExpectActualResolver;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibilityKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualMatcherTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "transformAnonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "anonymousInitializer", "data", "transformConstructor", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformMemberDeclaration", "", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
public class FirExpectActualMatcherTransformer
extends FirAbstractTreeTransformer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;

    public FirExpectActualMatcherTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(FirResolvePhase.EXPECT_ACTUAL_MATCHING);
        this.session = session2;
        this.scopeSession = scopeSession;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        this.transformMemberDeclaration(typeAlias);
        return typeAlias;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        this.transformMemberDeclaration(regularClass);
        regularClass.transformChildren(this, data);
        return regularClass;
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        this.transformMemberDeclaration(enumEntry);
        return enumEntry;
    }

    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        this.transformMemberDeclaration(property2);
        return property2;
    }

    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        this.transformMemberDeclaration(constructor2);
        return constructor2;
    }

    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        this.transformMemberDeclaration(simpleFunction);
        return simpleFunction;
    }

    @Override
    @NotNull
    public FirAnonymousInitializer transformAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)anonymousInitializer, (String)"anonymousInitializer");
        return anonymousInitializer;
    }

    private final void transformMemberDeclaration(FirMemberDeclaration memberDeclaration) {
        FirMemberDeclaration $this$isActual$iv = memberDeclaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        FirBasedSymbol<? extends FirDeclaration> actualSymbol = memberDeclaration.getSymbol();
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> map = FirExpectActualResolver.INSTANCE.findExpectForActual(actualSymbol, this.getSession(), this.scopeSession);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> expectForActualData = map;
        ExpectActualAttributesKt.setExpectForActual(memberDeclaration, expectForActualData);
        for (Map.Entry<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> entry : expectForActualData.entrySet()) {
            ExpectActualCompatibility<FirBasedSymbol<?>> compatibility = entry.getKey();
            List<FirBasedSymbol<?>> expectSymbols = entry.getValue();
            if (!ExpectActualCompatibilityKt.getCompatible(compatibility)) continue;
            for (FirBasedSymbol<?> expectSymbol : expectSymbols) {
                ExpectActualAttributesKt.setActualForExpect(expectSymbol.getFir(), this.getSession(), actualSymbol);
            }
        }
    }
}

