/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0012H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "()V", "functionalScopes", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "functionsStack", "", "varWithNameExistsInScopeOf", "", "function", "variableName", "", "visitFunction", "", "x", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Scope", "backend.js"})
public final class JsScopesCollector
extends RecursiveJsVisitor {
    @NotNull
    private final List<Scope> functionsStack;
    @NotNull
    private final Map<JsFunction, Scope> functionalScopes;

    public JsScopesCollector() {
        Object[] objectArray = new Scope[]{new Scope(null)};
        this.functionsStack = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(null, (Object)CollectionsKt.first(this.functionsStack))};
        this.functionalScopes = MapsKt.mutableMapOf((Pair[])objectArray);
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        super.visitVars(x);
        Scope currentScope2 = (Scope)CollectionsKt.last(this.functionsStack);
        List<JsVars.JsVar> list2 = x.getVars();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"x.vars");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            String string2 = it.getName().getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name.ident");
            currentScope2.add(string2);
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        String name;
        Scope scope2;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Scope parentScope = (Scope)CollectionsKt.last(this.functionsStack);
        Scope $this$visitFunction_u24lambda_u242 = scope2 = new Scope(parentScope);
        boolean bl = false;
        JsName jsName = x.getName();
        String string2 = name = jsName != null ? jsName.getIdent() : null;
        if (name != null) {
            $this$visitFunction_u24lambda_u242.add(name);
        }
        List<JsParameter> list2 = x.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"x.parameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsParameter it = (JsParameter)element$iv;
            boolean bl2 = false;
            String string3 = it.getName().getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name.ident");
            $this$visitFunction_u24lambda_u242.add(string3);
        }
        Scope newScope = scope2;
        UtilsKt.push(this.functionsStack, newScope);
        this.functionalScopes.put(x, newScope);
        super.visitFunction(x);
        UtilsKt.pop(this.functionsStack);
    }

    public final boolean varWithNameExistsInScopeOf(@Nullable JsFunction function2, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Scope scope2 = this.functionalScopes.get(function2);
        Intrinsics.checkNotNull((Object)scope2);
        return scope2.variableWithNameExists(variableName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "", "parent", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;)V", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "variables", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "add", "", "variableName", "variableWithNameExists", "", "backend.js"})
    private static final class Scope {
        @Nullable
        private final Scope parent;
        @NotNull
        private final HashSet<String> variables;

        public Scope(@Nullable Scope parent2) {
            this.parent = parent2;
            this.variables = new HashSet();
        }

        @Nullable
        public final Scope getParent() {
            return this.parent;
        }

        public final void add(@NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            this.variables.add(variableName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean variableWithNameExists(@NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            if (this.variables.contains(variableName)) return true;
            Scope scope2 = this.parent;
            if (scope2 == null) return false;
            if (!scope2.variableWithNameExists(variableName)) return false;
            return true;
        }
    }
}

