/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessorKt;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.IntervalMetaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodeInfo;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u0013J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;", "", "parameterSize", "", "(I)V", "localVarsMetaInfo", "Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarNodeWrapper;", "getLocalVarsMetaInfo", "()Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "<set-?>", "nextFreeLocalIndex", "getNextFreeLocalIndex", "()I", "setNextFreeLocalIndex", "tryBlocksMetaInfo", "Lorg/jetbrains/kotlin/codegen/inline/TryCatchBlockNodeInfo;", "getTryBlocksMetaInfo", "getEndNodes", "", "label", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getStartNodes", "instructionIndex", "inst", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "processInstruction", "", "curInstr", "directOrder", "", "sortTryCatchBlocks", "intervals", "substituteLocalVarTable", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "substituteTryBlockNodes", "backend"})
public abstract class CoveringTryCatchNodeProcessor {
    @NotNull
    private final IntervalMetaInfo<TryCatchBlockNodeInfo> tryBlocksMetaInfo = new IntervalMetaInfo(this);
    @NotNull
    private final IntervalMetaInfo<LocalVarNodeWrapper> localVarsMetaInfo = new IntervalMetaInfo(this);
    private int nextFreeLocalIndex;

    @NotNull
    public final IntervalMetaInfo<TryCatchBlockNodeInfo> getTryBlocksMetaInfo() {
        return this.tryBlocksMetaInfo;
    }

    @NotNull
    public final IntervalMetaInfo<LocalVarNodeWrapper> getLocalVarsMetaInfo() {
        return this.localVarsMetaInfo;
    }

    public final int getNextFreeLocalIndex() {
        return this.nextFreeLocalIndex;
    }

    @NotNull
    public final List<TryCatchBlockNodeInfo> getStartNodes(@NotNull LabelNode label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        Collection collection = this.tryBlocksMetaInfo.getIntervalStarts().get((Object)label);
        Intrinsics.checkExpressionValueIsNotNull(collection, "tryBlocksMetaInfo.intervalStarts.get(label)");
        return collection;
    }

    @NotNull
    public final List<TryCatchBlockNodeInfo> getEndNodes(@NotNull LabelNode label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        Collection collection = this.tryBlocksMetaInfo.getIntervalEnds().get((Object)label);
        Intrinsics.checkExpressionValueIsNotNull(collection, "tryBlocksMetaInfo.intervalEnds.get(label)");
        return collection;
    }

    public void processInstruction(@NotNull AbstractInsnNode curInstr, boolean directOrder) {
        Intrinsics.checkParameterIsNotNull(curInstr, "curInstr");
        if (curInstr instanceof VarInsnNode || curInstr instanceof IincInsnNode) {
            int argSize = InlineCodegenUtilsKt.getLoadStoreArgSize(curInstr.getOpcode());
            int varIndex = curInstr instanceof VarInsnNode ? ((VarInsnNode)curInstr).var : ((IincInsnNode)curInstr).var;
            this.nextFreeLocalIndex = Math.max(this.nextFreeLocalIndex, varIndex + argSize);
        }
        if (curInstr instanceof LabelNode) {
            this.tryBlocksMetaInfo.processCurrent((LabelNode)curInstr, directOrder);
            this.localVarsMetaInfo.processCurrent((LabelNode)curInstr, directOrder);
        }
    }

    public abstract int instructionIndex(@NotNull AbstractInsnNode var1);

    @NotNull
    public final List<TryCatchBlockNodeInfo> sortTryCatchBlocks(@NotNull List<TryCatchBlockNodeInfo> intervals) {
        Intrinsics.checkParameterIsNotNull(intervals, "intervals");
        Comparator comp2 = new Comparator<TryCatchBlockNodeInfo>(this){
            final /* synthetic */ CoveringTryCatchNodeProcessor this$0;

            /*
             * WARNING - void declaration
             */
            public final int compare(@NotNull TryCatchBlockNodeInfo t1, @NotNull TryCatchBlockNodeInfo t2) {
                void var3_3;
                Intrinsics.checkParameterIsNotNull(t1, "t1");
                Intrinsics.checkParameterIsNotNull(t2, "t2");
                int result2 = this.this$0.instructionIndex(t1.getHandler()) - this.this$0.instructionIndex(t2.getHandler());
                if (result2 == 0 && (result2 = this.this$0.instructionIndex(t1.getStartLabel()) - this.this$0.instructionIndex(t2.getStartLabel())) == 0) {
                    boolean bl = false;
                    if (_Assertions.ENABLED) {
                        String string = "Error: support multicatch finallies: " + t1.getHandler() + ", " + t2.getHandler();
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    result2 = this.this$0.instructionIndex(t1.getEndLabel()) - this.this$0.instructionIndex(t2.getEndLabel());
                }
                return (int)var3_3;
            }
            {
                this.this$0 = coveringTryCatchNodeProcessor;
            }
        };
        Collections.sort(intervals, comp2);
        return intervals;
    }

    public final void substituteTryBlockNodes(@NotNull MethodNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        node.tryCatchBlocks.clear();
        this.sortTryCatchBlocks((List<TryCatchBlockNodeInfo>)this.tryBlocksMetaInfo.getAllIntervals());
        for (TryCatchBlockNodeInfo info : CoveringTryCatchNodeProcessorKt.getMeaningfulIntervals(this.tryBlocksMetaInfo)) {
            node.tryCatchBlocks.add(info.getNode());
        }
    }

    public final void substituteLocalVarTable(@NotNull MethodNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        node.localVariables.clear();
        for (LocalVarNodeWrapper info : CoveringTryCatchNodeProcessorKt.getMeaningfulIntervals(this.localVarsMetaInfo)) {
            node.localVariables.add(info.getNode());
        }
    }

    public CoveringTryCatchNodeProcessor(int parameterSize) {
        this.nextFreeLocalIndex = parameterSize;
    }
}

