/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;

public class KtFunctionElementType
extends KtStubElementType<KotlinFunctionStub, KtNamedFunction> {
    public KtFunctionElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtNamedFunction.class, KotlinFunctionStub.class);
    }

    @Override
    public KotlinFunctionStub createStub(@NotNull KtNamedFunction psi, @NotNull StubElement parentStub) {
        boolean isTopLevel = psi.getParent() instanceof KtFile;
        boolean isExtension = psi.getReceiverTypeReference() != null;
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        boolean hasBlockBody = psi.hasBlockBody();
        boolean hasBody = psi.hasBody();
        return new KotlinFunctionStubImpl(parentStub, StringRef.fromString(psi.getName()), isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, psi.hasTypeParameterListBeforeFunctionName(), psi.mayHaveContract());
    }

    @Override
    public void serialize(@NotNull KotlinFunctionStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub2.getName());
        dataStream.writeBoolean(stub2.isTopLevel());
        FqName fqName2 = stub2.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        dataStream.writeBoolean(stub2.isExtension());
        dataStream.writeBoolean(stub2.hasBlockBody());
        dataStream.writeBoolean(stub2.hasBody());
        dataStream.writeBoolean(stub2.hasTypeParameterListBeforeFunctionName());
        dataStream.writeBoolean(stub2.mayHaveContract());
    }

    @Override
    @NotNull
    public KotlinFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        boolean isTopLevel = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        boolean isExtension = dataStream.readBoolean();
        boolean hasBlockBody = dataStream.readBoolean();
        boolean hasBody = dataStream.readBoolean();
        boolean hasTypeParameterListBeforeFunctionName = dataStream.readBoolean();
        boolean mayHaveContract = dataStream.readBoolean();
        return new KotlinFunctionStubImpl(parentStub, name, isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, hasTypeParameterListBeforeFunctionName, mayHaveContract);
    }

    @Override
    public void indexStub(@NotNull KotlinFunctionStub stub2, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexFunction(stub2, sink);
    }
}

