/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.declarations;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"getDefault", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "getIrValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "putDefault", "", "expressionBody", "ir.tree"})
public final class IrFunctionKt {
    @NotNull
    public static final IrValueParameter getIrValueParameter(@NotNull IrFunction $receiver, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Object object = $receiver.getValueParameters();
        int n = parameter.getIndex();
        if (n < 0 || n > CollectionsKt.getLastIndex(object)) {
            int it = n;
            throw (Throwable)((Object)new AssertionError((Object)("No IrValueParameter for " + parameter)));
        }
        object = object.get(n);
        IrValueParameter found = (IrValueParameter)object;
        boolean bl = Intrinsics.areEqual(found.getDescriptor(), parameter);
        if (_Assertions.ENABLED && !bl) {
            String string = "Parameter indices mismatch at " + $receiver.getDescriptor() + ": " + parameter + " != " + found.getDescriptor();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (IrValueParameter)object;
    }

    @Nullable
    public static final IrExpressionBody getDefault(@NotNull IrFunction $receiver, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return IrFunctionKt.getIrValueParameter($receiver, parameter).getDefaultValue();
    }

    public static final void putDefault(@NotNull IrFunction $receiver, @NotNull ValueParameterDescriptor parameter, @NotNull IrExpressionBody expressionBody) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(expressionBody, "expressionBody");
        IrFunctionKt.getIrValueParameter($receiver, parameter).setDefaultValue(expressionBody);
    }
}

