/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR5\u0010\t\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\n0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018R\u0011\u0010)\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isConstructorParameterWithDefault", "", "hasBackingField", "declaresDefaultValue", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;ZZZ)V", "annotationsWithArguments", "", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "getAnnotationsWithArguments", "()Ljava/util/List;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "genericIndex", "", "getGenericIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "()Z", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "name", "", "getName", "()Ljava/lang/String;", "optional", "getOptional", "serializableWith", "Lorg/jetbrains/kotlin/types/KotlinType;", "getSerializableWith", "()Lorg/jetbrains/kotlin/types/KotlinType;", "transient", "getTransient", "type", "getType", "kotlinx-serialization-compiler-plugin"})
public final class SerializableProperty {
    @NotNull
    private final PropertyDescriptor descriptor;
    private final boolean isConstructorParameterWithDefault;
    @NotNull
    private final String name;
    @NotNull
    private final KotlinType type;
    @Nullable
    private final Integer genericIndex;
    @NotNull
    private final ModuleDescriptor module;
    @Nullable
    private final KotlinType serializableWith;
    private final boolean optional;
    private final boolean transient;
    @NotNull
    private final List<Triple<ClassDescriptor, List<ValueArgument>, List<ValueParameterDescriptor>>> annotationsWithArguments;

    public SerializableProperty(@NotNull PropertyDescriptor descriptor, boolean isConstructorParameterWithDefault, boolean hasBackingField, boolean declaresDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        this.isConstructorParameterWithDefault = isConstructorParameterWithDefault;
        String string = KSerializationUtilKt.getSerialNameValue(this.descriptor.getAnnotations());
        if (string == null) {
            String string2 = this.descriptor.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name.asString()");
        }
        this.name = string;
        KotlinType kotlinType = this.descriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        this.type = kotlinType;
        this.genericIndex = KSerializationUtilKt.getGenericIndex(this.type);
        this.module = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.descriptor));
        KotlinType kotlinType2 = KSerializationUtilKt.getSerializableWith((DeclarationDescriptor)this.descriptor);
        if (kotlinType2 == null) {
            ClassDescriptor classDescriptor = TypeUtilKt.analyzeSpecialSerializers(this.module, this.descriptor.getAnnotations());
            kotlinType2 = (KotlinType)(classDescriptor != null ? classDescriptor.getDefaultType() : null);
        }
        this.serializableWith = kotlinType2;
        this.optional = !KSerializationUtilKt.getSerialRequired(this.descriptor.getAnnotations()) && declaresDefaultValue;
        this.transient = KSerializationUtilKt.getSerialTransient(this.descriptor.getAnnotations()) || !hasBackingField;
        this.annotationsWithArguments = SearchUtilsKt.annotationsWithArguments((Annotated)this.descriptor);
    }

    @NotNull
    public final PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final boolean isConstructorParameterWithDefault() {
        return this.isConstructorParameterWithDefault;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Nullable
    public final Integer getGenericIndex() {
        return this.genericIndex;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @Nullable
    public final KotlinType getSerializableWith() {
        return this.serializableWith;
    }

    public final boolean getOptional() {
        return this.optional;
    }

    public final boolean getTransient() {
        return this.transient;
    }

    @NotNull
    public final List<Triple<ClassDescriptor, List<ValueArgument>, List<ValueParameterDescriptor>>> getAnnotationsWithArguments() {
        return this.annotationsWithArguments;
    }
}

