/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/IdeaStandaloneExecutionSetup;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "checkInHeadlessMode", "", "doSetup", "cli"})
public final class IdeaStandaloneExecutionSetup {
    private static final Logger LOG;
    @NotNull
    public static final IdeaStandaloneExecutionSetup INSTANCE;

    public final void doSetup() {
        this.checkInHeadlessMode();
        System.getProperties().setProperty("project.structure.add.tools.jar.to.new.jdk", "false");
        System.getProperties().setProperty("psi.track.invalidation", "true");
        System.getProperties().setProperty("psi.incremental.reparse.depth.limit", "1000");
        System.getProperties().setProperty("ide.hide.excluded.files", "false");
        System.getProperties().setProperty("ast.loading.filter", "false");
        System.getProperties().setProperty("idea.ignore.disabled.plugins", "true");
        System.getProperties().setProperty("idea.home.path", System.getProperty("java.io.tmpdir"));
    }

    private final void checkInHeadlessMode() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        Application application2 = application;
        if (!application2.isHeadlessEnvironment()) {
            LOG.error(new Throwable("IdeaStandaloneExecutionSetup should be called only in headless environment"));
        }
    }

    private IdeaStandaloneExecutionSetup() {
    }

    static {
        IdeaStandaloneExecutionSetup ideaStandaloneExecutionSetup;
        INSTANCE = ideaStandaloneExecutionSetup = new IdeaStandaloneExecutionSetup();
        Logger logger = Logger.getInstance(IdeaStandaloneExecutionSetup.class);
        Intrinsics.checkNotNullExpressionValue(logger, "Logger.getInstance(IdeaS\u2026ecutionSetup::class.java)");
        LOG = logger;
    }
}

