/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderers;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0016J(\u0010\b\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\nH\u0016J(\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/MultiplatformDiagnosticRenderingMode;", "", "()V", "newLine", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderList", "elements", "", "Lkotlin/Function0;", "renderSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "indent", "", "checkers"})
public class MultiplatformDiagnosticRenderingMode {
    public void newLine(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullExpressionValue(sb.append('\n'), "append('\\n')");
    }

    public void renderList(@NotNull StringBuilder sb, @NotNull List<? extends Function0<Unit>> elements) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullExpressionValue(sb.append('\n'), "append('\\n')");
        for (Function0<Unit> function0 : elements) {
            function0.invoke();
        }
    }

    public void renderSymbol(@NotNull StringBuilder sb, @NotNull FirBasedSymbol<?> symbol2, @NotNull String indent) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(indent, "indent");
        sb.append(indent);
        sb.append("    ");
        StringBuilder stringBuilder2 = sb.append(FirDiagnosticRenderers.INSTANCE.getSYMBOL().render(symbol2));
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
    }
}

