/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;
import net.sf.log4jdbc.StatementSpy;

public class ResultSetSpy
implements ResultSet,
Spy {
    private final SpyLogDelegator log;
    private ResultSet realResultSet;
    private StatementSpy parent;
    public static final String classTypeDescription = "ResultSet";

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportAllReturns(String methodCall, String msg) {
        this.log.methodReturned(this, methodCall, msg);
    }

    public ResultSetSpy(StatementSpy parent, ResultSet realResultSet) {
        if (realResultSet == null) {
            throw new IllegalArgumentException("Must provide a non null real ResultSet");
        }
        this.realResultSet = realResultSet;
        this.parent = parent;
        this.log = SpyLogFactory.getSpyLogDelegator();
    }

    public String getClassType() {
        return classTypeDescription;
    }

    public int getConnectionNumber() {
        return this.parent.getConnectionNumber();
    }

    protected boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected byte reportReturn(String methodCall, byte value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected double reportReturn(String methodCall, double value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected short reportReturn(String methodCall, short value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected long reportReturn(String methodCall, long value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected float reportReturn(String methodCall, float value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected Object reportReturn(String methodCall, Object value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnName + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateAsciiStream(columnName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public int getRow() throws SQLException {
        String methodCall = "getRow()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getRow());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        String methodCall = "cancelRowUpdates()";
        try {
            this.realResultSet.cancelRowUpdates();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Time getTime(int columnIndex) throws SQLException {
        String methodCall = "getTime(" + columnIndex + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realResultSet.getTime(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(String columnName) throws SQLException {
        String methodCall = "getTime(" + columnName + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realResultSet.getTime(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + columnIndex + ", " + cal + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realResultSet.getTime(columnIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + columnName + ", " + cal + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.realResultSet.getTime(columnName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean absolute(int row) throws SQLException {
        String methodCall = "absolute(" + row + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.absolute(row));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String methodCall = "getTimestamp(" + columnIndex + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        String methodCall = "getTimestamp(" + columnName + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + columnIndex + ", " + cal + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + columnName + ", " + cal + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.realResultSet.getTimestamp(columnName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void moveToInsertRow() throws SQLException {
        String methodCall = "moveToInsertRow()";
        try {
            this.realResultSet.moveToInsertRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public boolean relative(int rows) throws SQLException {
        String methodCall = "relative(" + rows + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.relative(rows));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean previous() throws SQLException {
        String methodCall = "previous()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.previous());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void moveToCurrentRow() throws SQLException {
        String methodCall = "moveToCurrentRow()";
        try {
            this.realResultSet.moveToCurrentRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Ref getRef(int i) throws SQLException {
        String methodCall = "getRef(" + i + ")";
        try {
            return (Ref)this.reportReturn(methodCall, this.realResultSet.getRef(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        String methodCall = "updateRef(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateRef(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Ref getRef(String colName) throws SQLException {
        String methodCall = "getRef(" + colName + ")";
        try {
            return (Ref)this.reportReturn(methodCall, this.realResultSet.getRef(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        String methodCall = "updateRef(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateRef(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Blob getBlob(int i) throws SQLException {
        String methodCall = "getBlob(" + i + ")";
        try {
            return (Blob)this.reportReturn(methodCall, this.realResultSet.getBlob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBlob(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Blob getBlob(String colName) throws SQLException {
        String methodCall = "getBlob(" + colName + ")";
        try {
            return (Blob)this.reportReturn(methodCall, this.realResultSet.getBlob(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        String methodCall = "updateBlob(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBlob(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Clob getClob(int i) throws SQLException {
        String methodCall = "getClob(" + i + ")";
        try {
            return (Clob)this.reportReturn(methodCall, this.realResultSet.getClob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateClob(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Clob getClob(String colName) throws SQLException {
        String methodCall = "getClob(" + colName + ")";
        try {
            return (Clob)this.reportReturn(methodCall, this.realResultSet.getClob(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        String methodCall = "updateClob(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateClob(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String methodCall = "getBoolean(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBoolean(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean getBoolean(String columnName) throws SQLException {
        String methodCall = "getBoolean(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getBoolean(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Array getArray(int i) throws SQLException {
        String methodCall = "getArray(" + i + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.realResultSet.getArray(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        String methodCall = "updateArray(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateArray(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Array getArray(String colName) throws SQLException {
        String methodCall = "getArray(" + colName + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.realResultSet.getArray(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        String methodCall = "updateArray(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateArray(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public boolean isBeforeFirst() throws SQLException {
        String methodCall = "isBeforeFirst()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isBeforeFirst());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        String methodCall = "getShort(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getShort(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public short getShort(String columnName) throws SQLException {
        String methodCall = "getShort(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getShort(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        String methodCall = "getInt(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getInt(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int getInt(String columnName) throws SQLException {
        String methodCall = "getInt(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getInt(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.realResultSet.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return (ResultSetMetaData)this.reportReturn(methodCall, this.realResultSet.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int getType() throws SQLException {
        String methodCall = "getType()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getType());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        String methodCall = "getDouble(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDouble(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public double getDouble(String columnName) throws SQLException {
        String methodCall = "getDouble(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getDouble(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void deleteRow() throws SQLException {
        String methodCall = "deleteRow()";
        try {
            this.realResultSet.deleteRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public int getConcurrency() throws SQLException {
        String methodCall = "getConcurrency()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getConcurrency());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean rowUpdated() throws SQLException {
        String methodCall = "rowUpdated()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.rowUpdated());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        String methodCall = "getDate(" + columnIndex + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realResultSet.getDate(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(String columnName) throws SQLException {
        String methodCall = "getDate(" + columnName + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realResultSet.getDate(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + columnIndex + ", " + cal + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realResultSet.getDate(columnIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + columnName + ", " + cal + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.realResultSet.getDate(columnName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean last() throws SQLException {
        String methodCall = "last()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.last());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean rowInserted() throws SQLException {
        String methodCall = "rowInserted()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.rowInserted());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean rowDeleted() throws SQLException {
        String methodCall = "rowDeleted()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.rowDeleted());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        String methodCall = "updateNull(" + columnIndex + ")";
        try {
            this.realResultSet.updateNull(columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateNull(String columnName) throws SQLException {
        String methodCall = "updateNull(" + columnName + ")";
        try {
            this.realResultSet.updateNull(columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        String methodCall = "updateShort(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateShort(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        String methodCall = "updateShort(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateShort(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        String methodCall = "updateBoolean(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBoolean(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        String methodCall = "updateBoolean(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBoolean(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        String methodCall = "updateByte(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateByte(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        String methodCall = "updateByte(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateByte(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        String methodCall = "updateInt(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateInt(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        String methodCall = "updateInt(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateInt(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Object getObject(int columnIndex) throws SQLException {
        String methodCall = "getObject(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(String columnName) throws SQLException {
        String methodCall = "getObject(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(int i, Map map) throws SQLException {
        String methodCall = "getObject(" + i + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(i, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(String colName, Map map) throws SQLException {
        String methodCall = "getObject(" + colName + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getObject(colName, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean next() throws SQLException {
        String methodCall = "next()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.next());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        String methodCall = "updateLong(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateLong(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        String methodCall = "updateLong(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateLong(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        String methodCall = "updateFloat(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateFloat(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        String methodCall = "updateFloat(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateFloat(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        String methodCall = "updateDouble(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateDouble(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        String methodCall = "updateDouble(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateDouble(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public Statement getStatement() throws SQLException {
        String methodCall = "getStatement()";
        try {
            Statement s = this.realResultSet.getStatement();
            if (s == null) {
                return (Statement)this.reportReturn(methodCall, s);
            }
            return (Statement)this.reportReturn(methodCall, new StatementSpy(new ConnectionSpy(s.getConnection()), s));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        String methodCall = "updateString(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateString(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateString(String columnName, String x) throws SQLException {
        String methodCall = "updateString(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateString(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String methodCall = "getAsciiStream(" + columnIndex + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.realResultSet.getAsciiStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        String methodCall = "getAsciiStream(" + columnName + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.realResultSet.getAsciiStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        String methodCall = "updateBigDecimal(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public URL getURL(int columnIndex) throws SQLException {
        String methodCall = "getURL(" + columnIndex + ")";
        try {
            return (URL)this.reportReturn(methodCall, this.realResultSet.getURL(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        String methodCall = "updateBigDecimal(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBigDecimal(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public URL getURL(String columnName) throws SQLException {
        String methodCall = "getURL(" + columnName + ")";
        try {
            return (URL)this.reportReturn(methodCall, this.realResultSet.getURL(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        String methodCall = "updateBytes(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateBytes(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        String methodCall = "updateBytes(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateBytes(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String methodCall = "getUnicodeStream(" + columnIndex + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.realResultSet.getUnicodeStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        String methodCall = "getUnicodeStream(" + columnName + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.realResultSet.getUnicodeStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        String methodCall = "updateDate(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateDate(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        String methodCall = "updateDate(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateDate(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public int getFetchSize() throws SQLException {
        String methodCall = "getFetchSize()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getFetchSize());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return (SQLWarning)this.reportReturn(methodCall, this.realResultSet.getWarnings());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String methodCall = "getBinaryStream(" + columnIndex + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.realResultSet.getBinaryStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        String methodCall = "getBinaryStream(" + columnName + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.realResultSet.getBinaryStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.realResultSet.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        String methodCall = "updateTimestamp(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateTimestamp(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        String methodCall = "updateTimestamp(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateTimestamp(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public boolean first() throws SQLException {
        String methodCall = "first()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.first());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public String getCursorName() throws SQLException {
        String methodCall = "getCursorName()";
        try {
            return (String)this.reportReturn(methodCall, this.realResultSet.getCursorName());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int findColumn(String columnName) throws SQLException {
        String methodCall = "findColumn(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.findColumn(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean wasNull() throws SQLException {
        String methodCall = "wasNull()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.wasNull());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnName + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateBinaryStream(columnName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public String getString(int columnIndex) throws SQLException {
        String methodCall = "getString(" + columnIndex + ")";
        try {
            return (String)this.reportReturn(methodCall, this.realResultSet.getString(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public String getString(String columnName) throws SQLException {
        String methodCall = "getString(" + columnName + ")";
        try {
            return (String)this.reportReturn(methodCall, this.realResultSet.getString(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String methodCall = "getCharacterStream(" + columnIndex + ")";
        try {
            return (Reader)this.reportReturn(methodCall, this.realResultSet.getCharacterStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        String methodCall = "getCharacterStream(" + columnName + ")";
        try {
            return (Reader)this.reportReturn(methodCall, this.realResultSet.getCharacterStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        String methodCall = "setFetchDirection(" + direction + ")";
        try {
            this.realResultSet.setFetchDirection(direction);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.realResultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnName + ", " + reader + ", " + length + ")";
        try {
            this.realResultSet.updateCharacterStream(columnName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public byte getByte(int columnIndex) throws SQLException {
        String methodCall = "getByte(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getByte(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public byte getByte(String columnName) throws SQLException {
        String methodCall = "getByte(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getByte(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        String methodCall = "updateTime(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateTime(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        String methodCall = "updateTime(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateTime(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        String methodCall = "getBytes(" + columnIndex + ")";
        try {
            return (byte[])this.reportReturn(methodCall, this.realResultSet.getBytes(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public byte[] getBytes(String columnName) throws SQLException {
        String methodCall = "getBytes(" + columnName + ")";
        try {
            return (byte[])this.reportReturn(methodCall, this.realResultSet.getBytes(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean isAfterLast() throws SQLException {
        String methodCall = "isAfterLast()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isAfterLast());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ", " + scale + ")";
        try {
            this.realResultSet.updateObject(columnIndex, x, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ")";
        try {
            this.realResultSet.updateObject(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        String methodCall = "updateObject(" + columnName + ", " + x + ", " + scale + ")";
        try {
            this.realResultSet.updateObject(columnName, x, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        String methodCall = "updateObject(" + columnName + ", " + x + ")";
        try {
            this.realResultSet.updateObject(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public int getFetchDirection() throws SQLException {
        String methodCall = "getFetchDirection()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getFetchDirection());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        String methodCall = "getLong(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getLong(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public long getLong(String columnName) throws SQLException {
        String methodCall = "getLong(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getLong(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean isFirst() throws SQLException {
        String methodCall = "isFirst()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isFirst());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void insertRow() throws SQLException {
        String methodCall = "insertRow()";
        try {
            this.realResultSet.insertRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        String methodCall = "getFloat(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getFloat(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public float getFloat(String columnName) throws SQLException {
        String methodCall = "getFloat(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.realResultSet.getFloat(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public boolean isLast() throws SQLException {
        String methodCall = "isLast()";
        try {
            return this.reportReturn(methodCall, this.realResultSet.isLast());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        String methodCall = "setFetchSize(" + rows + ")";
        try {
            this.realResultSet.setFetchSize(rows);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void updateRow() throws SQLException {
        String methodCall = "updateRow()";
        try {
            this.realResultSet.updateRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void beforeFirst() throws SQLException {
        String methodCall = "beforeFirst()";
        try {
            this.realResultSet.beforeFirst();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + columnIndex + ", " + scale + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnIndex, scale));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + columnName + ", " + scale + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnName, scale));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String methodCall = "getBigDecimal(" + columnIndex + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        String methodCall = "getBigDecimal(" + columnName + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.realResultSet.getBigDecimal(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void afterLast() throws SQLException {
        String methodCall = "afterLast()";
        try {
            this.realResultSet.afterLast();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    public void refreshRow() throws SQLException {
        String methodCall = "refreshRow()";
        try {
            this.realResultSet.refreshRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

