/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TitleBox
extends AbstractTextBlock {
    private final String value;
    private final FontConfiguration fc;
    private final UText utext;

    public TitleBox(String value, FontConfiguration fc) {
        this.value = value;
        this.fc = fc.add(FontStyle.BOLD);
        this.utext = new UText(value, this.fc);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fc.getFont(), this.value);
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dimText = this.calculateDimension(ug.getStringBounder());
        ug.apply(new UTranslate(0.0, dimText.getHeight() - this.utext.getDescent(ug.getStringBounder()))).draw(this.utext);
    }
}

