/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.image.BufferedImage;
import java.util.Objects;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileImage
extends AbstractTextBlock
implements TextBlock {
    private final BufferedImage image;
    private final int vspace;

    public TileImage(BufferedImage image, ImgValign valign, int vspace) {
        this.image = Objects.requireNonNull(image);
        this.vspace = vspace;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.image.getWidth(), this.image.getHeight() + 2 * this.vspace);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(UTranslate.dy(this.vspace)).draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)));
    }
}

