/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.next;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.next.LinkedElement;
import net.sourceforge.plantuml.nwdiag.next.NwArray;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GridTextBlockSimple
implements TextBlock {
    protected final NwArray data;
    private final ISkinParam skinParam;

    public GridTextBlockSimple(int lines, int cols, ISkinParam skinParam) {
        this.skinParam = skinParam;
        this.data = new NwArray(lines, cols);
    }

    protected void drawGrid(UGraphic ug) {
    }

    @Override
    public void drawU(UGraphic ug) {
        this.drawGrid(ug);
        StringBounder stringBounder = ug.getStringBounder();
        double y = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            double lineHeight = this.lineHeight(stringBounder, i);
            double x = 0.0;
            for (int j = 0; j < this.data.getNbCols(); ++j) {
                double colWidth = this.colWidth(stringBounder, j);
                if (this.data.get(i, j) != null) {
                    this.data.get(i, j).drawMe(ug.apply(new UTranslate(x, y)), colWidth, lineHeight);
                }
                x += colWidth;
            }
            y += lineHeight;
        }
    }

    protected double colWidth(StringBounder stringBounder, int j) {
        double width = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            if (this.data.get(i, j) == null) continue;
            width = Math.max(width, this.data.get(i, j).naturalDimension(stringBounder).getWidth());
        }
        return width;
    }

    public double lineHeight(StringBounder stringBounder, int i) {
        double height = 50.0;
        for (int j = 0; j < this.data.getNbCols(); ++j) {
            if (this.data.get(i, j) == null) continue;
            height = Math.max(height, this.data.get(i, j).naturalDimension(stringBounder).getHeight());
        }
        return height;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.data.getNbLines() == 0) {
            return new XDimension2D(0.0, 0.0);
        }
        double height = 0.0;
        for (int i = 0; i < this.data.getNbLines(); ++i) {
            height += this.lineHeight(stringBounder, i);
        }
        double width = 0.0;
        for (int j = 0; j < this.data.getNbCols(); ++j) {
            width += this.colWidth(stringBounder, j);
        }
        return new XDimension2D(width, height);
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        throw new UnsupportedOperationException("member=" + member + " " + this.getClass().toString());
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public void add(int i, int j, LinkedElement value) {
        this.data.set(i, j, value);
    }

    protected final ISkinParam getSkinParam() {
        return this.skinParam;
    }
}

