/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import net.sourceforge.plantuml.awt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.awt.geom.XLine2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.LineRectIntersection;
import net.sourceforge.plantuml.posimo.Racorder;
import net.sourceforge.plantuml.posimo.RacorderAbstract;

public class RacorderOrthogonal
extends RacorderAbstract
implements Racorder {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DotPath getRacordIn(XRectangle2D rect, XLine2D tangeante) {
        XPoint2D in = tangeante.getP1();
        DotPath result = new DotPath();
        XPoint2D inter = null;
        if (in.getX() > rect.getMinX() && in.getX() < rect.getMaxX()) {
            if (in.getY() < rect.getMinY()) {
                inter = new XPoint2D(in.getX(), rect.getMinY());
            } else {
                if (!(in.getY() > rect.getMaxY())) throw new IllegalArgumentException();
                inter = new XPoint2D(in.getX(), rect.getMaxY());
            }
        } else if (in.getY() > rect.getMinY() && in.getY() < rect.getMaxY()) {
            if (in.getX() < rect.getMinX()) {
                inter = new XPoint2D(rect.getMinX(), in.getY());
            } else {
                if (!(in.getX() > rect.getMaxX())) throw new IllegalArgumentException();
                inter = new XPoint2D(rect.getMaxX(), in.getY());
            }
        } else {
            XPoint2D p1 = new XPoint2D(rect.getMinX(), rect.getMinY());
            XPoint2D p2 = new XPoint2D(rect.getMaxX(), rect.getMinY());
            XPoint2D p3 = new XPoint2D(rect.getMaxX(), rect.getMaxY());
            XPoint2D p4 = new XPoint2D(rect.getMinX(), rect.getMaxY());
            inter = LineRectIntersection.getCloser(tangeante.getP1(), p1, p2, p3, p4);
        }
        XCubicCurve2D curv = new XCubicCurve2D(tangeante.getX1(), tangeante.getY1(), tangeante.getX1(), tangeante.getY1(), inter.getX(), inter.getY(), inter.getX(), inter.getY());
        return result.addAfter(curv);
    }
}

