/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommonCommands;
import net.sourceforge.plantuml.command.PSystemCommandFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.command.CommandColorTask;
import net.sourceforge.plantuml.project.command.CommandFootbox;
import net.sourceforge.plantuml.project.command.CommandGanttArrow;
import net.sourceforge.plantuml.project.command.CommandGanttArrow2;
import net.sourceforge.plantuml.project.command.CommandGroupEnd;
import net.sourceforge.plantuml.project.command.CommandGroupStart;
import net.sourceforge.plantuml.project.command.CommandHideResourceFootbox;
import net.sourceforge.plantuml.project.command.CommandHideResourceName;
import net.sourceforge.plantuml.project.command.CommandLabelOnColumn;
import net.sourceforge.plantuml.project.command.CommandLanguage;
import net.sourceforge.plantuml.project.command.CommandNoteBottom;
import net.sourceforge.plantuml.project.command.CommandPrintBetween;
import net.sourceforge.plantuml.project.command.CommandPrintScale;
import net.sourceforge.plantuml.project.command.CommandSeparator;
import net.sourceforge.plantuml.project.command.CommandWeekNumberStrategy;
import net.sourceforge.plantuml.project.command.NaturalCommand;
import net.sourceforge.plantuml.project.lang.SentenceAnd;
import net.sourceforge.plantuml.project.lang.SentenceAndAnd;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.SubjectDayAsDate;
import net.sourceforge.plantuml.project.lang.SubjectDayOfWeek;
import net.sourceforge.plantuml.project.lang.SubjectDaysAsDates;
import net.sourceforge.plantuml.project.lang.SubjectProject;
import net.sourceforge.plantuml.project.lang.SubjectResource;
import net.sourceforge.plantuml.project.lang.SubjectSeparator;
import net.sourceforge.plantuml.project.lang.SubjectTask;
import net.sourceforge.plantuml.project.lang.SubjectToday;
import net.sourceforge.plantuml.style.CommandStyleImport;
import net.sourceforge.plantuml.style.CommandStyleMultilinesCSS;

public class GanttDiagramFactory
extends PSystemCommandFactory {
    private static final Collection<Command> cache = new ArrayList<Command>();

    private static final List<Subject> subjects() {
        return Arrays.asList(new SubjectTask(), new SubjectProject(), new SubjectDayOfWeek(), new SubjectDayAsDate(), new SubjectDaysAsDates(), new SubjectResource(), new SubjectToday(), new SubjectSeparator());
    }

    public GanttDiagramFactory(DiagramType type) {
        super(type);
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        CommonCommands.addTitleCommands(cmds);
        CommonCommands.addCommonCommands2(cmds);
        cmds.add(new CommandStyleMultilinesCSS());
        cmds.add(new CommandStyleImport());
        cmds.add(new CommandNope());
        cmds.addAll(GanttDiagramFactory.getLanguageCommands());
        cmds.add(new CommandGanttArrow());
        cmds.add(new CommandGanttArrow2());
        cmds.add(new CommandColorTask());
        cmds.add(new CommandSeparator());
        cmds.add(new CommandWeekNumberStrategy());
        cmds.add(new CommandGroupStart());
        cmds.add(new CommandGroupEnd());
        cmds.add(new CommandLanguage());
        cmds.add(new CommandPrintScale());
        cmds.add(new CommandPrintBetween());
        cmds.add(new CommandNoteBottom());
        cmds.add(new CommandFootbox());
        cmds.add(new CommandLabelOnColumn());
        cmds.add(new CommandHideResourceName());
        cmds.add(new CommandHideResourceFootbox());
        return cmds;
    }

    public static void clearCache() {
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Command> getLanguageCommands() {
        Collection<Command> collection = cache;
        synchronized (collection) {
            if (cache.size() == 0) {
                for (Subject subject : GanttDiagramFactory.subjects()) {
                    for (SentenceSimple sentenceSimple : subject.getSentences()) {
                        cache.add(NaturalCommand.create(sentenceSimple));
                        for (SentenceSimple sentenceSimple2 : subject.getSentences()) {
                            String string;
                            String signatureA = sentenceSimple.getSignature();
                            if (signatureA.equals(string = sentenceSimple2.getSignature())) continue;
                            cache.add(NaturalCommand.create(new SentenceAnd(sentenceSimple, sentenceSimple2)));
                        }
                    }
                }
                for (Subject subject : GanttDiagramFactory.subjects()) {
                    for (SentenceSimple sentenceSimple : subject.getSentences()) {
                        for (SentenceSimple sentenceSimple3 : subject.getSentences()) {
                            for (SentenceSimple sentenceSimple4 : subject.getSentences()) {
                                String signatureA = sentenceSimple.getSignature();
                                String signatureB = sentenceSimple3.getSignature();
                                String signatureC = sentenceSimple4.getSignature();
                                if (signatureA.equals(signatureB) || signatureA.equals(signatureC) || signatureC.equals(signatureB)) continue;
                                cache.add(NaturalCommand.create(new SentenceAndAnd(sentenceSimple, sentenceSimple3, sentenceSimple4)));
                            }
                        }
                    }
                }
            }
        }
        return cache;
    }

    @Override
    public GanttDiagram createEmptyDiagram(UmlSource source, Map<String, String> skinParam) {
        return new GanttDiagram(source);
    }
}

