/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Set;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TimeHeaderSimple
extends TimeHeader {
    private final TimeHeaderParameters colorDays;
    private final PrintScale printScale;
    private final Set<Day> verticalSeparators;

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight() + this.getHeaderNameDayHeight();
    }

    @Override
    public double getTimeHeaderHeight() {
        return 16.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 16.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    public TimeHeaderSimple(TimeHeaderParameters thParam, PrintScale printScale) {
        super(thParam.getTimelineStyle(), thParam.getClosedStyle(), thParam.getMin(), thParam.getMax(), new TimeScaleWink(thParam.getScale(), printScale), thParam.getColorSet());
        this.colorDays = thParam;
        this.printScale = printScale;
        this.verticalSeparators = thParam.getVerticalSeparatorBefore();
    }

    private boolean isBold(Day wink) {
        return this.verticalSeparators.contains(wink);
    }

    private void drawSeparatorsDay(UGraphic ug, TimeScale timeScale, double totalHeightWithoutFooter) {
        ULine vbar = ULine.vline(totalHeightWithoutFooter - this.getFullHeaderHeight() + 2.0);
        ug = this.goBold(ug).apply(UTranslate.dy(this.getFullHeaderHeight() - 1.0));
        Day i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            if (this.isBold(i)) {
                double x1 = timeScale.getStartingPosition(i);
                ug.apply(UTranslate.dx(x1)).draw(vbar);
            }
            i = i.increment(this.printScale);
        }
    }

    private void drawSmallVlinesDay(UGraphic ug, TimeScale timeScale, double totalHeightWithoutFooter) {
        ULine vbar = ULine.vline(totalHeightWithoutFooter);
        Day i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            double x1 = timeScale.getStartingPosition(i);
            ug.apply(this.getBarColor()).apply(UTranslate.dx(x1)).draw(vbar);
            i = i.increment(this.printScale);
        }
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale) {
        Day i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            int value = this.printScale == PrintScale.WEEKLY ? i.getAbsoluteDayNum() / 7 + 1 : i.getAbsoluteDayNum() + 1;
            TextBlock num = Display.getWithNewlines("" + value).create(this.getFontConfiguration(10, false, this.openFontColor()), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = this.printScale == PrintScale.WEEKLY ? timeScale.getEndingPosition(i.addDays(6)) : timeScale.getEndingPosition(i);
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.max.increment()) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            i = i.increment(this.printScale);
        }
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug.apply(UTranslate.dy(-3.0)), totalHeightWithoutFooter + 6.0);
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        this.drawSmallVlinesDay(ug, this.getTimeScale(), totalHeightWithoutFooter + 2.0);
        this.drawSeparatorsDay(ug, this.getTimeScale(), totalHeightWithoutFooter);
        this.drawSimpleDayCounter(ug, this.getTimeScale());
        ug.apply(this.getBarColor()).draw(ULine.hline(xmax - xmin));
        ug.apply(this.getBarColor()).apply(UTranslate.dy(this.getFullHeaderHeight() - 3.0)).draw(ULine.hline(xmax - xmin));
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawSmallVlinesDay(ug, this.getTimeScale(), this.getTimeFooterHeight() - 3.0);
        this.drawSimpleDayCounter(ug, this.getTimeScale());
        ug.apply(this.getBarColor()).draw(ULine.hline(xmax - xmin));
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight();
        Pending pending = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor back = this.colorDays.getColor(wink);
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            wink = wink.increment();
        }
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeaderSimple.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

