/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class MessageSelfArrow
extends Arrow {
    private final LivingParticipantBox p1;
    private final double deltaX;
    private final double deltaY;

    public MessageSelfArrow(double startingY, Rose skin, ArrowComponent arrow, LivingParticipantBox p1, double deltaY, Url url, double deltaX) {
        super(startingY, skin, arrow, url);
        this.p1 = p1;
        this.deltaY = deltaY;
        this.deltaX = deltaX;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredWidth(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UTranslate(this.getStartingX(stringBounder), this.getStartingY() + this.deltaY));
        Area area = new Area(new XDimension2D(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder)));
        area.setDeltaX1(this.deltaY);
        this.startUrl(ug);
        this.getArrowComponent().drawU(ug, area, context);
        this.endUrl(ug);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        double pos2 = this.p1.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
        return pos2 + this.deltaX;
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return 1;
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = this.getArrowComponent();
            XDimension2D dim = new XDimension2D(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dim).getY();
        }
        return this.getStartingY();
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = this.getArrowComponent();
            XDimension2D dim = new XDimension2D(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dim).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return super.toString();
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        return this.p1;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }
}

