/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.LinkAnchor;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.teoz.Bordered;
import net.sourceforge.plantuml.sequencediagram.teoz.CommonTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Dolls;
import net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.NewpageTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.UGraphicInterceptorTile;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PlayingSpace
implements Bordered {
    private final double startingY = 8.0;
    private final Real min;
    private final Real max;
    private final boolean isShowFootbox;
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final LivingSpaces livingSpaces;
    private final List<LinkAnchor> linkAnchors;
    private final ISkinParam skinParam;

    public PlayingSpace(SequenceDiagram diagram, Dolls dolls, TileArguments tileArguments) {
        this.livingSpaces = tileArguments.getLivingSpaces();
        this.linkAnchors = diagram.getLinkAnchors();
        this.skinParam = diagram.getSkinParam();
        ArrayList<Real> min2 = new ArrayList<Real>();
        ArrayList<Real> max2 = new ArrayList<Real>();
        min2.add(tileArguments.getXOrigin());
        max2.add(tileArguments.getXOrigin());
        if (dolls.size() > 0) {
            min2.add(dolls.getMinX(tileArguments.getStringBounder()));
            max2.add(dolls.getMaxX(tileArguments.getStringBounder()));
        }
        YGauge ycurrent = YGauge.create(tileArguments.getYOrigin().addAtLeast(0.0), 0.0);
        this.tiles.addAll(TileBuilder.buildSeveral(diagram.events().iterator(), tileArguments, null, ycurrent));
        for (Tile tile : this.tiles) {
            min2.add(tile.getMinX());
            max2.add(tile.getMaxX());
        }
        for (LivingSpace livingSpace : this.livingSpaces.values()) {
            max2.add(livingSpace.getPosD(tileArguments.getStringBounder()));
            max2.add(livingSpace.getPosC2(tileArguments.getStringBounder()));
        }
        this.min = RealUtils.min(min2);
        this.max = RealUtils.max(max2);
        this.isShowFootbox = diagram.isShowFootbox();
    }

    public void drawBackground(UGraphic ug) {
        UGraphicInterceptorTile interceptor = new UGraphicInterceptorTile(ug, true);
        this.drawUInternal(interceptor, false);
    }

    public void drawForeground(UGraphic ug) {
        UGraphicInterceptorTile interceptor = new UGraphicInterceptorTile(ug, false);
        this.drawUInternal(interceptor, false);
    }

    private double drawUInternal(UGraphic ug, boolean trace) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrayList<CommonTile> local = new ArrayList<CommonTile>();
        ArrayList<CommonTile> full = new ArrayList<CommonTile>();
        TimeHook y = GroupingTile.fillPositionelTiles(stringBounder, new TimeHook(8.0), this.tiles, local, full);
        for (CommonTile tile : local) {
            double posy = tile.getTimeHook().getValue();
            tile.drawU(ug.apply(UTranslate.dy(posy)));
        }
        for (LinkAnchor linkAnchor : this.linkAnchors) {
            CommonTile ytile1 = this.getFromAnchor(full, linkAnchor.getAnchor1());
            CommonTile ytile2 = this.getFromAnchor(full, linkAnchor.getAnchor2());
            if (ytile1 == null || ytile2 == null) continue;
            linkAnchor.drawAnchor(ug, ytile1, ytile2, this.skinParam);
        }
        return y.getValue();
    }

    private CommonTile getFromAnchor(List<CommonTile> positionedTiles, String anchor) {
        for (CommonTile ytile : positionedTiles) {
            if (!ytile.matchAnchor(anchor)) continue;
            return ytile;
        }
        return null;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        LimitFinder limitFinder = LimitFinder.create(stringBounder, true);
        UGraphicInterceptorTile interceptor = new UGraphicInterceptorTile(limitFinder, false);
        double finalY = this.drawUInternal(interceptor, false);
        double result = Math.max(limitFinder.getMinMax().getDimension().getHeight(), finalY) + 10.0;
        return result;
    }

    public void addConstraints() {
        for (Tile tile : this.tiles) {
            tile.addConstraints();
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }

    public boolean isShowFootbox() {
        return this.isShowFootbox;
    }

    public LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    @Override
    public double getBorder1() {
        return this.min.getCurrentValue();
    }

    @Override
    public double getBorder2() {
        return this.max.getCurrentValue();
    }

    public List<Double> yNewPages() {
        ArrayList<Double> yNewPages = new ArrayList<Double>();
        yNewPages.add(0.0);
        for (Tile tile : this.tiles) {
            if (tile instanceof GroupingTile) {
                ((GroupingTile)tile).addYNewPages(yNewPages);
            }
            if (!(tile instanceof NewpageTile)) continue;
            double y = ((NewpageTile)tile).getTimeHook().getValue();
            yNewPages.add(y);
        }
        yNewPages.add((Double)Double.MAX_VALUE);
        return yNewPages;
    }

    public int getNbPages() {
        return this.yNewPages().size() - 1;
    }
}

