/*
 * Decompiled with CFR 0.152.
 */
package gen.lib.common;

import gen.annotation.Doc;
import gen.annotation.Original;
import gen.annotation.Reviewed;
import gen.annotation.Unused;
import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.obj__c;
import gen.lib.cgraph.refstr__c;
import gen.lib.common.labels__c;
import gen.lib.common.shapes__c;
import gen.lib.common.strcasecmp__c;
import h.EN_shape_kind;
import h.ST_Agedge_s;
import h.ST_Agnode_s;
import h.ST_Agraph_s;
import h.ST_Agsym_s;
import h.ST_bezier;
import h.ST_boxf;
import h.ST_fontinfo;
import h.ST_nodequeue;
import h.ST_pointf;
import h.ST_port;
import h.ST_splines;
import h.ST_textlabel_t;
import smetana.core.CArray;
import smetana.core.CArrayOfStar;
import smetana.core.CFunction;
import smetana.core.CString;
import smetana.core.JUtils;
import smetana.core.Macro;
import smetana.core.Memory;
import smetana.core.Z;
import smetana.core.__ptr__;
import smetana.core.__struct__;
import smetana.core.debug.SmetanaDebug;

public class utils__c {
    private static final int W_DEGREE = 5;

    @Reviewed(when="15/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="", key="c7cptalfn8k75wyfirbnptnav", definition="nodequeue *new_queue(int sz)")
    public static ST_nodequeue new_queue(int sz) {
        SmetanaDebug.ENTERING("c7cptalfn8k75wyfirbnptnav", "new_queue");
        try {
            ST_nodequeue q = new ST_nodequeue();
            if (sz <= 1) {
                sz = 2;
            }
            q.store = CArrayOfStar.ALLOC(sz, ST_Agnode_s.class);
            q.tail = q.store;
            q.head = q.store;
            q.limit = q.store.plus_(sz);
            ST_nodequeue sT_nodequeue = q;
            return sT_nodequeue;
        }
        finally {
            SmetanaDebug.LEAVING("c7cptalfn8k75wyfirbnptnav", "new_queue");
        }
    }

    @Reviewed(when="15/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="free_queue", key="1uj5nmdvwmuklnpd3v5py547f", definition="void free_queue(nodequeue * q)")
    public static void free_queue(ST_nodequeue q) {
        SmetanaDebug.ENTERING("1uj5nmdvwmuklnpd3v5py547f", "free_queue");
        try {
            Memory.free(q.store);
            Memory.free(q);
        }
        finally {
            SmetanaDebug.LEAVING("1uj5nmdvwmuklnpd3v5py547f", "free_queue");
        }
    }

    @Reviewed(when="15/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="enqueue", key="20pwd6i141q3o25lfvrdqytot", definition="void enqueue(nodequeue * q, node_t * n)")
    public static void enqueue(ST_nodequeue q, ST_Agnode_s n) {
        SmetanaDebug.ENTERING("20pwd6i141q3o25lfvrdqytot", "enqueue");
        try {
            q.tail.set_(0, n);
            q.tail = q.tail.plus_(1);
            if (q.tail.comparePointer_(q.limit) >= 0) {
                q.tail = q.store;
            }
        }
        finally {
            SmetanaDebug.LEAVING("20pwd6i141q3o25lfvrdqytot", "enqueue");
        }
    }

    @Reviewed(when="15/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="", key="b612nmtf16au96ztbs8pike9r", definition="node_t *dequeue(nodequeue * q)")
    public static ST_Agnode_s dequeue(ST_nodequeue q) {
        SmetanaDebug.ENTERING("b612nmtf16au96ztbs8pike9r", "dequeue");
        try {
            ST_Agnode_s n;
            if (JUtils.EQ(q.head, q.tail)) {
                n = null;
            } else {
                n = q.head.get_(0);
                q.head = q.head.plus_(1);
                if (q.head.comparePointer_(q.limit) >= 0) {
                    q.head = q.store;
                }
            }
            ST_Agnode_s sT_Agnode_s = n;
            return sT_Agnode_s;
        }
        finally {
            SmetanaDebug.LEAVING("b612nmtf16au96ztbs8pike9r", "dequeue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="late_int", key="6nydxv4f2m7jcfh8ljs0neu0x", definition="int late_int(void *obj, attrsym_t * attr, int def, int low)")
    public static int late_int(__ptr__ obj, ST_Agsym_s attr, int def, int low) {
        SmetanaDebug.ENTERING("6nydxv4f2m7jcfh8ljs0neu0x", "late_int");
        try {
            CString[] endp = new CString[1];
            if (attr == null) {
                int n = def;
                return n;
            }
            CString p = attr__c.agxget(obj, attr);
            if (Macro.N(p) || p.length() == 0) {
                int n = def;
                return n;
            }
            int rv = JUtils.strtol(p, endp, 10);
            if (JUtils.EQ(p, endp[0])) {
                int n = def;
                return n;
            }
            if (rv < low) {
                int n = low;
                return n;
            }
            int n = rv;
            return n;
        }
        finally {
            SmetanaDebug.LEAVING("6nydxv4f2m7jcfh8ljs0neu0x", "late_int");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="late_double", key="d68314e4f20r79tt0cnmxugme", definition="double late_double(void *obj, attrsym_t * attr, double def, double low)")
    public static double late_double(__ptr__ obj, ST_Agsym_s attr, double def, double low) {
        SmetanaDebug.ENTERING("d68314e4f20r79tt0cnmxugme", "late_double");
        try {
            CString[] endp = new CString[1];
            if (Macro.N(attr) || Macro.N(obj)) {
                double d = def;
                return d;
            }
            CString p = attr__c.agxget(obj, attr);
            if (Macro.N(p) || p.charAt(0) == '\u0000') {
                double d = def;
                return d;
            }
            double rv = JUtils.strtod(p, endp);
            if (p == endp[0]) {
                double d = def;
                return d;
            }
            if (rv < low) {
                double d = low;
                return d;
            }
            double d = rv;
            return d;
        }
        finally {
            SmetanaDebug.LEAVING("d68314e4f20r79tt0cnmxugme", "late_double");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="late_string", key="83xm6yc9q5h1bzufhsnv0v2up", definition="char *late_string(void *obj, attrsym_t * attr, char *def)")
    public static CString late_string(__ptr__ obj, ST_Agsym_s attr, CString def) {
        SmetanaDebug.ENTERING("83xm6yc9q5h1bzufhsnv0v2up", "late_string");
        try {
            if (Macro.N(attr) || Macro.N(obj)) {
                CString cString = def;
                return cString;
            }
            CString cString = attr__c.agxget(obj, attr);
            return cString;
        }
        finally {
            SmetanaDebug.LEAVING("83xm6yc9q5h1bzufhsnv0v2up", "late_string");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="", key="8oon4q1mrublaru177xfntqgd", definition="char *late_nnstring(void *obj, attrsym_t * attr, char *def)")
    public static CString late_nnstring(__ptr__ obj, ST_Agsym_s attr, CString def) {
        SmetanaDebug.ENTERING("8oon4q1mrublaru177xfntqgd", "late_nnstring");
        try {
            CString rv = utils__c.late_string(obj, attr, def);
            if (Macro.N(rv) || rv.charAt(0) == '\u0000') {
                rv = def;
            }
            CString cString = rv;
            return cString;
        }
        finally {
            SmetanaDebug.LEAVING("8oon4q1mrublaru177xfntqgd", "late_nnstring");
        }
    }

    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="late_bool", key="87ifze04q7qzigjj1fb9y9by2", definition="boolean late_bool(void *obj, attrsym_t * attr, int def)")
    public static boolean late_bool(__ptr__ obj, ST_Agsym_s attr, int def) {
        SmetanaDebug.ENTERING("87ifze04q7qzigjj1fb9y9by2", "late_bool");
        try {
            if (attr == null) {
                boolean bl = def != 0;
                return bl;
            }
            Macro.UNSUPPORTED("a0kh1y5n8u59z0xo7mag3zmt6");
            Macro.UNSUPPORTED("c24nfmv9i7o5eoqaymbibp7m7");
            throw new UnsupportedOperationException();
        }
        finally {
            SmetanaDebug.LEAVING("87ifze04q7qzigjj1fb9y9by2", "late_bool");
        }
    }

    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="", key="aeq0acpkhfv3gd5jx8op4jf18", definition="node_t *UF_find(node_t * n)")
    public static ST_Agnode_s UF_find(ST_Agnode_s n) {
        SmetanaDebug.ENTERING("aeq0acpkhfv3gd5jx8op4jf18", "UF_find");
        try {
            while (Macro.ND_UF_parent(n) != null && JUtils.NEQ(Macro.ND_UF_parent(n), n)) {
                if (Macro.ND_UF_parent(Macro.ND_UF_parent(n)) != null) {
                    Macro.ND_UF_parent(n, Macro.ND_UF_parent(Macro.ND_UF_parent(n)));
                }
                n = Macro.ND_UF_parent(n);
            }
            ST_Agnode_s sT_Agnode_s = n;
            return sT_Agnode_s;
        }
        finally {
            SmetanaDebug.LEAVING("aeq0acpkhfv3gd5jx8op4jf18", "UF_find");
        }
    }

    @Reviewed(when="14/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="", key="9ldxwfr4vvijrvfcvs1hvdzrt", definition="node_t *UF_union(node_t * u, node_t * v)")
    public static ST_Agnode_s UF_union(ST_Agnode_s u, ST_Agnode_s v) {
        SmetanaDebug.ENTERING("9ldxwfr4vvijrvfcvs1hvdzrt", "UF_union");
        try {
            if (JUtils.EQ(u, v)) {
                ST_Agnode_s sT_Agnode_s = u;
                return sT_Agnode_s;
            }
            if (Macro.ND_UF_parent(u) == null) {
                Macro.ND_UF_parent(u, u);
                Macro.ND_UF_size(u, 1);
            } else {
                Macro.UNSUPPORTED("35c97tyk6tzw1g527j6rp6xoo");
            }
            if (Macro.ND_UF_parent(v) == null) {
                Macro.ND_UF_parent(v, v);
                Macro.ND_UF_size(v, 1);
            } else {
                v = utils__c.UF_find(v);
            }
            if (Macro.ND_id(u) > Macro.ND_id(v)) {
                Macro.UNSUPPORTED("2igr3ntnkm6svji4pbnjlp54e");
                Macro.UNSUPPORTED("3lht90i6tvxbr10meir8nvcic");
            } else {
                Macro.ND_UF_parent(v, u);
                Macro.ND_UF_size(u, Macro.ND_UF_size(u) + Macro.ND_UF_size(v));
                v = u;
            }
            ST_Agnode_s sT_Agnode_s = v;
            return sT_Agnode_s;
        }
        finally {
            SmetanaDebug.LEAVING("9ldxwfr4vvijrvfcvs1hvdzrt", "UF_union");
        }
    }

    @Reviewed(when="14/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="UF_singleton", key="22k0u1imxyw06k9rizqlfz153", definition="void UF_singleton(node_t * u)")
    public static void UF_singleton(ST_Agnode_s u) {
        SmetanaDebug.ENTERING("22k0u1imxyw06k9rizqlfz153", "UF_singleton");
        try {
            Macro.ND_UF_size(u, 1);
            Macro.ND_UF_parent(u, null);
            Macro.ND_ranktype(u, 0);
        }
        finally {
            SmetanaDebug.LEAVING("22k0u1imxyw06k9rizqlfz153", "UF_singleton");
        }
    }

    @Reviewed(when="14/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="UF_setname", key="e0fn8xuzkdt0q8xoofl6j1txb", definition="void UF_setname(node_t * u, node_t * v)")
    public static void UF_setname(ST_Agnode_s u, ST_Agnode_s v) {
        SmetanaDebug.ENTERING("e0fn8xuzkdt0q8xoofl6j1txb", "UF_setname");
        try {
            assert (JUtils.EQ(u, utils__c.UF_find(u)));
            Macro.ND_UF_parent(u, v);
            Macro.ND_UF_size(v, Macro.ND_UF_size(v) + Macro.ND_UF_size(u));
        }
        finally {
            SmetanaDebug.LEAVING("e0fn8xuzkdt0q8xoofl6j1txb", "UF_setname");
        }
    }

    @Unused
    @Original(version="2.38.0", path="lib/common/utils.c", name="Bezier", key="6p0ey2c2ujk2o7h221p0b4xon", definition="pointf Bezier(pointf * V, int degree, double t, pointf * Left, pointf * Right)")
    public static ST_pointf Bezier(CArray<ST_pointf> V, int degree, double t, CArray<ST_pointf> Left, CArray<ST_pointf> Right) {
        return utils__c.Bezier_w_(V, degree, t, Left, Right).copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ST_pointf Bezier_w_(CArray<ST_pointf> V, int degree, double t, CArray<ST_pointf> Left, CArray<ST_pointf> Right) {
        SmetanaDebug.ENTERING("6p0ey2c2ujk2o7h221p0b4xon", "Bezier");
        try {
            int j;
            CArray[] Vtemp = new CArray[]{CArray.ALLOC__(6, ST_pointf.class), CArray.ALLOC__(6, ST_pointf.class), CArray.ALLOC__(6, ST_pointf.class), CArray.ALLOC__(6, ST_pointf.class), CArray.ALLOC__(6, ST_pointf.class), CArray.ALLOC__(6, ST_pointf.class)};
            for (j = 0; j <= degree; ++j) {
                ((ST_pointf)Vtemp[0].get__(j)).___((__struct__)V.get__(j));
            }
            for (int i = 1; i <= degree; ++i) {
                for (j = 0; j <= degree - i; ++j) {
                    ((ST_pointf)Vtemp[i].get__((int)j)).x = (1.0 - t) * ((ST_pointf)Vtemp[i - 1].get__((int)j)).x + t * ((ST_pointf)Vtemp[i - 1].get__((int)(j + 1))).x;
                    ((ST_pointf)Vtemp[i].get__((int)j)).y = (1.0 - t) * ((ST_pointf)Vtemp[i - 1].get__((int)j)).y + t * ((ST_pointf)Vtemp[i - 1].get__((int)(j + 1))).y;
                }
            }
            if (Left != null) {
                for (j = 0; j <= degree; ++j) {
                    Left.get__(j).___((__struct__)Vtemp[j].get__(0));
                }
            }
            if (Right != null) {
                for (j = 0; j <= degree; ++j) {
                    Right.get__(j).___((__struct__)Vtemp[degree - j].get__(j));
                }
            }
            ST_pointf sT_pointf = (ST_pointf)Vtemp[degree].get__(0);
            return sT_pointf;
        }
        finally {
            SmetanaDebug.LEAVING("6p0ey2c2ujk2o7h221p0b4xon", "Bezier");
        }
    }

    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="", key="3xll2b0v9nthwvx9dafq49t8s", definition="const char *safefile(const char *filename)")
    public static CString safefile(CString filename) {
        SmetanaDebug.ENTERING("3xll2b0v9nthwvx9dafq49t8s", "safefile");
        try {
            CString cString = null;
            return cString;
        }
        finally {
            SmetanaDebug.LEAVING("3xll2b0v9nthwvx9dafq49t8s", "safefile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="maptoken", key="2ihv17oajyaaaycirwsbgz1m7", definition="int maptoken(char *p, char **name, int *val)")
    public static int maptoken(CString p, CString[] name, int[] val) {
        SmetanaDebug.ENTERING("2ihv17oajyaaaycirwsbgz1m7", "maptoken");
        try {
            CString q;
            int i = 0;
            while (!((q = name[i]) == null || p != null && Macro.N(JUtils.strcmp(p, q)))) {
                ++i;
            }
            int n = val[i];
            return n;
        }
        finally {
            SmetanaDebug.LEAVING("2ihv17oajyaaaycirwsbgz1m7", "maptoken");
        }
    }

    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="mapBool", key="4esyuq2yqdaqoddgfqs24m5m3", definition="boolean mapBool(char *p, boolean dflt)")
    public static boolean mapBool(CString p, boolean dflt) {
        SmetanaDebug.ENTERING("4esyuq2yqdaqoddgfqs24m5m3", "mapBool");
        try {
            if (Macro.N(p) || p.charAt(0) == '\u0000') {
                boolean bl = dflt;
                return bl;
            }
            if (Macro.N(strcasecmp__c.strcasecmp(p, new CString("false")))) {
                boolean bl = false;
                return bl;
            }
            if (Macro.N(strcasecmp__c.strcasecmp(p, new CString("no")))) {
                boolean bl = false;
                return bl;
            }
            if (Macro.N(strcasecmp__c.strcasecmp(p, new CString("true")))) {
                boolean bl = Macro.N(0);
                return bl;
            }
            if (Macro.N(strcasecmp__c.strcasecmp(p, new CString("yes")))) {
                boolean bl = Macro.N(0);
                return bl;
            }
            if (JUtils.isdigit(p.charAt(0))) {
                boolean bl = JUtils.atoi(p) != 0;
                return bl;
            }
            boolean bl = dflt;
            return bl;
        }
        finally {
            SmetanaDebug.LEAVING("4esyuq2yqdaqoddgfqs24m5m3", "mapBool");
        }
    }

    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="mapbool", key="ehkvqh6bwf4jw3mj1w5p7a8m8", definition="boolean mapbool(char *p)")
    public static boolean mapbool(CString p) {
        SmetanaDebug.ENTERING("ehkvqh6bwf4jw3mj1w5p7a8m8", "mapbool");
        try {
            boolean bl = utils__c.mapBool(p, false);
            return bl;
        }
        finally {
            SmetanaDebug.LEAVING("ehkvqh6bwf4jw3mj1w5p7a8m8", "mapbool");
        }
    }

    @Unused
    @Original(version="2.38.0", path="lib/common/utils.c", name="dotneato_closest", key="37hgj44s94wf9bmz16he85pgq", definition="pointf dotneato_closest(splines * spl, pointf pt)")
    public static ST_pointf dotneato_closest(ST_splines spl, ST_pointf pt) {
        SmetanaDebug.ENTERING("37hgj44s94wf9bmz16he85pgq", "dotneato_closest");
        try {
            ST_pointf sT_pointf = utils__c.dotneato_closest_(spl, pt.copy()).copy();
            return sT_pointf;
        }
        finally {
            SmetanaDebug.LEAVING("37hgj44s94wf9bmz16he85pgq", "dotneato_closest");
        }
    }

    private static ST_pointf dotneato_closest_(ST_splines spl, ST_pointf pt) {
        int j;
        CArray<ST_pointf> c = CArray.ALLOC__(4, ST_pointf.class);
        ST_pointf pt2 = new ST_pointf();
        ST_bezier bz = new ST_bezier();
        int bestj = -1;
        int besti = -1;
        double bestdist2 = 1.0E38;
        for (int i = 0; i < spl.size; ++i) {
            bz.___((__struct__)spl.list.get__(i));
            for (j = 0; j < bz.size; ++j) {
                ST_pointf b = new ST_pointf();
                b.x = bz.list.get__((int)j).x;
                b.y = bz.list.get__((int)j).y;
                double d2 = Macro.DIST2(b, pt);
                if (bestj != -1 && !(d2 < bestdist2)) continue;
                besti = i;
                bestj = j;
                bestdist2 = d2;
            }
        }
        bz.___((__struct__)spl.list.get__(besti));
        if (bestj == bz.size - 1) {
            --bestj;
        }
        j = 3 * (bestj / 3);
        for (int k = 0; k < 4; ++k) {
            c.get__((int)k).x = bz.list.get__((int)(j + k)).x;
            c.get__((int)k).y = bz.list.get__((int)(j + k)).y;
        }
        double low = 0.0;
        double high = 1.0;
        double dlow2 = Macro.DIST2(c.get__(0), pt);
        double dhigh2 = Macro.DIST2(c.get__(3), pt);
        while (true) {
            double t = (low + high) / 2.0;
            pt2.___((__struct__)utils__c.Bezier(c, 3, t, null, null));
            if (Macro.fabs(dlow2 - dhigh2) < 1.0 || Macro.fabs(high - low) < 1.0E-5) break;
            Macro.UNSUPPORTED("6apa9aoby9j8a0eanbfhy5mn2");
            Macro.UNSUPPORTED("6jttyuryfaxa193mme86dqf58");
            Macro.UNSUPPORTED("6avwplrum9i9qi3g9wl6yvz04");
            Macro.UNSUPPORTED("7yhr8hn3r6wohafwxrt85b2j2");
            Macro.UNSUPPORTED("556vs5i22602clhs1p3htz7vk");
            Macro.UNSUPPORTED("507tgq81szei2ge3miiak4b1v");
            Macro.UNSUPPORTED("flupwh3kosf3fkhkxllllt1");
        }
        return pt2;
    }

    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="common_init_node", key="cr81drt18h5feqzxyh3jb0u49", definition="void common_init_node(node_t * n)")
    public static void common_init_node(ST_Agnode_s n) {
        SmetanaDebug.ENTERING("cr81drt18h5feqzxyh3jb0u49", "common_init_node");
        try {
            ST_fontinfo fi = new ST_fontinfo();
            Macro.ND_width(n, utils__c.late_double(n, Z.z().N_width, 0.75, 0.01));
            Macro.ND_height(n, utils__c.late_double(n, Z.z().N_height, 0.5, 0.02));
            Macro.ND_shape(n, shapes__c.bind_shape(utils__c.late_nnstring(n, Z.z().N_shape, new CString("ellipse")), n));
            CString str = attr__c.agxget(n, Z.z().N_label);
            fi.fontsize = utils__c.late_double(n, Z.z().N_fontsize, 14.0, 1.0);
            fi.fontname = utils__c.late_nnstring(n, Z.z().N_fontname, new CString("Times-Roman"));
            fi.fontcolor = utils__c.late_nnstring(n, Z.z().N_fontcolor, new CString("black"));
            Macro.ND_label(n, labels__c.make_label(n, str, (refstr__c.aghtmlstr(str) != 0 ? 2 : 0) | (shapes__c.shapeOf(n) == EN_shape_kind.SH_RECORD ? 4 : 0), fi.fontsize, fi.fontname, fi.fontcolor));
            if (Z.z().N_xlabel != null && (str = attr__c.agxget(n, Z.z().N_xlabel)) != null && str.charAt(0) != '\u0000') {
                Macro.UNSUPPORTED("4ua9vld76wpovsm1celv2ff6e");
                Macro.UNSUPPORTED("b0zm6fkpjlt9jacykbgugjodg");
                Macro.UNSUPPORTED("ail0d4qmxj2aqh2q721inwgqu");
            }
            Macro.ND_showboxes(n, utils__c.late_int(n, Z.z().N_showboxes, 0, 0));
            Macro.ND_shape((ST_Agnode_s)n).fns.initfn.exe(n);
        }
        finally {
            SmetanaDebug.LEAVING("cr81drt18h5feqzxyh3jb0u49", "common_init_node");
        }
    }

    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="initFontEdgeAttr", key="d2v8l80y27ue2fag5c0qplah8", definition="static void initFontEdgeAttr(edge_t * e, struct fontinfo *fi)")
    public static void initFontEdgeAttr(ST_Agedge_s e, ST_fontinfo fi) {
        SmetanaDebug.ENTERING("d2v8l80y27ue2fag5c0qplah8", "initFontEdgeAttr");
        try {
            fi.fontsize = utils__c.late_double(e, Z.z().E_fontsize, 14.0, 1.0);
            fi.fontname = utils__c.late_nnstring(e, Z.z().E_fontname, new CString("Times-Roman"));
            fi.fontcolor = utils__c.late_nnstring(e, Z.z().E_fontcolor, new CString("black"));
        }
        finally {
            SmetanaDebug.LEAVING("d2v8l80y27ue2fag5c0qplah8", "initFontEdgeAttr");
        }
    }

    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="initFontLabelEdgeAttr", key="ak3pxrdrq900wymudwnjmbito", definition="static void initFontLabelEdgeAttr(edge_t * e, struct fontinfo *fi, \t\t      struct fontinfo *lfi)")
    public static void initFontLabelEdgeAttr(ST_Agedge_s e, ST_fontinfo fi, ST_fontinfo lfi) {
        SmetanaDebug.ENTERING("ak3pxrdrq900wymudwnjmbito", "initFontLabelEdgeAttr");
        try {
            if (Macro.N(fi.fontname)) {
                utils__c.initFontEdgeAttr(e, fi);
            }
            lfi.fontsize = utils__c.late_double(e, Z.z().E_labelfontsize, fi.fontsize, 1.0);
            lfi.fontname = utils__c.late_nnstring(e, Z.z().E_labelfontname, fi.fontname);
            lfi.fontcolor = utils__c.late_nnstring(e, Z.z().E_labelfontcolor, fi.fontcolor);
        }
        finally {
            SmetanaDebug.LEAVING("ak3pxrdrq900wymudwnjmbito", "initFontLabelEdgeAttr");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="noClip", key="bgnk1zwht9rwx6thmly98iofb", definition="static boolean  noClip(edge_t *e, attrsym_t* sym)")
    public static boolean noClip(ST_Agedge_s e, ST_Agsym_s sym2) {
        SmetanaDebug.ENTERING("bgnk1zwht9rwx6thmly98iofb", "noClip");
        try {
            boolean rv = false;
            if (sym2 != null) {
                CString str = attr__c.agxget(e, sym2);
                rv = str != null && str.charAt(0) != '\u0000' ? !utils__c.mapbool(str) : false;
            }
            boolean bl = rv;
            return bl;
        }
        finally {
            SmetanaDebug.LEAVING("bgnk1zwht9rwx6thmly98iofb", "noClip");
        }
    }

    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="chkPort", key="9vnr1bc7p533acazoxbhbfmx3", definition="static port chkPort (port (*pf)(node_t*, char*, char*), node_t* n, char* s)")
    public static ST_port chkPort(CFunction pf, ST_Agnode_s n, CString s) {
        return utils__c.chkPort_w_(pf, n, s).copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ST_port chkPort_w_(CFunction pf, ST_Agnode_s n, CString s) {
        SmetanaDebug.ENTERING("9vnr1bc7p533acazoxbhbfmx3", "chkPort");
        try {
            ST_port pt = new ST_port();
            CString cp = null;
            if (s != null) {
                cp = JUtils.strchr(s, ':');
            }
            if (cp != null) {
                Macro.UNSUPPORTED("cbuf05ko7kaxq2n9zw35l5v2h");
                Macro.UNSUPPORTED("7ofc3q8txvlvus6qwefbnbaxu");
                Macro.UNSUPPORTED("971i954brvgqb35cftazlqhon");
                Macro.UNSUPPORTED("2o9oidtrr5gspl1dh6vnz7mlz");
            } else {
                pt.___((__struct__)((ST_port)pf.exe(n, s, null)));
            }
            pt.name = s;
            ST_port sT_port = pt;
            return sT_port;
        }
        finally {
            SmetanaDebug.LEAVING("9vnr1bc7p533acazoxbhbfmx3", "chkPort");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="13/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="common_init_edge", key="3aqh64lxwv4da2snfe7fvr45b", definition="int common_init_edge(edge_t * e)")
    public static int common_init_edge(ST_Agedge_s e) {
        SmetanaDebug.ENTERING("3aqh64lxwv4da2snfe7fvr45b", "common_init_edge");
        try {
            CString str;
            int r = 0;
            ST_fontinfo fi = new ST_fontinfo();
            ST_fontinfo lfi = new ST_fontinfo();
            ST_Agraph_s sg = obj__c.agraphof(edge__c.agtail(e));
            fi.fontname = null;
            lfi.fontname = null;
            if (Z.z().E_label != null && (str = attr__c.agxget(e, Z.z().E_label)) != null && str.charAt(0) != '\u0000') {
                r = 1;
                utils__c.initFontEdgeAttr(e, fi);
                Macro.ED_label(e, labels__c.make_label(e, str, refstr__c.aghtmlstr(str) != 0 ? 2 : 0, fi.fontsize, fi.fontname, fi.fontcolor));
                Macro.GD_has_labels(sg, Macro.GD_has_labels(sg) | 1);
                Macro.ED_label_ontop(e, utils__c.mapbool(utils__c.late_string(e, Z.z().E_label_float, new CString("false"))));
            }
            if (Z.z().E_xlabel != null && (str = attr__c.agxget(e, Z.z().E_xlabel)) != null && str.charAt(0) != '\u0000') {
                Macro.UNSUPPORTED("1j3mhgq7abuh3n19q2jtjddbc");
                Macro.UNSUPPORTED("bmqo2g5g107quod3h31r8iudr");
                Macro.UNSUPPORTED("3s7kg9x748riuy3tm697s6e8t");
                Macro.UNSUPPORTED("b0zm6fkpjlt9jacykbgugjodg");
                Macro.UNSUPPORTED("c078bypfszv0nsvp1nc0x28wx");
            }
            if (Z.z().E_headlabel != null && (str = attr__c.agxget(e, Z.z().E_headlabel)) != null && str.charAt(0) != '\u0000') {
                utils__c.initFontLabelEdgeAttr(e, fi, lfi);
                Macro.ED_head_label(e, labels__c.make_label(e, str, refstr__c.aghtmlstr(str) != 0 ? 2 : 0, lfi.fontsize, lfi.fontname, lfi.fontcolor));
                Macro.GD_has_labels(sg, Macro.GD_has_labels(sg) | 2);
            }
            if (Z.z().E_taillabel != null && (str = attr__c.agxget(e, Z.z().E_taillabel)) != null && str.charAt(0) != '\u0000') {
                utils__c.initFontLabelEdgeAttr(e, fi, lfi);
                Macro.ED_tail_label(e, labels__c.make_label(e, str, refstr__c.aghtmlstr(str) != 0 ? 2 : 0, lfi.fontsize, lfi.fontname, lfi.fontcolor));
                Macro.GD_has_labels(sg, Macro.GD_has_labels(sg) | 4);
            }
            if (Macro.N(str = attr__c.agget(e, Macro.TAIL_ID))) {
                str = new CString("");
            }
            if (str != null && str.charAt(0) != '\u0000') {
                Macro.ND_has_port(edge__c.agtail(e), true);
            }
            Macro.ED_tail_port(e, utils__c.chkPort(Macro.ND_shape((ST_Agnode_s)edge__c.agtail((ST_Agedge_s)e)).fns.portfn, edge__c.agtail(e), str));
            if (utils__c.noClip(e, Z.z().E_tailclip)) {
                Macro.UNSUPPORTED("cg4z67u0dm6h9nrcx8kkalnlt");
            }
            if (Macro.N(str = attr__c.agget(e, Macro.HEAD_ID))) {
                str = new CString("");
            }
            if (str != null && str.charAt(0) != '\u0000') {
                Macro.ND_has_port(edge__c.aghead(e), true);
            }
            Macro.ED_head_port(e, utils__c.chkPort(Macro.ND_shape((ST_Agnode_s)edge__c.aghead((__ptr__)e)).fns.portfn, edge__c.aghead(e), str));
            if (utils__c.noClip(e, Z.z().E_headclip)) {
                Macro.UNSUPPORTED("ayqscz30ekhcje94wh4ib1hcu");
            }
            int n = r;
            return n;
        }
        finally {
            SmetanaDebug.LEAVING("3aqh64lxwv4da2snfe7fvr45b", "common_init_edge");
        }
    }

    @Unused
    @Original(version="2.38.0", path="lib/common/utils.c", name="addLabelBB", key="3mkqvtbyq9j8ktzil6t7vakg5", definition="static boxf addLabelBB(boxf bb, textlabel_t * lp, boolean flipxy)")
    public static ST_boxf addLabelBB(ST_boxf bb, ST_textlabel_t lp, boolean flipxy) {
        return utils__c.addLabelBB_w_(bb.copy(), lp, flipxy).copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ST_boxf addLabelBB_w_(ST_boxf bb, ST_textlabel_t lp, boolean flipxy) {
        SmetanaDebug.ENTERING("3mkqvtbyq9j8ktzil6t7vakg5", "addLabelBB");
        try {
            double width;
            double height;
            ST_pointf p = new ST_pointf();
            p.___((__struct__)lp.pos);
            if (flipxy) {
                height = lp.dimen.x;
                width = lp.dimen.y;
            } else {
                width = lp.dimen.x;
                height = lp.dimen.y;
            }
            double min = p.x - width / 2.0;
            double max = p.x + width / 2.0;
            if (min < bb.LL.x) {
                bb.LL.x = min;
            }
            if (max > bb.UR.x) {
                bb.UR.x = max;
            }
            min = p.y - height / 2.0;
            max = p.y + height / 2.0;
            if (min < bb.LL.y) {
                bb.LL.y = min;
            }
            if (max > bb.UR.y) {
                bb.UR.y = max;
            }
            ST_boxf sT_boxf = bb;
            return sT_boxf;
        }
        finally {
            SmetanaDebug.LEAVING("3mkqvtbyq9j8ktzil6t7vakg5", "addLabelBB");
        }
    }

    @Unused
    @Original(version="2.38.0", path="lib/common/utils.c", name="updateBB", key="bz7kjecium6a7xa39qfobwwnc", definition="void updateBB(graph_t * g, textlabel_t * lp)")
    public static void updateBB(ST_Agraph_s g, ST_textlabel_t lp) {
        SmetanaDebug.ENTERING("bz7kjecium6a7xa39qfobwwnc", "updateBB");
        try {
            Macro.GD_bb(g).___((__struct__)utils__c.addLabelBB(Macro.GD_bb(g), lp, Macro.GD_flip(g)));
        }
        finally {
            SmetanaDebug.LEAVING("bz7kjecium6a7xa39qfobwwnc", "updateBB");
        }
    }

    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="htmlEntityUTF8", key="9yungx7uxqkmzfh2ub6gs9l48", definition="char* htmlEntityUTF8 (char* s, graph_t* g)")
    public static CString htmlEntityUTF8(CString s, ST_Agraph_s g) {
        SmetanaDebug.ENTERING("9yungx7uxqkmzfh2ub6gs9l48", "htmlEntityUTF8");
        try {
            if (s != null) {
                CString cString = s.duplicate();
                return cString;
            }
            Macro.UNSUPPORTED("1xtgr84lklglr4gz1i1m3t30");
            Macro.UNSUPPORTED("erg9i1970wdri39osu8hx2a6e");
            Macro.UNSUPPORTED("a86rc8dlb4bgtjxjhv43cnmup");
            Macro.UNSUPPORTED("1gn88eczuyt54egtiulqe7y7h");
            Macro.UNSUPPORTED("3rzf3h52xn02xrxie111286a0");
            Macro.UNSUPPORTED("9gou5otj6s39l2cbyc8i5i5lq");
            Macro.UNSUPPORTED("esg3s800dx899v69pkng2kavv");
            Macro.UNSUPPORTED("10sir32iwi5l2jyfgp65pihto");
            Macro.UNSUPPORTED("4urrp9tny84a3cm8ycya896x3");
            Macro.UNSUPPORTED("d5druw9z4e87khtgyeivjngvc");
            Macro.UNSUPPORTED("4fymyfhfc3ddededhxw7cs671");
            Macro.UNSUPPORTED("d6z43cxggqxq7iq4puyluzkfn");
            Macro.UNSUPPORTED("4pgl4pn1cad2whf242bntmjre");
            Macro.UNSUPPORTED("t65eqheg8dxzi237a648t66j");
            Macro.UNSUPPORTED("emyoumradju26mhebq2bewtva");
            Macro.UNSUPPORTED("9ys85d2ctjb1a9ra0n11o2a2r");
            Macro.UNSUPPORTED("dvgyxsnyeqqnyzq696k3vskib");
            Macro.UNSUPPORTED("3jwm77zyv02ukrvjv9jppejf7");
            Macro.UNSUPPORTED("11zj3p308ttro04hrzowx0vrh");
            Macro.UNSUPPORTED("3xqp191v0egfea0z3ds5p1mjt");
            Macro.UNSUPPORTED("4j200801m87vnfrkblygi6ucj");
            Macro.UNSUPPORTED("1egwnjpl995mff91kquf9ikvl");
            Macro.UNSUPPORTED("8rfd02x8qlye0oo8ro9u9g8ya");
            Macro.UNSUPPORTED("49xkviec8w4s3zvlq13991yqh");
            Macro.UNSUPPORTED("bg2026u05g8jo9nm9pr39cknl");
            Macro.UNSUPPORTED("20m1lc1moer8x00tx9ceto0iw");
            Macro.UNSUPPORTED("6g3zbtp7zrl9i7jz1if5yi7rj");
            Macro.UNSUPPORTED("5ks80mtyizjvlnrh1bwebqrx7");
            Macro.UNSUPPORTED("2gr59wt9ibszrzwii40dqyd5b");
            Macro.UNSUPPORTED("2su1o4swg92stlgi53k4ydm5u");
            Macro.UNSUPPORTED("c0zrulbhqoupyvbwpwapfpc70");
            Macro.UNSUPPORTED("dveaae8p8nhz8gosmtiftudrz");
            Macro.UNSUPPORTED("a4c1bzq46y652vgwpxsruptth");
            Macro.UNSUPPORTED("3jir07ymknf0hmb9pv9x4dr3o");
            Macro.UNSUPPORTED("ar52jlyh4qqazbcbvntg2wet6");
            Macro.UNSUPPORTED("ame11lb7ylv3rp1nhtuq383du");
            Macro.UNSUPPORTED("7acv020k6kt3q8tholp3ex0qa");
            Macro.UNSUPPORTED("qr4o1w9xvn1ayc52y0f4c8bh");
            Macro.UNSUPPORTED("7g94ubxa48a1yi3mf9v521b7c");
            Macro.UNSUPPORTED("ejqmh8ox9uoy02anzqhcxcrro");
            Macro.UNSUPPORTED("4mhlpjofolwivhm0tl8cxznly");
            Macro.UNSUPPORTED("8n9ts84r09bm29qdb7v2og087");
            Macro.UNSUPPORTED("3cziqu94ggcy3m9kpbpdefqgk");
            Macro.UNSUPPORTED("1c1fqb40szvpdlekj4as5qcqq");
            Macro.UNSUPPORTED("buyl72klnvh12cf4m578joukc");
            Macro.UNSUPPORTED("1fj0k3ba7vy9tjmjnc4d4mujb");
            Macro.UNSUPPORTED("aso1t4v0cars70ngqafalmoeq");
            Macro.UNSUPPORTED("777bke4pyf77uol5s5d6qk0i6");
            Macro.UNSUPPORTED("4wqu3fuzmckazc7eb1vvoxspn");
            Macro.UNSUPPORTED("2b9x6g0k8a00ty06llcyp6cqu");
            Macro.UNSUPPORTED("el4sow483b296l5o1hy6oqkzp");
            Macro.UNSUPPORTED("dkxvw03k2gg9anv4dbze06axd");
            Macro.UNSUPPORTED("163d4s8voz31qrt0e4c8ysn9e");
            Macro.UNSUPPORTED("4tpuwv4i0wslspyymoqhdxsvd");
            Macro.UNSUPPORTED("8unuta6ydloexb267kdf96wi");
            Macro.UNSUPPORTED("el4sow483b296l5o1hy6oqkzp");
            Macro.UNSUPPORTED("dkxvw03k2gg9anv4dbze06axd");
            Macro.UNSUPPORTED("dkxvw03k2gg9anv4dbze06axd");
            Macro.UNSUPPORTED("4mhlpjofolwivhm0tl8cxznly");
            Macro.UNSUPPORTED("atwq5cvh75c4mpqr6f8bepwkd");
            Macro.UNSUPPORTED("75h3d3pcb66cff2xszmbwxny0");
            Macro.UNSUPPORTED("75m8b2zfuuay6o25xl08y168m");
            Macro.UNSUPPORTED("2bav6kbg19gemwcsyepjeg52u");
            Macro.UNSUPPORTED("5kkh713qn8pc4dhd3omuop8qk");
            Macro.UNSUPPORTED("7nxu74undh30brb8laojud3f9");
            Macro.UNSUPPORTED("69mmu86j5iw8x34fdfo0k59ff");
            Macro.UNSUPPORTED("cjh6htddtrrxjuyqzavdlw01o");
            Macro.UNSUPPORTED("8ljhi9erpokpqsnveckujskly");
            Macro.UNSUPPORTED("8sgutsruuu83a337z05bvytk0");
            Macro.UNSUPPORTED("3d2mow5zy6q4vrtc38f78ucgh");
            Macro.UNSUPPORTED("8jh5xw3y1bjy4poswq4h2wk4n");
            Macro.UNSUPPORTED("ctqmerohp1f69mb1v1t20jx33");
            Macro.UNSUPPORTED("g2y6e9pld3899aejuqyr2x25");
            Macro.UNSUPPORTED("28mab50dtpxfjz5h216ox1q6w");
            Macro.UNSUPPORTED("dvgyxsnyeqqnyzq696k3vskib");
            Macro.UNSUPPORTED("3g7d9dp3ny3ggno64pwi7nmkg");
            Macro.UNSUPPORTED("1at5m9ctjn3ukv5gqtfswik02");
            Macro.UNSUPPORTED("98aa6ybsfiu5u7r3j6fsv3snz");
            Macro.UNSUPPORTED("c24nfmv9i7o5eoqaymbibp7m7");
            throw new UnsupportedOperationException();
        }
        finally {
            SmetanaDebug.LEAVING("9yungx7uxqkmzfh2ub6gs9l48", "htmlEntityUTF8");
        }
    }

    @Unused
    @Original(version="2.38.0", path="lib/common/utils.c", name="edgeType", key="ckavkcnz5rcrqs17lleds1uxu", definition="int edgeType (char* s, int dflt)")
    public static int edgeType(CString s, int dflt) {
        SmetanaDebug.ENTERING("ckavkcnz5rcrqs17lleds1uxu", "edgeType");
        try {
            Macro.UNSUPPORTED("h9kzapvoxea4esxgom157wc0");
            Macro.UNSUPPORTED("erg9i1970wdri39osu8hx2a6e");
            Macro.UNSUPPORTED("26e08yupzx95a4pzp1af0t6og");
            Macro.UNSUPPORTED("73z43mn6ha09hbnvzynnbkvqg");
            Macro.UNSUPPORTED("527zd48lq0ay6p16b2whyuafo");
            Macro.UNSUPPORTED("1ctayzw7ya308i4wpppul6b9o");
            Macro.UNSUPPORTED("acwxya6p4cjrbqeuf7gymcmx2");
            Macro.UNSUPPORTED("18fcibo027r3vczxrvtju3nah");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("no8amccag0mew2zmsprfyekp");
            Macro.UNSUPPORTED("8to0pat5o6zmyuqjfl01xs9xc");
            Macro.UNSUPPORTED("c7icptpasun232whn2nn5gydx");
            Macro.UNSUPPORTED("44xov6gwt91mlesh02z3zvxx");
            Macro.UNSUPPORTED("4dwlps5sjcl550fvks2ibv2fi");
            Macro.UNSUPPORTED("cr0jhqsceb5y1hcmvtjd1ttgu");
            Macro.UNSUPPORTED("8jq47j7ezu18niwotmuj92cz3");
            Macro.UNSUPPORTED("ami8xk8243o5ku0cyeqxoeiut");
            Macro.UNSUPPORTED("3onv8t8a6v1tmfaz8y7hk9lvv");
            Macro.UNSUPPORTED("8m599inlx0lbuns9r3iiokwxw");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("vwxe2prs0tywhf20ycwdwa8o");
            Macro.UNSUPPORTED("e2ux7lqsbmsyyrououuijooiy");
            Macro.UNSUPPORTED("8zxim9f3q8qdl919cv1v3jf8e");
            Macro.UNSUPPORTED("azc7d85av8k7f1to3mr59m3mz");
            Macro.UNSUPPORTED("b7i0q9ysed6zrjftn8ilgtn0a");
            Macro.UNSUPPORTED("aihlhslp3nd26f10vuyjlnb3q");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("2ix1d2vw6unhjetclv9vkaw1p");
            Macro.UNSUPPORTED("2chzjgs8kmwelk00c6469lpx2");
            Macro.UNSUPPORTED("42jngi39nkk27q16s1sa7sftl");
            Macro.UNSUPPORTED("7xut5zuu25vrpn9gt0f3kc5hz");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("7ozigs1hjxmhvwgapx2in25cy");
            Macro.UNSUPPORTED("c2gttjqnkmx1rnuyjknw7segb");
            Macro.UNSUPPORTED("96lnofxeiqa1g3g7s02b86h6z");
            Macro.UNSUPPORTED("7xut5zuu25vrpn9gt0f3kc5hz");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("5o5i90c7m363f5yyxamxuzok6");
            Macro.UNSUPPORTED("3ttrfea54jmrshv2796w3a9h2");
            Macro.UNSUPPORTED("6qibxt06dimtp2r5spwgriorn");
            Macro.UNSUPPORTED("bqi51jfycttyx733ls9qw2c18");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("18t59gw7hrgsezibz7bbm0ng3");
            Macro.UNSUPPORTED("4q6jdsek20d4i9sc5ftmm3mdl");
            Macro.UNSUPPORTED("8scb0vjws7o3davin33k87o2p");
            Macro.UNSUPPORTED("48rqxx6odtdnqf676ffe1ll7g");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("5cc40qlotkkym6enwcv916835");
            Macro.UNSUPPORTED("al1clonjqyw2bo1z0li974ijp");
            Macro.UNSUPPORTED("68l1a5153ouil03qaammm1zty");
            Macro.UNSUPPORTED("5ytop08aei3hhllfd12904hh7");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("20wayzvdomwexzhjzj4wojf4d");
            Macro.UNSUPPORTED("boxft69fzv6rof5elda0zs33z");
            Macro.UNSUPPORTED("3qs8m2esm62d50tk701b8m0xz");
            Macro.UNSUPPORTED("5l4kd6c21h4bjm98grnqqwra6");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("ce41quxcxpj3oi50zybc75b9r");
            Macro.UNSUPPORTED("8drchetff3h6zpsu3m08rqi0q");
            Macro.UNSUPPORTED("7ln0pymv14hb45h3ypy5955nk");
            Macro.UNSUPPORTED("5l4kd6c21h4bjm98grnqqwra6");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("3d55ucqxr8xg0otty2j39hkgz");
            Macro.UNSUPPORTED("7oihco3xpq1kek2q2dnrfxmcx");
            Macro.UNSUPPORTED("679wmbnx0dakltwkxx2svg5ex");
            Macro.UNSUPPORTED("5l4kd6c21h4bjm98grnqqwra6");
            Macro.UNSUPPORTED("6aw91xzjmqvmtdvt1di23af8y");
            Macro.UNSUPPORTED("dvgyxsnyeqqnyzq696k3vskib");
            Macro.UNSUPPORTED("ckjgbybnvrshn8g32qqpy0ppd");
            Macro.UNSUPPORTED("79f40sxqwmzmgk4ktfha59mxf");
            Macro.UNSUPPORTED("mjiefsvltip3uasxic0uipa9");
            Macro.UNSUPPORTED("dvgyxsnyeqqnyzq696k3vskib");
            Macro.UNSUPPORTED("68yadra75shcc0tia9wr9acr4");
            Macro.UNSUPPORTED("c24nfmv9i7o5eoqaymbibp7m7");
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            SmetanaDebug.LEAVING("ckavkcnz5rcrqs17lleds1uxu", "edgeType");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="12/11/2020")
    @Original(version="2.38.0", path="lib/common/utils.c", name="setEdgeType", key="13cpqbf2ztcjdfz4a6v7nv00u", definition="void setEdgeType (graph_t* g, int dflt)")
    public static void setEdgeType(ST_Agraph_s g, int dflt) {
        SmetanaDebug.ENTERING("13cpqbf2ztcjdfz4a6v7nv00u", "setEdgeType");
        try {
            CString s = attr__c.agget(g, new CString("splines"));
            int et = Macro.N(s) ? dflt : (s.charAt(0) == '\u0000' ? 0 : utils__c.edgeType(s, dflt));
            Macro.GD_flags(g, Macro.GD_flags(g) | et);
        }
        finally {
            SmetanaDebug.LEAVING("13cpqbf2ztcjdfz4a6v7nv00u", "setEdgeType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reviewed(when="13/11/2020")
    @Doc(value="Store size of a node from inch")
    @Original(version="2.38.0", path="lib/common/utils.c", name="gv_nodesize", key="80q488y0eqojtsm7osnfydmo5", definition="void gv_nodesize(node_t * n, boolean flip)")
    public static void gv_nodesize(ST_Agnode_s n, boolean flip) {
        SmetanaDebug.ENTERING("80q488y0eqojtsm7osnfydmo5", "gv_nodesize");
        try {
            if (flip) {
                double w = Macro.INCH2PS(Macro.ND_height(n));
                Macro.ND_rw(n, w / 2.0);
                Macro.ND_lw(n, w / 2.0);
                Macro.ND_ht(n, Macro.INCH2PS(Macro.ND_width(n)));
            } else {
                double w = Macro.INCH2PS(Macro.ND_width(n));
                Macro.ND_rw(n, w / 2.0);
                Macro.ND_lw(n, w / 2.0);
                Macro.ND_ht(n, Macro.INCH2PS(Macro.ND_height(n)));
            }
        }
        finally {
            SmetanaDebug.LEAVING("80q488y0eqojtsm7osnfydmo5", "gv_nodesize");
        }
    }
}

