/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regex;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.regex.ReToken;
import net.sourceforge.plantuml.regex.ReTokenType;
import net.sourceforge.plantuml.utils.CharInspector;

public class RegexExpression {
    public static List<ReToken> parse(CharInspector it) {
        char current;
        ArrayList<ReToken> result = new ArrayList<ReToken>();
        while ((current = it.peek(0)) != '\u0000') {
            String s;
            if (RegexExpression.isStartAnchor(it)) {
                s = RegexExpression.readAnchor(it);
                result.add(new ReToken(ReTokenType.ANCHOR, s));
                continue;
            }
            if (RegexExpression.isEscapedChar(it)) {
                result.add(new ReToken(ReTokenType.ESCAPED_CHAR, "" + it.peek(1)));
                it.jump();
                it.jump();
                continue;
            }
            if (current == '|') {
                result.add(new ReToken(ReTokenType.ALTERNATIVE, "|"));
                it.jump();
                continue;
            }
            if (current == '[') {
                s = RegexExpression.readGroup(it);
                result.add(new ReToken(ReTokenType.GROUP, s));
                continue;
            }
            if (RegexExpression.isStartOpenParenthesis(it)) {
                s = RegexExpression.readOpenParenthesis(it);
                result.add(new ReToken(ReTokenType.PARENTHESIS_OPEN, s));
                continue;
            }
            if (current == ')') {
                result.add(new ReToken(ReTokenType.PARENTHESIS_CLOSE, ")"));
                it.jump();
                continue;
            }
            if (RegexExpression.isStartQuantifier(it)) {
                s = RegexExpression.readQuantifier(it);
                result.add(new ReToken(ReTokenType.QUANTIFIER, s));
                continue;
            }
            if (RegexExpression.isStartClass(it)) {
                s = RegexExpression.readClass(it);
                result.add(new ReToken(ReTokenType.CLASS, s));
                continue;
            }
            if (RegexExpression.isSimpleLetter(current)) {
                result.add(new ReToken(ReTokenType.SIMPLE_CHAR, "" + current));
                it.jump();
                continue;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    private static boolean isStartOpenParenthesis(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '(';
    }

    private static String readOpenParenthesis(CharInspector it) {
        char current0 = it.peek(0);
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        if (it.peek(0) == '?' && it.peek(1) == ':') {
            it.jump();
            it.jump();
            result.append("?:");
        }
        if (it.peek(0) == '?' && it.peek(1) == '!') {
            it.jump();
            it.jump();
            result.append("?!");
        }
        return result.toString();
    }

    private static boolean isStartQuantifier(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '*' || current0 == '+' || current0 == '?' || current0 == '{';
    }

    private static String readQuantifier(CharInspector it) {
        char current0 = it.peek(0);
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        if (current0 == '{') {
            while (it.peek(0) != '\u0000') {
                char ch = it.peek(0);
                result.append(ch);
                it.jump();
                if (ch != '}') continue;
                break;
            }
        }
        if (it.peek(0) == '?') {
            result.append('?');
            it.jump();
        }
        return result.toString();
    }

    private static boolean isEscapedChar(CharInspector it) {
        char current1;
        char current0 = it.peek(0);
        return current0 == '\\' && ((current1 = it.peek(1)) == '.' || current1 == '*' || current1 == '\\' || current1 == '?' || current1 == '^' || current1 == '$' || current1 == '|' || current1 == '(' || current1 == ')' || current1 == '[' || current1 == ']' || current1 == '{' || current1 == '}' || current1 == '<' || current1 == '>');
    }

    private static String readGroup(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 != '[') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        while (it.peek(0) != '\u0000') {
            char ch = it.peek(0);
            it.jump();
            if (ch == ']') break;
            result.append(ch);
            if (ch != '\\') continue;
            ch = it.peek(0);
            it.jump();
            result.append(ch);
        }
        return result.toString();
    }

    private static String readClass(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '.') {
            it.jump();
            return "" + current0;
        }
        if (current0 == '\\') {
            it.jump();
            String result = "" + current0 + it.peek(0);
            it.jump();
            return result;
        }
        throw new IllegalStateException();
    }

    private static boolean isStartClass(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '.') {
            return true;
        }
        return current0 == '\\';
    }

    private static boolean isSimpleLetter(char ch) {
        return ch != '\\' && ch != '.';
    }

    private static boolean isStartAnchor(CharInspector it) {
        char current1;
        char current0 = it.peek(0);
        if (current0 == '^' || current0 == '$') {
            return true;
        }
        return current0 == '\\' && ((current1 = it.peek(1)) == 'A' || current1 == 'Z' || current1 == 'z' || current1 == 'G' || current1 == 'b' || current1 == 'B');
    }

    private static String readAnchor(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '^' || current0 == '$') {
            it.jump();
            return "" + current0;
        }
        if (current0 == '\\') {
            it.jump();
            String result = "" + current0 + it.peek(0);
            it.jump();
            return result;
        }
        throw new IllegalStateException();
    }
}

