/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.baraye.EntityImp;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;
import net.sourceforge.plantuml.utils.Direction;

public class EntityImageClass
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock body;
    private final EntityImageClassHeader header;
    private final Url url;
    private final double roundCorner;
    private final LeafType leafType;
    private final LineConfigurable lineConfig;

    public EntityImageClass(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, entity.getColors().mute(skinParam));
        this.leafType = entity.getLeafType();
        this.lineConfig = entity;
        this.roundCorner = this.getStyle().value(PName.RoundCorner).asDouble();
        boolean showMethods = portionShower.showPortion(EntityPortion.METHOD, entity);
        boolean showFields = portionShower.showPortion(EntityPortion.FIELD, entity);
        this.body = entity.getBodier().getBody(this.getSkinParam(), showMethods, showFields, entity.getStereotype(), this.getStyle(), null);
        this.header = new EntityImageClassHeader(entity, this.getSkinParam(), portionShower);
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double paramSameClassWidth;
        double minClassWidth;
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        XDimension2D dimBody = this.body == null ? new XDimension2D(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double width = Math.max(dimBody.getWidth(), dimHeader.getWidth());
        if (width < (minClassWidth = this.getStyle().value(PName.MinimumWidth).asDouble())) {
            width = minClassWidth;
        }
        if (width < (paramSameClassWidth = this.getSkinParam().getParamSameClassWidth())) {
            width = paramSameClassWidth;
        }
        double height = dimBody.getHeight() + dimHeader.getHeight();
        return new XDimension2D(Math.max(width, this.getKalWidth() * 1.3), height);
    }

    private double getKalWidth() {
        double widthUp = 0.0;
        double widthDown = 0.0;
        for (Kal kal : ((EntityImp)this.getEntity()).getKals(Direction.UP)) {
            widthUp += kal.getDimension().getWidth();
        }
        for (Kal kal : ((EntityImp)this.getEntity()).getKals(Direction.DOWN)) {
            widthDown += kal.getDimension().getWidth();
        }
        return Math.max(widthUp, widthDown);
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        XRectangle2D result = this.body.getInnerPosition(member, stringBounder, strategy);
        if (result == null) {
            return result;
        }
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        UTranslate translate = UTranslate.dy(dimHeader.getHeight());
        return translate.apply(result);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("class " + this.getEntity().getCodeGetName()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        this.drawInternal(ug);
        ug.closeGroup();
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_).withTOBECHANGED(this.getEntity().getStereotype()).with(this.getEntity().getStereostyles()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Style getStyleHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).with(this.getEntity().getStereostyles()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private void drawInternal(UGraphic ug) {
        URectangle rect2;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(this.roundCorner).withCommentAndCodeLine(this.getEntity().getCodeGetName(), this.getEntity().getCodeLine());
        double shadow = 0.0;
        HColor borderColor = this.lineConfig.getColors().getColor(ColorType.LINE);
        HColor headerBackcolor = this.getEntity().getColors().getColor(ColorType.HEADER);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        shadow = this.getStyle().value(PName.Shadowing).asDouble();
        if (borderColor == null) {
            borderColor = this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        if (headerBackcolor == null) {
            HColor hColor = headerBackcolor = backcolor == null ? this.getStyleHeader().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : backcolor;
        }
        if (backcolor == null) {
            backcolor = this.getStyle().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        rect.setDeltaShadow(shadow);
        ug = ug.apply(borderColor);
        ug = ug.apply(backcolor.bg());
        UStroke stroke = this.getStyle().getStroke(this.lineConfig.getColors());
        UGraphic ugHeader = ug;
        if (this.roundCorner == 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            ug.apply(stroke).draw(rect);
            rect2 = new URectangle(widthTotal, dimHeader.getHeight());
            rect2.setDeltaShadow(0.0);
            ugHeader = ugHeader.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        } else if (this.roundCorner != 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            ug.apply(stroke).draw(rect);
            rect2 = new URectangle(widthTotal, dimHeader.getHeight()).rounded(this.roundCorner);
            URectangle rect3 = new URectangle(widthTotal, this.roundCorner / 2.0);
            rect2.setDeltaShadow(0.0);
            rect3.setDeltaShadow(0.0);
            ugHeader = ugHeader.apply(headerBackcolor.bg()).apply(headerBackcolor);
            ugHeader.apply(stroke).draw(rect2);
            ugHeader.apply(stroke).apply(UTranslate.dy(dimHeader.getHeight() - rect3.getHeight())).draw(rect3);
            rect.setDeltaShadow(0.0);
            ug.apply(stroke).apply(HColors.none().bg()).draw(rect);
        } else {
            ug.apply(stroke).draw(rect);
        }
        this.header.drawU(ugHeader, dimTotal.getWidth(), dimHeader.getHeight());
        if (this.body != null) {
            UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
            UTranslate translate = UTranslate.dy(dimHeader.getHeight());
            this.body.drawU(ug2.apply(translate));
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        if (this.body instanceof WithPorts) {
            return ((WithPorts)((Object)this.body)).getPorts(stringBounder).translateY(dimHeader.getHeight());
        }
        return new Ports();
    }

    @Override
    public ShapeType getShapeType() {
        if (((ILeaf)this.getEntity()).getPortShortNames().size() > 0) {
            return ShapeType.RECTANGLE_HTML_FOR_PORTS;
        }
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return ((ILeaf)this.getEntity()).getMargins();
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

