/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.complexscripts.bidi.InlineRun;
import org.apache.fop.complexscripts.bidi.UnflattenProcessor;
import org.apache.fop.fo.pagination.PageSequence;

public final class BidiResolver {
    private static final Log log = LogFactory.getLog(BidiResolver.class);

    private BidiResolver() {
    }

    public static void resolveInlineDirectionality(PageSequence ps) {
        if (log.isDebugEnabled()) {
            log.debug("BD: RESOLVE: " + ps);
        }
        List<DelimitedTextRange> ranges = ps.collectDelimitedTextRanges(new Stack<DelimitedTextRange>());
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRanges("BD: RESOLVE: RANGES:", ranges);
        }
        ranges = BidiResolver.pruneEmptyRanges(ranges);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRanges("BD: RESOLVE: PRUNED RANGES:", ranges);
        }
        BidiResolver.resolveInlineDirectionality(ranges);
    }

    public static void reorder(LineArea la) {
        List runs = BidiResolver.collectRuns(la.getInlineAreas(), new Vector());
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: INPUT:", runs);
        }
        runs = BidiResolver.splitRuns(runs);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: SPLIT INLINES:", runs);
        }
        int[] mm = BidiResolver.computeMinMaxLevel(runs, null);
        if (log.isDebugEnabled()) {
            log.debug("BD: REORDER: { min = " + mm[0] + ", max = " + mm[1] + "}");
        }
        int mn = mm[0];
        int mx = mm[1];
        if (mx > 0) {
            int l2;
            int n = l2 = (mn & 1) == 0 ? mn + 1 : mn;
            for (int l1 = mx; l1 >= l2; --l1) {
                runs = BidiResolver.reorderRuns(runs, l1);
            }
        }
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: REORDERED RUNS:", runs);
        }
        boolean mirror = true;
        BidiResolver.reverseWords(runs, mirror);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: REORDERED WORDS:", runs);
        }
        BidiResolver.replaceInlines(la, BidiResolver.replicateSplitWords(runs));
    }

    private static void resolveInlineDirectionality(List ranges) {
        for (Object range : ranges) {
            DelimitedTextRange r = (DelimitedTextRange)range;
            r.resolve();
            if (!log.isDebugEnabled()) continue;
            log.debug(r);
        }
    }

    private static List collectRuns(List inlines, List runs) {
        for (Object inline : inlines) {
            InlineArea ia = (InlineArea)inline;
            runs = ia.collectInlineRuns(runs);
        }
        return runs;
    }

    private static List splitRuns(List runs) {
        Vector<InlineRun> runsNew = new Vector<InlineRun>();
        for (Object e : runs) {
            InlineRun ir = (InlineRun)e;
            if (ir.isHomogenous()) {
                runsNew.add(ir);
                continue;
            }
            runsNew.addAll(ir.split());
        }
        if (!runsNew.equals(runs)) {
            runs = runsNew;
        }
        return runs;
    }

    private static int[] computeMinMaxLevel(List runs, int[] mm) {
        if (mm == null) {
            mm = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        }
        for (Object run : runs) {
            InlineRun ir = (InlineRun)run;
            ir.updateMinMax(mm);
        }
        return mm;
    }

    private static List reorderRuns(List runs, int level) {
        assert (level >= 0);
        Vector<InlineRun> runsNew = new Vector<InlineRun>();
        int n = runs.size();
        for (int i = 0; i < n; ++i) {
            int s;
            InlineRun ire;
            int e;
            InlineRun iri = (InlineRun)runs.get(i);
            if (iri.getMinLevel() < level) {
                runsNew.add(iri);
                continue;
            }
            for (e = s = i; e < n && (ire = (InlineRun)runs.get(e)).getMinLevel() >= level; ++e) {
            }
            if (s < e) {
                runsNew.addAll(BidiResolver.reverseRuns(runs, s, e));
            }
            i = e - 1;
        }
        if (!runsNew.equals(runs)) {
            runs = runsNew;
        }
        return runs;
    }

    private static List reverseRuns(List runs, int s, int e) {
        int n = e - s;
        Vector<InlineRun> runsNew = new Vector<InlineRun>(n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                int k = n - i - 1;
                InlineRun ir = (InlineRun)runs.get(s + k);
                ir.reverse();
                runsNew.add(ir);
            }
        }
        return runsNew;
    }

    private static void reverseWords(List runs, boolean mirror) {
        for (Object run : runs) {
            InlineRun ir = (InlineRun)run;
            ir.maybeReverseWord(mirror);
        }
    }

    private static List replicateSplitWords(List runs) {
        return runs;
    }

    private static void replaceInlines(LineArea la, List runs) {
        ArrayList<InlineArea> inlines = new ArrayList<InlineArea>();
        for (Object run : runs) {
            InlineRun ir = (InlineRun)run;
            inlines.add(ir.getInline());
        }
        la.setInlineAreas(BidiResolver.unflattenInlines(inlines));
    }

    private static List unflattenInlines(List<InlineArea> inlines) {
        return new UnflattenProcessor(inlines).unflatten();
    }

    private static void dumpRuns(String header, List runs) {
        log.debug(header);
        for (Object run : runs) {
            InlineRun ir = (InlineRun)run;
            log.debug(ir);
        }
    }

    private static void dumpRanges(String header, List ranges) {
        log.debug(header);
        for (Object range : ranges) {
            DelimitedTextRange r = (DelimitedTextRange)range;
            log.debug(r);
        }
    }

    private static List pruneEmptyRanges(List ranges) {
        Vector<DelimitedTextRange> rv = new Vector<DelimitedTextRange>();
        for (Object range : ranges) {
            DelimitedTextRange r = (DelimitedTextRange)range;
            if (r.isEmpty()) continue;
            rv.add(r);
        }
        return rv;
    }
}

