/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.salt.element.AbstractElementText;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.style.ISkinSimple;

public class ElementButton
extends AbstractElementText
implements Element {
    private final double stroke = 2.5;
    private final double marginX = 2.0;
    private final double marginY = 2.0;

    public ElementButton(String text, UFont font, ISkinSimple spriteContainer) {
        super(text, font, true, spriteContainer);
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        XDimension2D dim = this.getTextDimensionAt(stringBounder, x + 2.5 + 2.0);
        dim = dim.delta(4.0, 4.0);
        return dim.delta(5.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        XDimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        ug = ug.apply(new UStroke(2.5));
        ug = ug.apply(this.getColorEE().bg()).apply(this.getBlack());
        ug.apply(new UTranslate(2.5, 2.5)).draw(new URectangle(dim.getWidth() - 5.0, dim.getHeight() - 5.0).rounded(10.0));
        XDimension2D dimPureText = this.getPureTextDimension(ug.getStringBounder());
        this.drawText(ug, (dim.getWidth() - dimPureText.getWidth()) / 2.0, 4.5);
    }
}

