/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseReference
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final TextBlock textHeader;
    private final double heightFooter = 5.0;
    private final double xMargin = 2.0;
    private final HorizontalAlignment position;
    private final Fashion symbolContextHeader;
    private final Fashion symbolContextBody;
    private int roundCorner;

    public ComponentRoseReference(Style style, Style styleHeader, Display stringsToDisplay, ISkinSimple spriteContainer, HColor background) {
        super(style, LineBreakStrategy.NONE, 4, 4, 4, spriteContainer, stringsToDisplay.subList(1, stringsToDisplay.size()), false);
        this.symbolContextHeader = styleHeader.getSymbolContext(this.getIHtmlColorSet());
        this.symbolContextBody = style.getSymbolContext(this.getIHtmlColorSet());
        this.roundCorner = style.value(PName.RoundCorner).asInt(false);
        FontConfiguration fcHeader = styleHeader.getFontConfiguration(this.getIHtmlColorSet());
        this.position = style.getHorizontalAlignment();
        this.textHeader = stringsToDisplay.subList(0, 1).create(fcHeader, HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        double textPos;
        XDimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int textHeaderWidth = (int)this.getHeaderWidth(stringBounder);
        int textHeaderHeight = (int)this.getHeaderHeight(stringBounder);
        URectangle rect = new URectangle(dimensionToUse.getWidth() - 4.0 - this.symbolContextBody.getDeltaShadow(), dimensionToUse.getHeight() - 5.0);
        if (this.roundCorner != 0) {
            rect = rect.rounded(this.roundCorner);
        }
        rect.setDeltaShadow(this.symbolContextBody.getDeltaShadow());
        ug = this.symbolContextBody.apply(ug);
        ug.apply(UTranslate.dx(2.0)).draw(rect);
        UPath corner = new UPath();
        if (this.roundCorner == 0) {
            corner.moveTo(0.0, 0.0);
            corner.lineTo(textHeaderWidth, 0.0);
            corner.lineTo(textHeaderWidth, textHeaderHeight - 10);
            corner.lineTo(textHeaderWidth - 10, textHeaderHeight);
            corner.lineTo(0.0, textHeaderHeight);
            corner.lineTo(0.0, 0.0);
        } else {
            corner.moveTo(this.roundCorner / 2, 0.0);
            corner.lineTo(textHeaderWidth, 0.0);
            corner.lineTo(textHeaderWidth, textHeaderHeight - 10);
            corner.lineTo(textHeaderWidth - 10, textHeaderHeight);
            corner.lineTo(0.0, textHeaderHeight);
            corner.lineTo(0.0, this.roundCorner / 2);
            corner.arcTo(this.roundCorner / 2, this.roundCorner / 2, 0.0, 0.0, 1.0, this.roundCorner / 2, 0.0);
        }
        ug = this.symbolContextHeader.apply(ug);
        ug.apply(UTranslate.dx(2.0)).draw(corner);
        ug = ug.apply(new UStroke());
        this.textHeader.drawU(ug.apply(new UTranslate(15.0, 2.0)));
        if (this.position == HorizontalAlignment.CENTER) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = (dimensionToUse.getWidth() - textWidth) / 2.0;
        } else if (this.position == HorizontalAlignment.RIGHT) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = dimensionToUse.getWidth() - textWidth - (double)this.getMarginX2() - 2.0;
        } else {
            textPos = (double)this.getMarginX1() + 2.0;
        }
        this.getTextBlock().drawU(ug.apply(new UTranslate(textPos, this.getMarginY() + textHeaderHeight)));
    }

    private double getHeaderHeight(StringBounder stringBounder) {
        XDimension2D headerDim = this.textHeader.calculateDimension(stringBounder);
        return headerDim.getHeight() + 2.0;
    }

    private double getHeaderWidth(StringBounder stringBounder) {
        XDimension2D headerDim = this.textHeader.calculateDimension(stringBounder);
        return headerDim.getWidth() + 30.0 + 15.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.getHeaderHeight(stringBounder) + 5.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), this.getHeaderWidth(stringBounder)) + 4.0 + this.symbolContextBody.getDeltaShadow();
    }
}

