/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.Streamable;
import org.apache.fop.afp.util.BinaryUtils;

public abstract class AbstractAFPObject
implements Streamable {
    protected static final Log LOG = LogFactory.getLog(AbstractAFPObject.class);
    protected static final byte SF_CLASS = -45;
    private static final byte[] SF_HEADER = new byte[]{90, 0, 16, -45, 0, 0, 0, 0, 0};
    protected static final int SF_HEADER_LENGTH = SF_HEADER.length;

    protected void copySF(byte[] data, byte type, byte category) {
        AbstractAFPObject.copySF(data, (byte)-45, type, category);
    }

    protected static void copySF(byte[] data, byte clazz, byte type, byte category) {
        System.arraycopy(SF_HEADER, 0, data, 0, SF_HEADER_LENGTH);
        data[3] = clazz;
        data[4] = type;
        data[5] = category;
    }

    protected <S extends Streamable> void writeObjects(Collection<S> objects, OutputStream os) throws IOException {
        if (objects != null) {
            Iterator<S> it = objects.iterator();
            while (it.hasNext()) {
                Streamable s = (Streamable)it.next();
                s.writeToStream(os);
                it.remove();
            }
        }
    }

    protected static void writeChunksToStream(byte[] data, byte[] dataHeader, int lengthOffset, int maxChunkLength, OutputStream os) throws IOException {
        byte[] len;
        int dataLength = data.length;
        int numFullChunks = dataLength / maxChunkLength;
        int lastChunkLength = dataLength % maxChunkLength;
        int headerLen = dataHeader.length - lengthOffset;
        if (headerLen == 2) {
            headerLen = 0;
        }
        int off = 0;
        if (numFullChunks > 0) {
            len = BinaryUtils.convert(headerLen + maxChunkLength, 2);
            dataHeader[lengthOffset] = len[0];
            dataHeader[lengthOffset + 1] = len[1];
            int i = 0;
            while (i < numFullChunks) {
                os.write(dataHeader);
                os.write(data, off, maxChunkLength);
                ++i;
                off += maxChunkLength;
            }
        }
        if (lastChunkLength > 0) {
            len = BinaryUtils.convert(headerLen + lastChunkLength, 2);
            dataHeader[lengthOffset] = len[0];
            dataHeader[lengthOffset + 1] = len[1];
            os.write(dataHeader);
            os.write(data, off, lastChunkLength);
        }
    }

    protected static String truncate(String str, int maxLength) {
        if (str.length() > maxLength) {
            str = str.substring(0, maxLength);
            LOG.warn("truncated character string '" + str + "', longer than " + maxLength + " chars");
        }
        return str;
    }

    public static interface Category {
        public static final byte PAGE_SEGMENT = 95;
        public static final byte OBJECT_AREA = 107;
        public static final byte COLOR_ATTRIBUTE_TABLE = 119;
        public static final byte IM_IMAGE = 123;
        public static final byte MEDIUM = -120;
        public static final byte CODED_FONT = -118;
        public static final byte PROCESS_ELEMENT = -112;
        public static final byte OBJECT_CONTAINER = -110;
        public static final byte PRESENTATION_TEXT = -101;
        public static final byte INDEX = -89;
        public static final byte DOCUMENT = -88;
        public static final byte PAGE_GROUP = -83;
        public static final byte PAGE = -81;
        public static final byte GRAPHICS = -69;
        public static final byte DATA_RESOURCE = -61;
        public static final byte DOCUMENT_ENVIRONMENT_GROUP = -60;
        public static final byte RESOURCE_GROUP = -58;
        public static final byte OBJECT_ENVIRONMENT_GROUP = -57;
        public static final byte ACTIVE_ENVIRONMENT_GROUP = -55;
        public static final byte MEDIUM_MAP = -52;
        public static final byte FORM_MAP = -51;
        public static final byte NAME_RESOURCE = -50;
        public static final byte PAGE_OVERLAY = -40;
        public static final byte RESOURCE_ENVIROMENT_GROUP = -39;
        public static final byte OVERLAY = -33;
        public static final byte DATA_SUPRESSION = -22;
        public static final byte BARCODE = -21;
        public static final byte NO_OPERATION = -18;
        public static final byte IMAGE = -5;
    }

    public static interface Type {
        public static final byte ATTRIBUTE = -96;
        public static final byte COPY_COUNT = -94;
        public static final byte DESCRIPTOR = -90;
        public static final byte CONTROL = -89;
        public static final byte BEGIN = -88;
        public static final byte END = -87;
        public static final byte MAP = -85;
        public static final byte POSITION = -84;
        public static final byte PROCESS = -83;
        public static final byte INCLUDE = -81;
        public static final byte TABLE = -80;
        public static final byte MIGRATION = -79;
        public static final byte VARIABLE = -78;
        public static final byte LINK = -76;
        public static final byte DATA = -18;
    }
}

