/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.tools.BuilderContext;

public class TableContext
implements ITableColumnsInfo {
    private final Log log = new SimpleLog("FOP/RTF");
    private final BuilderContext context;
    private final List colWidths = new ArrayList();
    private int colIndex;
    private final List colRowSpanningNumber = new ArrayList();
    private final List colRowSpanningAttrs = new ArrayList();
    private final List colFirstSpanningCol = new ArrayList();
    private boolean bNextRowBelongsToHeader;

    public void setNextRowBelongsToHeader(boolean value) {
        this.bNextRowBelongsToHeader = value;
    }

    public boolean getNextRowBelongsToHeader() {
        return this.bNextRowBelongsToHeader;
    }

    public TableContext(BuilderContext ctx) {
        this.context = ctx;
    }

    public void setNextColumnWidth(Float width) {
        this.colWidths.add(width);
    }

    public RtfAttributes getColumnRowSpanningAttrs() {
        return (RtfAttributes)this.colRowSpanningAttrs.get(this.colIndex);
    }

    public Integer getColumnRowSpanningNumber() {
        return (Integer)this.colRowSpanningNumber.get(this.colIndex);
    }

    @Override
    public boolean getFirstSpanningCol() {
        Boolean b = (Boolean)this.colFirstSpanningCol.get(this.colIndex);
        return b;
    }

    public void setCurrentColumnRowSpanning(Integer iRowSpanning, RtfAttributes attrs) {
        if (this.colIndex < this.colRowSpanningNumber.size()) {
            this.colRowSpanningNumber.set(this.colIndex, iRowSpanning);
            this.colRowSpanningAttrs.set(this.colIndex, attrs);
        } else {
            this.colRowSpanningNumber.add(iRowSpanning);
            this.colRowSpanningAttrs.add(this.colIndex, attrs);
        }
    }

    public void setNextColumnRowSpanning(Integer iRowSpanning, RtfAttributes attrs) {
        this.colRowSpanningNumber.add(iRowSpanning);
        this.colRowSpanningAttrs.add(this.colIndex, attrs);
    }

    public void setCurrentFirstSpanningCol(boolean bFirstSpanningCol) {
        if (this.colIndex < this.colRowSpanningNumber.size()) {
            while (this.colIndex >= this.colFirstSpanningCol.size()) {
                this.setNextFirstSpanningCol(false);
            }
            this.colFirstSpanningCol.set(this.colIndex, bFirstSpanningCol);
        } else {
            this.colFirstSpanningCol.add(bFirstSpanningCol);
        }
    }

    public void setNextFirstSpanningCol(boolean bFirstSpanningCol) {
        this.colFirstSpanningCol.add(bFirstSpanningCol);
    }

    public void decreaseRowSpannings() {
        for (int z = 0; z < this.colRowSpanningNumber.size(); ++z) {
            Integer i = (Integer)this.colRowSpanningNumber.get(z);
            if (i > 0) {
                i = i - 1;
            }
            this.colRowSpanningNumber.set(z, i);
            if (i != 0) continue;
            this.colRowSpanningAttrs.set(z, null);
            this.colFirstSpanningCol.set(z, false);
        }
    }

    @Override
    public void selectFirstColumn() {
        this.colIndex = 0;
    }

    @Override
    public void selectNextColumn() {
        ++this.colIndex;
    }

    @Override
    public float getColumnWidth() {
        if (this.colIndex < 0) {
            throw new IllegalStateException("colIndex must not be negative!");
        }
        if (this.colIndex >= this.getNumberOfColumns()) {
            this.log.warn("Column width for column " + (this.colIndex + 1) + " is not defined, using " + 200.0f);
            while (this.colIndex >= this.getNumberOfColumns()) {
                this.setNextColumnWidth(Float.valueOf(200.0f));
            }
        }
        return ((Float)this.colWidths.get(this.colIndex)).floatValue();
    }

    public void setColumnIndex(int index) {
        this.colIndex = index;
    }

    @Override
    public int getColumnIndex() {
        return this.colIndex;
    }

    @Override
    public int getNumberOfColumns() {
        return this.colWidths.size();
    }
}

