/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.Configuration;

public final class Version {
    private static final int[] STRUCTURED_VERSION = new int[]{9, 5, 1, 1};
    private static final String VERSION = "9.5.1.1";
    private static final String BUILD = "041714";
    private static final String RELEASE_DATE = "2013-06-19";
    private static final String MAJOR_RELEASE_DATE = "2013-04-17";

    private Version() {
    }

    public static String getProductName() {
        return "SAXON";
    }

    public static String getProductVendor() {
        return "Saxonica";
    }

    public static String getProductVariantAndVersion(Configuration config) {
        String edition = config.getEditionCode();
        if ((edition.equals("PE") || edition.equals("EE")) && !config.isLicensedFeature(8)) {
            edition = edition + " (unlicensed)";
        }
        return edition + " " + Version.getProductVersion();
    }

    public static String getProductVersion() {
        return VERSION;
    }

    public static int[] getStructuredVersionNumber() {
        return STRUCTURED_VERSION;
    }

    public static String getReleaseDate() {
        return RELEASE_DATE;
    }

    public static String getMajorReleaseDate() {
        return MAJOR_RELEASE_DATE;
    }

    public static String getXSLVersionString() {
        return "2.0";
    }

    public static String getProductTitle() {
        return Version.getProductName() + ' ' + Version.getProductVersion() + " from Saxonica";
    }

    public static String getWebSiteAddress() {
        return "http://www.saxonica.com/";
    }

    public static void main(String[] args) {
        System.err.println(Version.getProductTitle() + " (build " + BUILD + ')');
    }
}

