package com.saxonica.testdriver;


import net.sf.saxon.Version;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.value.DateTimeValue;

import javax.xml.stream.XMLStreamException;
import java.io.IOException;

public class Xslt30ResultsDocument extends ResultsDocument {

    public Xslt30ResultsDocument(TestDriver testDriver, Spec sp) {
        super(testDriver, sp);
    }

    public void writeResultFilePreamble(Processor processor, XdmNode catalog)
            throws IOException, SaxonApiException, XMLStreamException {
        createWriter(processor);
        results.writeStartElement("test-suite-result");
        results.writeDefaultNamespace("http://www.w3.org/2012/11/xslt30-test-results");
        results.writeStartElement("implementation");
        results.writeAttribute("name", "Saxon-EE");
        results.writeAttribute("version", Version.getProductVersion());
        results.writeAttribute("anonymous-result-column", "false");
        results.writeEmptyElement("organization");
        results.writeAttribute("name", "http://www.saxonica.com/");
        results.writeAttribute("anonymous", "false");
        results.writeEmptyElement("submitter");
        results.writeAttribute("name", "Michael Kay");
        results.writeAttribute("email", "mike@saxonica.com");
        //outputDiscretionaryItems();
        results.writeEndElement(); //implementation
        results.writeEmptyElement("test-run");
        results.writeAttribute("dateRun", getDate());
        results.writeAttribute("testsuiteVersion", "3.0.1");

    }

}

