/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.factory;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.internal.factory.BeanVisibility;
import org.springframework.config.java.internal.factory.JavaConfigBeanFactory;
import org.springframework.config.java.valuesource.CompositeValueResolver;
import org.springframework.config.java.valuesource.ValueResolutionException;
import org.springframework.config.java.valuesource.ValueResolver;
import org.springframework.util.StringUtils;

class ExternalValueInjectingBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(ExternalValueInjectingBeanPostProcessor.class);
    private final JavaConfigBeanFactory beanFactory;
    private ValueResolver valueResolver;

    public ExternalValueInjectingBeanPostProcessor(JavaConfigBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (beanName == null) {
            return bean;
        }
        if (!this.beanFactory.containsBeanDefinition(beanName, BeanVisibility.PUBLIC)) {
            return bean;
        }
        BeanDefinition beanDef = this.beanFactory.getBeanDefinition(beanName, BeanVisibility.PUBLIC);
        if (!beanDef.hasAttribute("IS_CONFIGURATION_CLASS")) {
            return bean;
        }
        Class<?> currentClass = bean.getClass();
        try {
            do {
                Field[] fields;
                Field[] fieldArray = fields = currentClass.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    ExternalValue evAnno = field.getAnnotation(ExternalValue.class);
                    if (evAnno != null) {
                        if (this.valueResolver == null) {
                            this.valueResolver = CompositeValueResolver.forMember(this.beanFactory.getParentBeanFactory(), field);
                        }
                        field.setAccessible(true);
                        String valueName = StringUtils.hasText((String)evAnno.value()) ? evAnno.value() : field.getName();
                        try {
                            Object value = this.valueResolver.resolve(valueName, field.getType());
                            field.set(bean, value);
                        }
                        catch (ValueResolutionException ex) {
                            Object defaultValue = field.get(bean);
                            if (defaultValue == null) {
                                throw ex;
                            }
                            log.info((Object)String.format("No external value could be found for %s.%s field, falling back to its default value '%s'", currentClass.getSimpleName(), field.getName(), defaultValue));
                        }
                    }
                    ++n2;
                }
            } while ((currentClass = currentClass.getSuperclass()) != null);
        }
        catch (NoSuchMethodError ex) {
            throw new FatalBeanException("Programmer error: could not find method via reflection", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new FatalBeanException("Programmer error: illegal access, forgot to use setAccessible(true)?", (Throwable)ex);
        }
        return bean;
    }
}

