/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.factory.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.AutoBean;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.Lazy;
import org.springframework.config.java.annotation.Meta;
import org.springframework.config.java.annotation.Primary;
import org.springframework.config.java.internal.factory.BeanFactoryProvider;
import org.springframework.config.java.internal.factory.BeanVisibility;
import org.springframework.config.java.internal.factory.JavaConfigBeanFactory;
import org.springframework.config.java.internal.factory.support.RequiredAnnotationBeanPostProcessor;
import org.springframework.config.java.internal.model.AbstractValidatableAnnotatedMethod;
import org.springframework.config.java.internal.model.AutoBeanMethod;
import org.springframework.config.java.internal.model.BeanMethod;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.ConfigurationModel;
import org.springframework.config.java.internal.model.MalformedJavaConfigurationException;
import org.springframework.config.java.model.ModelClass;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.config.java.plugin.Plugin;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConfigurationModelBeanDefinitionReader {
    private static final Log logger = LogFactory.getLog(ConfigurationModelBeanDefinitionReader.class);
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";
    private final JavaConfigBeanFactory beanFactory;

    public ConfigurationModelBeanDefinitionReader(JavaConfigBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public int loadBeanDefinitions(ConfigurationModel model) {
        int initialBeanDefCount = this.beanFactory.getBeanDefinitionCount();
        ConfigurationClass[] configurationClassArray = model.getAllConfigurationClasses();
        int n = configurationClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationClass configClass = configurationClassArray[n2];
            this.loadBeanDefinitionsForConfigurationClass(configClass);
            ++n2;
        }
        return this.beanFactory.getBeanDefinitionCount() - initialBeanDefCount;
    }

    private void loadBeanDefinitionsForConfigurationClass(ConfigurationClass configClass) {
        this.loadBeanDefinitionsForDeclaringClass(configClass.getDeclaringClass());
        this.doLoadBeanDefinitionForConfigurationClass(configClass);
        Object[] objectArray = configClass.getBeanMethods();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BeanMethod beanMethod = objectArray[n2];
            this.loadBeanDefinitionsForBeanMethod(configClass, beanMethod);
            ++n2;
        }
        objectArray = configClass.getAutoBeanMethods();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            AbstractValidatableAnnotatedMethod autoBeanMethod = objectArray[n2];
            this.loadBeanDefinitionsForAutoBeanMethod((AutoBeanMethod)autoBeanMethod);
            ++n2;
        }
        objectArray = configClass.getPluginAnnotations();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object pluginAnnotation = objectArray[n2];
            this.loadBeanDefinitionsForPluginAnnotation((Annotation)pluginAnnotation);
            ++n2;
        }
    }

    private void loadBeanDefinitionsForPluginAnnotation(Annotation pluginAnnotation) {
        Class<?> pluginAnnoClass = pluginAnnotation.getClass();
        Plugin pluginMetadata = (Plugin)AnnotationUtils.findAnnotation(pluginAnnoClass, Plugin.class);
        Assert.isTrue((pluginMetadata != null ? 1 : 0) != 0, (String)String.format("%s annotation is not annotated as a @Plugin", pluginAnnoClass));
        Class<ConfigurationPlugin<?>> handler = pluginMetadata.handler();
        try {
            Constructor<ConfigurationPlugin<?>> noArgConstructor = handler.getDeclaredConstructor(new Class[0]);
            noArgConstructor.setAccessible(true);
            ConfigurationPlugin<?> pluginHandler = noArgConstructor.newInstance(new Object[0]);
            pluginHandler.handle(pluginAnnotation, this.beanFactory);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void doLoadBeanDefinitionForConfigurationClass(ConfigurationClass configClass) {
        Configuration metadata = configClass.getMetadata();
        if (metadata.checkRequired()) {
            RootBeanDefinition requiredAnnotationPostProcessor = new RootBeanDefinition();
            Class<RequiredAnnotationBeanPostProcessor> beanClass = RequiredAnnotationBeanPostProcessor.class;
            String beanName = String.valueOf(beanClass.getName()) + "#0";
            requiredAnnotationPostProcessor.setBeanClass(beanClass);
            requiredAnnotationPostProcessor.setResourceDescription("ensures @Required methods have been invoked");
            this.beanFactory.registerBeanDefinition(beanName, (BeanDefinition)requiredAnnotationPostProcessor, BeanVisibility.PUBLIC);
        }
        GenericBeanDefinition configBeanDef = new GenericBeanDefinition();
        configBeanDef.setBeanClassName(configClass.getName());
        configBeanDef.addMetadataAttribute(new BeanMetadataAttribute("IS_CONFIGURATION_CLASS", (Object)true));
        String configBeanId = configClass.getId();
        if (this.beanFactory.containsBeanDefinition(configBeanId, BeanVisibility.PUBLIC)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Copying property and constructor arg values from existing bean definition for @Configuration class %s to new bean definition", configBeanId));
            }
            AbstractBeanDefinition existing = (AbstractBeanDefinition)this.beanFactory.getBeanDefinition(configBeanId, BeanVisibility.PUBLIC);
            configBeanDef.setPropertyValues(existing.getPropertyValues());
            configBeanDef.setConstructorArgumentValues(existing.getConstructorArgumentValues());
            configBeanDef.setResource(existing.getResource());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Registering %s bean definition for @Configuration class %s", new Object[]{BeanVisibility.PUBLIC, configBeanId}));
        }
        this.beanFactory.registerBeanDefinition(configBeanId, (BeanDefinition)configBeanDef, BeanVisibility.PUBLIC);
    }

    private void loadBeanDefinitionsForBeanMethod(ConfigurationClass configClass, BeanMethod beanMethod) {
        String destroyMethodName;
        String initMethodName;
        BeanDefinition existingBeanDef;
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setFactoryBeanName(configClass.getId());
        beanDef.setFactoryMethodName(beanMethod.getName());
        Bean metadata = (Bean)beanMethod.getMetadata();
        Configuration defaults = configClass.getMetadata();
        beanDef.setScope(metadata.scope());
        if (metadata.autowire() != AnnotationUtils.getDefaultValue(Bean.class, (String)"autowire")) {
            beanDef.setAutowireMode(metadata.autowire().value());
        } else if (defaults.defaultAutowire() != AnnotationUtils.getDefaultValue(Configuration.class, (String)"defaultAutowire")) {
            beanDef.setAutowireMode(defaults.defaultAutowire().value());
        }
        String beanName = this.beanFactory.getBeanNamingStrategy().getBeanName(beanMethod);
        if (ConfigurationModelBeanDefinitionReader.containsBeanDefinitionIncludingAncestry(this.beanFactory, beanName) && (existingBeanDef = ConfigurationModelBeanDefinitionReader.getBeanDefinitionIncludingAncestry(this.beanFactory, beanName)).getAttribute("org.springframework.config.java") == null) {
            if (!metadata.allowOverriding()) {
                ConfigurationClass configurationClass = configClass;
                configurationClass.getClass();
                ConfigurationClass.IllegalBeanOverrideError error = new ConfigurationClass.IllegalBeanOverrideError(configurationClass, null, beanMethod);
                throw new MalformedJavaConfigurationException(error);
            }
            logger.info((Object)String.format("Skipping loading bean definition for %s: a definition for bean '%s' already exists. This is likely due to an override in XML.", beanMethod, beanName));
            return;
        }
        beanDef.setRole(metadata.role());
        String[] stringArray = metadata.aliases();
        int n = stringArray.length;
        int error = 0;
        while (error < n) {
            String alias = stringArray[error];
            this.beanFactory.registerAlias(beanName, alias, BeanVisibility.PUBLIC);
            ++error;
        }
        if (metadata.primary() == Primary.TRUE) {
            beanDef.setPrimary(true);
        }
        if (metadata.lazy() == Lazy.TRUE || metadata.lazy() == Lazy.UNSPECIFIED && defaults.defaultLazy() == Lazy.TRUE) {
            beanDef.setLazyInit(true);
        }
        if (StringUtils.hasText((String)(initMethodName = metadata.initMethodName()))) {
            beanDef.setInitMethodName(initMethodName);
        }
        if (StringUtils.hasText((String)(destroyMethodName = metadata.destroyMethodName()))) {
            beanDef.setDestroyMethodName(destroyMethodName);
        }
        if (beanMethod.isScopedProxy()) {
            RootBeanDefinition targetDef = beanDef;
            String targetBeanName = ConfigurationModelBeanDefinitionReader.resolveHiddenScopedProxyBeanName(beanName);
            RootBeanDefinition scopedProxyDefinition = new RootBeanDefinition(ScopedProxyFactoryBean.class);
            scopedProxyDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)targetBeanName);
            scopedProxyDefinition.setScope(((Bean)beanMethod.getMetadata()).scope());
            if (beanMethod.getScopedProxyMetadata().proxyTargetClass()) {
                targetDef.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
            } else {
                scopedProxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.FALSE);
            }
            targetDef.setAutowireCandidate(false);
            this.beanFactory.registerBeanDefinition(targetBeanName, (BeanDefinition)targetDef, BeanVisibility.PUBLIC);
            beanDef = scopedProxyDefinition;
        }
        Meta[] metaArray = metadata.meta();
        int n2 = metaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Meta meta = metaArray[n3];
            beanDef.addMetadataAttribute(new BeanMetadataAttribute(meta.key(), (Object)meta.value()));
            ++n3;
        }
        if (metadata.dependsOn().length > 0) {
            beanDef.setDependsOn(metadata.dependsOn());
        }
        BeanVisibility visibility = BeanVisibility.visibilityOf(beanMethod.getModifiers());
        logger.info((Object)String.format("Registering %s bean definition for @Bean method %s.%s()", new Object[]{visibility, configClass.getName(), beanName}));
        this.beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDef, visibility);
    }

    private static boolean containsBeanDefinitionIncludingAncestry(JavaConfigBeanFactory beanFactory, String beanName) {
        try {
            ConfigurationModelBeanDefinitionReader.getBeanDefinitionIncludingAncestry(beanFactory, beanName);
            return true;
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return false;
        }
    }

    private static BeanDefinition getBeanDefinitionIncludingAncestry(JavaConfigBeanFactory beanFactory, String beanName) {
        JavaConfigBeanFactory bf = beanFactory;
        do {
            if (bf.containsBeanDefinition(beanName)) {
                return bf.getBeanDefinition(beanName);
            }
            BeanFactory parent = bf.getParentBeanFactory();
            if (parent == null) {
                bf = null;
                continue;
            }
            if (parent instanceof ConfigurableListableBeanFactory) {
                bf = (ConfigurableListableBeanFactory)parent;
                continue;
            }
            if (parent instanceof AbstractApplicationContext) {
                bf = ((AbstractApplicationContext)parent).getBeanFactory();
                continue;
            }
            throw new IllegalStateException("unknown parent type: " + parent.getClass().getName());
        } while (bf != null);
        throw new NoSuchBeanDefinitionException(String.format("No bean definition matching name '%s' could be found in %s or its ancestry", beanName, beanFactory));
    }

    private void loadBeanDefinitionsForAutoBeanMethod(AutoBeanMethod method) {
        ModelClass returnType = method.getReturnType();
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClassName(returnType.getName());
        beanDef.setAutowireMode(((AutoBean)method.getMetadata()).autowire().value());
        this.beanFactory.registerBeanDefinition(method.getName(), (BeanDefinition)beanDef, BeanVisibility.PUBLIC);
    }

    private void loadBeanDefinitionsForDeclaringClass(ConfigurationClass declaringClass) {
        if (declaringClass == null) {
            return;
        }
        logger.info((Object)String.format("Found declaring class [%s] on configClass [%s]", declaringClass, declaringClass));
        String factoryName = BeanFactoryProvider.BEAN_NAME;
        Object parentBF = this.beanFactory.containsBean(factoryName) ? (BeanFactory)this.beanFactory.getBean(factoryName, new Object[]{declaringClass.getName()}) : new DefaultListableBeanFactory();
        this.beanFactory.getParentBeanFactory().setParentBeanFactory((BeanFactory)parentBF);
    }

    public static String resolveHiddenScopedProxyBeanName(String originalBeanName) {
        Assert.hasText((String)originalBeanName);
        return TARGET_NAME_PREFIX.concat(originalBeanName);
    }
}

