/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.bpp.sjc118;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

import org.springframework.config.java.annotation.Configuration;

import org.springframework.context.support.ApplicationObjectSupport;

import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


/**
 * TODO: JAVADOC
 *
 * @author  Baruch Sadogursky
 * @author  Chris Beams
 */
@Component
public class ConfigurationSupportInjector extends ApplicationObjectSupport implements BeanPostProcessor {
    private static final Log logger = LogFactory.getLog(ConfigurationSupportInjector.class);

    private InjectableConfigurationSupport injectableConfigurationSupport;

    /**
     * This doesn't work. Why?
     *
     * @param  injectableConfigurationSupport
     */
    @Autowired
    public void setInjectableConfigurationSupport(InjectableConfigurationSupport injectableConfigurationSupport) {
        this.injectableConfigurationSupport = injectableConfigurationSupport;
        logger.info("InjectableConfigurationSupport created");
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException { return bean; }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (logger.isInfoEnabled())
            logger.info("postProcessBeforeInitialization for " + beanName);

        Class<?> beanClass = bean.getClass();
        if (beanClass.isAnnotationPresent(Configuration.class)) {
            logger.info("Injecting ConfigurationSupportInjector");
            for (Method method : beanClass.getMethods()) {
                if (method.isAnnotationPresent(InjectConfigurationSupport.class)) {
                    try {
                        if (logger.isInfoEnabled())
                            logger.info("Setter for Support found: " + method.getName());

                        method.invoke(bean, injectableConfigurationSupport);
                        logger.info("Setter for Support invoked");
                    } catch (IllegalAccessException e) {
                        logger.warn("Failed to inject ConfiguationSupport", e);
                    } catch (InvocationTargetException e) {
                        logger.warn("Failed to inject ConfiguationSupport", e.getCause());
                    }
                }
            }
        }

        return bean;
    }

}
