/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.aspects;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

/**
 * Aspect to illustrate Spring-driven load-time weaving.
 *
 * @author Ramnivas Laddad
 * @since 2.5
 */
@Aspect
public abstract class AbstractTraceAspect {

    private static final Log logger = LogFactory.getLog(AbstractTraceAspect.class);

    @Pointcut
    public abstract void traced();

    @Before("traced()")
    public void trace(JoinPoint.StaticPart jpsp) {
        if (logger.isTraceEnabled()) {
            logger.trace("Entering " + jpsp.getSignature().toLongString());
        }
    }

}
