/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.web;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.samples.petclinic.Clinic;
import org.springframework.samples.petclinic.Vet;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.RequestToViewNameTranslator;


/**
 * Controller that handles all {@link Vet}-related requests,
 * i.e.: all requests for /petclinic/main/vet/*
 * 
 * @author Chris Beams
 */
@Controller
public class VetController {

    private Clinic clinic;

    @Autowired
    public VetController(Clinic clinic) {
        this.clinic = clinic;
    }

    /**
     * Custom handler for displaying the list of all known vets,
     * i.e.: requests for /petclinic/main/vet/list.
     * <p/>
     * Returns a collection of {@link Vet} objects and relies on
     * naming conventions to ensure that that object will be made
     * available in request scope as 'vetList'.  View name is
     * dictated by convention-over-configuration using default
     * {@link RequestToViewNameTranslator}.
     * 
     * @return collection of all {@link Vet} objects
     * 
     * @see WEB-INF/jsp/vet/list.jsp
     */
    @RequestMapping
    public Collection<Vet> list() {
        return this.clinic.getVets();
    }

}
