/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.ui;

import edu.stanford.nlp.parser.ui.ParserPanel;
import edu.stanford.nlp.util.DisabledPreferencesFactory;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class Parser
extends JFrame {
    private static final long serialVersionUID = 7179757799978939358L;
    private ParserPanel parserPanel;
    private JCheckBoxMenuItem untokEngItem;
    private JCheckBoxMenuItem tokChineseItem;
    private JCheckBoxMenuItem untokChineseItem;
    private JMenu jMenu2;
    private JMenuItem loadParserItem;
    private JMenuItem loadDataItem;
    private JSeparator jSeparator1;
    private JMenu jMenu1;
    private JMenuItem exitItem;
    private JMenuBar jMenuBar1;

    public Parser() {
        this((String)null, (String)null);
    }

    public Parser(String parserFilename, String dataFilename) {
        this.initComponents();
        this.parserPanel = new ParserPanel();
        this.getContentPane().add("Center", this.parserPanel);
        if (parserFilename != null) {
            this.parserPanel.loadParser(parserFilename);
        }
        if (dataFilename != null) {
            this.parserPanel.loadFile(dataFilename);
        }
        this.pack();
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.loadDataItem = new JMenuItem();
        this.loadParserItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.untokEngItem = new JCheckBoxMenuItem();
        this.tokChineseItem = new JCheckBoxMenuItem();
        this.untokChineseItem = new JCheckBoxMenuItem();
        this.setTitle("Parser");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Parser.this.exitForm(evt);
            }
        });
        this.jMenu1.setText("File");
        this.loadDataItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.loadDataItem.setMnemonic('o');
        this.loadDataItem.setText("Load File");
        this.loadDataItem.setToolTipText("Load a data file.");
        this.loadDataItem.addActionListener(this::loadDataItemActionPerformed);
        this.jMenu1.add(this.loadDataItem);
        this.loadParserItem.setText("Load Parser");
        this.loadParserItem.addActionListener(this::loadParserItemActionPerformed);
        this.jMenu1.add(this.loadParserItem);
        this.jMenu1.add(this.jSeparator1);
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitItem.setMnemonic('x');
        this.exitItem.setText("Exit");
        this.exitItem.setToolTipText("Exits the program.");
        this.exitItem.addActionListener(this::exitItemActionPerformed);
        this.jMenu1.add(this.exitItem);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void loadParserItemActionPerformed(ActionEvent evt) {
        this.parserPanel.loadParser();
    }

    private void loadDataItemActionPerformed(ActionEvent evt) {
        this.parserPanel.loadFile();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        DisabledPreferencesFactory.install();
        String dataFilename = null;
        String parserFilename = null;
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.out.println("Usage: java edu.stanford.nlp.parser.ui.Parser [parserfilename] [textFilename]");
            } else {
                parserFilename = args[0];
                if (args.length > 1) {
                    dataFilename = args[1];
                }
            }
        }
        Parser parser = new Parser(parserFilename, dataFilename);
        parser.setVisible(true);
    }
}

