/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.util.Hosts;
import io.hawt.util.Strings;
import io.hawt.web.proxy.ProxyDetails;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAllowlist {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyAllowlist.class);
    private static final String FABRIC_MBEAN = "io.fabric8:type=Fabric";
    protected CopyOnWriteArraySet<String> allowlist;
    protected List<Pattern> regexAllowlist;
    protected MBeanServer mBeanServer;
    protected ObjectName fabricMBean;

    public ProxyAllowlist(String allowlistStr, boolean probeLocal) {
        if (Strings.isBlank(allowlistStr)) {
            this.allowlist = new CopyOnWriteArraySet();
            this.regexAllowlist = Collections.emptyList();
        } else {
            this.allowlist = new CopyOnWriteArraySet<String>(this.filterRegex(Strings.split(allowlistStr, ",")));
            this.regexAllowlist = this.buildRegexAllowlist(Strings.split(allowlistStr, ","));
        }
        if (probeLocal) {
            LOG.info("Probing local addresses ...");
            this.initialiseAllowlist();
        } else {
            LOG.info("Probing local addresses disabled");
            this.allowlist.add("localhost");
            this.allowlist.add("127.0.0.1");
        }
        LOG.info("Initial proxy allowlist: {}", this.allowlist);
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.fabricMBean = new ObjectName(FABRIC_MBEAN);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> filterRegex(List<String> allowlist) {
        ArrayList<String> result = new ArrayList<String>();
        for (String element : allowlist) {
            if (element.startsWith("r:")) continue;
            result.add(element);
        }
        return result;
    }

    protected List<Pattern> buildRegexAllowlist(List<String> allowlist) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String element : allowlist) {
            if (!element.startsWith("r:")) continue;
            String regex = element.substring(2);
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    protected void initialiseAllowlist() {
        Map<String, Set<InetAddress>> localAddresses = Hosts.getNetworkInterfaceAddresses(true);
        for (Set<InetAddress> addresses : localAddresses.values()) {
            for (InetAddress address : addresses) {
                this.allowlist.add(address.getHostAddress());
                this.allowlist.add(address.getHostName());
                this.allowlist.add(address.getCanonicalHostName());
            }
        }
    }

    public boolean isAllowed(ProxyDetails details) {
        if (details.isAllowed(this.allowlist)) {
            return true;
        }
        LOG.debug("Updating proxy allowlist: {}, {}", this.allowlist, (Object)details);
        if (this.update() && details.isAllowed(this.allowlist)) {
            return true;
        }
        return details.isAllowed(this.regexAllowlist);
    }

    public boolean update() {
        if (!this.mBeanServer.isRegistered(this.fabricMBean)) {
            LOG.debug("Allowlist MBean not available");
            return false;
        }
        Set<String> newAllowlist = this.invokeMBean();
        int previousSize = this.allowlist.size();
        this.allowlist.addAll(newAllowlist);
        if (this.allowlist.size() == previousSize) {
            LOG.debug("No new proxy allowlist to update");
            return false;
        }
        LOG.info("Updated proxy allowlist: {}", this.allowlist);
        return true;
    }

    protected Set<String> invokeMBean() {
        HashSet<String> list = new HashSet<String>();
        try {
            List containers = (List)this.mBeanServer.invoke(this.fabricMBean, "containers", new Object[]{Arrays.asList("localHostname", "localIp", "manualIp", "publicHostname", "publicIp")}, new String[]{List.class.getName()});
            LOG.debug("Returned containers from MBean: {}", (Object)containers);
            for (Map container : containers) {
                for (Object value : container.values()) {
                    if (value == null || !Strings.isNotBlank(value.toString())) continue;
                    list.add(value.toString());
                }
            }
            LOG.debug("Extracted allowlist: {}", list);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            LOG.error("Invocation to allowlist MBean failed: " + e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

