---
title: "Beam Mascot"
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Beam Mascot Design

This page contains Apache Beam's mascot designs.

Beam Firefly is cute, friendly, agile, easy to use, and its main objective is to fetch streams and batches of data and process it. The mascot’s model sheet is useful to understand its features, capabilities, as well as its morphology.  The original design of the mascot was created by [Julian G. Bruno](https://www.artstation.com/jbruno) and was donated to the Apache Beam community under the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0).

You can browse the original mascot and its adaptations in different sizes and image formats in [this directory](https://github.com/apache/beam/tree/master/website/www/site/static/images/mascot/).

[![Model Sheet](/images/mascot/model_sheet.png)](/images/mascot/model_sheet.png)

## Beam mascot adaptations

The original Beam mascot - simple and eye-catching, was developed with its body shaped like a “B” from Beam’s logo. The ideal choice for printing in any size or using for swags. The lit-up tail is another element to play with if you want to animate the firefly.

<img src="/images/mascot/beam_mascot_500x500.png" width="200"/>

The adaptation below represents independent learning. The bubble can be replaced by any other description. An ideal choice for promoting Beam talks, workshops, and webinars where the Beam community learns new things.

<img src="/images/mascot/learning_independently_500x500.png" width="280"/>

The second adaptation below represents data processing. The data goes through the firefly’s tail, filling the entire body with streams of information (for example, codes) and when it is done processing the mascot’s entire body outline lits up in yellow color to tell that it is loaded with data and is ready to process it, while it becomes stronger and faster. Mascot returns to its original status after finishing this process.

<img src="/images/mascot/big_data_500x500.png" width="300"/>


<!--
![Beam Firefly](/images/mascot/beam_mascot_500x500.png =100x)
![Learning Independently](/images/mascot/learning_independently_500x500.png =100x)
![Processing Big Data](/images/mascot/big_data_500x500.png =100x)
-->


## Colors
For the Beam mascot, we used Apache Beam project’s predefined colors and fonts. [This document](/downloads/palette.pdf) has more information. Color Palette (RGB), Orange : #FF570B, Yellow : #FFF200, White: #FFFFFF, Black: #1D1D1B
