/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.utils.http;

import java.util.LinkedList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class ScriptEnginePool {
    private static final int DEFAULT_SIZE = 10;
    private final LinkedList pool = new LinkedList();
    private int engines = 0;
    private final int capacity;
    private final ScriptEngineFactory factory;
    private final boolean isMultithreaded;

    public ScriptEnginePool(ScriptEngineFactory factory, int capacity) {
        this.factory = factory;
        this.capacity = capacity;
        String param = (String)factory.getParameter("THREADING");
        if (param != null && param.equals("MULTITHREADED")) {
            this.isMultithreaded = true;
            this.pool.add(factory.getScriptEngine());
        } else {
            this.isMultithreaded = false;
        }
    }

    public ScriptEnginePool(ScriptEngineFactory factory) {
        this(factory, 10);
    }

    public synchronized void free(ScriptEngine eng) {
        this.pool.add(eng);
        this.notifyAll();
    }

    public synchronized ScriptEngine get() {
        if (this.isMultithreadingSupported()) {
            return (ScriptEngine)this.pool.getFirst();
        }
        if (!this.pool.isEmpty()) {
            return (ScriptEngine)this.pool.removeFirst();
        }
        if (this.engines < this.capacity) {
            ++this.engines;
            return this.factory.getScriptEngine();
        }
        while (!this.pool.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return (ScriptEngine)this.pool.removeFirst();
    }

    public boolean isMultithreadingSupported() {
        return this.isMultithreaded;
    }
}

