/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.EmptyListIterator;
import org.apache.commons.collections4.iterators.EmptyMapIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections4.iterators.EnumerationIterator;
import org.apache.commons.collections4.iterators.IteratorChainTest;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;
import org.apache.commons.collections4.iterators.ZippingIterator;
import org.apache.commons.collections4.map.EntrySetToMapIteratorAdapter;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IteratorUtilsTest {
    private List<Integer> collectionA;
    private List<Integer> collectionEven;
    private List<Integer> collectionOdd;
    private final Collection<Integer> emptyCollection = new ArrayList<Integer>(1);
    private Iterable<Integer> iterableA;

    private NodeList createNodeList(final Node[] nodes) {
        return new NodeList(){
            final /* synthetic */ IteratorUtilsTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int getLength() {
                return nodes.length;
            }

            @Override
            public Node item(int index) {
                return nodes[index];
            }
        };
    }

    private Node[] createNodes() {
        Node node1 = (Node)EasyMock.createMock(Node.class);
        Node node2 = (Node)EasyMock.createMock(Node.class);
        Node node3 = (Node)EasyMock.createMock(Node.class);
        Node node4 = (Node)EasyMock.createMock(Node.class);
        EasyMock.replay((Object[])new Object[]{node1});
        EasyMock.replay((Object[])new Object[]{node2});
        EasyMock.replay((Object[])new Object[]{node3});
        EasyMock.replay((Object[])new Object[]{node4});
        return new Node[]{node1, node2, node3, node4};
    }

    private Iterator<String> getImmutableIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        return IteratorUtils.unmodifiableIterator(list.iterator());
    }

    private ListIterator<String> getImmutableListIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        return IteratorUtils.unmodifiableListIterator(list.listIterator());
    }

    @BeforeEach
    public void setUp() {
        this.collectionA = new ArrayList<Integer>();
        this.collectionA.add(1);
        this.collectionA.add(2);
        this.collectionA.add(2);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.iterableA = this.collectionA;
        this.collectionEven = Arrays.asList(2, 4, 6, 8, 10, 12);
        this.collectionOdd = Arrays.asList(1, 3, 5, 7, 9, 11);
    }

    @Test
    public void testArrayIterator() {
        Object[] objArray = new Object[]{"a", "b", "c"};
        ResettableIterator iterator = IteratorUtils.arrayIterator((Object[])objArray);
        Assertions.assertEquals((Object)"a", (Object)iterator.next());
        Assertions.assertEquals((Object)"b", (Object)iterator.next());
        iterator.reset();
        Assertions.assertEquals((Object)"a", (Object)iterator.next());
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.arrayIterator((Object)0));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.arrayIterator((Object[])null));
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)1);
        Assertions.assertEquals((Object)"b", (Object)iterator.next());
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object[])objArray, (int)-1));
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)3);
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object[])objArray, (int)4));
        iterator = IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)3);
        Assertions.assertEquals((Object)"c", (Object)iterator.next());
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)4));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object[])objArray, (int)-1, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.arrayIterator((Object[])objArray, (int)2, (int)1));
        int[] intArray = new int[]{0, 1, 2};
        iterator = IteratorUtils.arrayIterator((Object)intArray);
        Assertions.assertEquals((Object)0, (Object)iterator.next());
        Assertions.assertEquals((Object)1, (Object)iterator.next());
        iterator.reset();
        Assertions.assertEquals((Object)0, (Object)iterator.next());
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)1);
        Assertions.assertEquals((Object)1, (Object)iterator.next());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object)intArray, (int)-1));
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)3);
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object)intArray, (int)4));
        iterator = IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)3);
        Assertions.assertEquals((Object)2, (Object)iterator.next());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)4));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayIterator((Object)intArray, (int)-1, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.arrayIterator((Object)intArray, (int)2, (int)1));
    }

    @Test
    public void testArrayListIterator() {
        Object[] objArray = new Object[]{"a", "b", "c", "d"};
        ResettableListIterator iterator = IteratorUtils.arrayListIterator((Object[])objArray);
        Assertions.assertFalse((boolean)iterator.hasPrevious());
        Assertions.assertEquals((int)-1, (int)iterator.previousIndex());
        Assertions.assertEquals((int)0, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)"a", (Object)iterator.next());
        Assertions.assertEquals((Object)"a", (Object)iterator.previous());
        Assertions.assertEquals((Object)"a", (Object)iterator.next());
        Assertions.assertEquals((int)0, (int)iterator.previousIndex());
        Assertions.assertEquals((int)1, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)"b", (Object)iterator.next());
        Assertions.assertEquals((Object)"c", (Object)iterator.next());
        Assertions.assertEquals((Object)"d", (Object)iterator.next());
        Assertions.assertEquals((int)4, (int)iterator.nextIndex());
        Assertions.assertEquals((int)3, (int)iterator.previousIndex());
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.arrayListIterator((Object)0));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.arrayListIterator((Object[])null));
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)1);
        Assertions.assertEquals((int)-1, (int)iterator.previousIndex());
        Assertions.assertFalse((boolean)iterator.hasPrevious());
        Assertions.assertEquals((int)0, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)"b", (Object)iterator.next());
        Assertions.assertEquals((int)0, (int)iterator.previousIndex());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object[])objArray, (int)-1));
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)3);
        Assertions.assertTrue((boolean)iterator.hasNext());
        ResettableListIterator finalIterator = iterator;
        Assertions.assertThrows(NoSuchElementException.class, () -> finalIterator.previous());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object[])objArray, (int)5));
        iterator = IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)3);
        Assertions.assertEquals((Object)"c", (Object)iterator.next());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object[])objArray, (int)-1, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.arrayListIterator((Object[])objArray, (int)2, (int)1));
        int[] intArray = new int[]{0, 1, 2};
        iterator = IteratorUtils.arrayListIterator((Object)intArray);
        Assertions.assertEquals((int)iterator.previousIndex(), (int)-1);
        Assertions.assertFalse((boolean)iterator.hasPrevious());
        Assertions.assertEquals((int)0, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)0, (Object)iterator.next());
        Assertions.assertEquals((int)0, (int)iterator.previousIndex());
        Assertions.assertEquals((int)1, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)1, (Object)iterator.next());
        Assertions.assertEquals((int)1, (int)iterator.previousIndex());
        Assertions.assertEquals((int)2, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)1, (Object)iterator.previous());
        Assertions.assertEquals((Object)1, (Object)iterator.next());
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)1);
        Assertions.assertEquals((int)-1, (int)iterator.previousIndex());
        Assertions.assertFalse((boolean)iterator.hasPrevious());
        Assertions.assertEquals((int)0, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)1, (Object)iterator.next());
        Assertions.assertEquals((Object)1, (Object)iterator.previous());
        Assertions.assertEquals((Object)1, (Object)iterator.next());
        Assertions.assertEquals((int)0, (int)iterator.previousIndex());
        Assertions.assertEquals((int)1, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)2, (Object)iterator.next());
        Assertions.assertEquals((int)1, (int)iterator.previousIndex());
        Assertions.assertEquals((int)2, (int)iterator.nextIndex());
        Assertions.assertEquals((Object)2, (Object)iterator.previous());
        Assertions.assertEquals((int)0, (int)iterator.previousIndex());
        Assertions.assertEquals((int)1, (int)iterator.nextIndex());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object)intArray, (int)-1), (String)"Expecting IndexOutOfBoundsException");
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)3);
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object)intArray, (int)4), (String)"Expecting IndexOutOfBoundsException");
        iterator = IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)3);
        Assertions.assertFalse((boolean)iterator.hasPrevious());
        Assertions.assertEquals((int)-1, (int)iterator.previousIndex());
        Assertions.assertEquals((Object)2, (Object)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasPrevious());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)4));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.arrayListIterator((Object)intArray, (int)-1, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.arrayListIterator((Object)intArray, (int)2, (int)1));
    }

    @Test
    public void testAsEnumerationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.asEnumeration(null));
    }

    @Test
    public void testAsIterable() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        Iterable iterable = IteratorUtils.asIterable(iterator);
        int expected = 0;
        for (Integer actual : iterable) {
            Assertions.assertEquals((int)expected, (int)actual);
            ++expected;
        }
        Assertions.assertTrue((expected > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)IteratorUtils.asIterable(iterator).iterator().hasNext(), (String)"should not be able to iterate twice");
    }

    @Test
    public void testAsIterableNull() {
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.asIterable(null));
    }

    @Test
    public void testAsIterator() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("zero");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Assertions.assertTrue((boolean)(IteratorUtils.asIterator(en) instanceof Iterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.asIterator(null));
    }

    @Test
    public void testAsIteratorNull() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("test");
        Vector<String> vector = new Vector<String>();
        vector.addElement("test");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Assertions.assertTrue((boolean)(IteratorUtils.asIterator(en, coll) instanceof Iterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.asIterator(null, (Collection)coll));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.asIterator((Enumeration)en, null));
    }

    @Test
    public void testAsMultipleIterable() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        Iterable iterable = IteratorUtils.asMultipleUseIterable(iterator);
        int expected = 0;
        for (Integer actual : iterable) {
            Assertions.assertEquals((int)expected, (int)actual);
            ++expected;
        }
        Assertions.assertTrue((expected > 0 ? 1 : 0) != 0);
        expected = 0;
        for (Integer actual : iterable) {
            Assertions.assertEquals((int)expected, (int)actual);
            ++expected;
        }
        Assertions.assertTrue((expected > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAsMultipleIterableNull() {
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.asMultipleUseIterable(null));
    }

    @Test
    public void testChainedIteratorArrayOfIterator() {
        IteratorChainTest iteratorChainTest = new IteratorChainTest();
        iteratorChainTest.setUp();
        Iterator iterator = IteratorUtils.chainedIterator((Iterator[])new Iterator[]{iteratorChainTest.getList1().iterator(), iteratorChainTest.getList2().iterator(), iteratorChainTest.getList3().iterator()});
        Assertions.assertEquals((Object)"One", iterator.next());
        Assertions.assertEquals((Object)"Two", iterator.next());
        Assertions.assertEquals((Object)"Three", iterator.next());
        Assertions.assertEquals((Object)"Four", iterator.next());
        Assertions.assertEquals((Object)"Five", iterator.next());
        Assertions.assertEquals((Object)"Six", iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testChainedIteratorList() {
        IteratorChainTest iteratorChainTest = new IteratorChainTest();
        iteratorChainTest.setUp();
        ArrayList<Iterator<String>> list = new ArrayList<Iterator<String>>();
        list.add(iteratorChainTest.getList1().iterator());
        list.add(iteratorChainTest.getList2().iterator());
        list.add(iteratorChainTest.getList3().iterator());
        ArrayList<String> expected = new ArrayList<String>(iteratorChainTest.getList1());
        expected.addAll(iteratorChainTest.getList2());
        expected.addAll(iteratorChainTest.getList3());
        Iterator iter = IteratorUtils.chainedIterator(list);
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(actual, expected);
    }

    @Test
    public void testChainedIteratorOfIterators() {
        ArrayList<List<Number>> lst = new ArrayList<List<Number>>();
        List<Integer> iList = Arrays.asList(1, 3);
        lst.add(Arrays.asList(Float.valueOf(3.14f), Math.sqrt(2.0)));
        Iterator<Iterator<Number>> toBeUnwound = new Iterator<Iterator<Number>>(){
            List<List<Number>> lst = Arrays.asList(Arrays.asList(1, 3), Arrays.asList(Float.valueOf(3.14f), Math.sqrt(2.0)));
            Iterator<List<Number>> lstIter = this.lst.iterator();

            @Override
            public boolean hasNext() {
                return this.lstIter.hasNext();
            }

            @Override
            public Iterator<Number> next() {
                return this.lstIter.next().iterator();
            }
        };
        List<Number> expected = Arrays.asList(1, 3, Float.valueOf(3.14f), Math.sqrt(2.0));
        Iterator iter = IteratorUtils.chainedIterator((Iterator)toBeUnwound);
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(actual, expected);
    }

    @Test
    public void testChainedIteratorRawGenerics() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = arrayList.iterator();
        Assertions.assertTrue((boolean)(IteratorUtils.chainedIterator(iterator) instanceof Iterator), (String)"create instance fail");
        ArrayList coll = new ArrayList();
        Assertions.assertTrue((boolean)(IteratorUtils.chainedIterator(coll) instanceof Iterator), (String)"create instance fail");
    }

    @Test
    public void testCollatedIterator() {
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.collatedIterator(null, this.collectionOdd.iterator(), null));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.collatedIterator(null, null, this.collectionEven.iterator()));
        Iterator it = IteratorUtils.collatedIterator(null, this.collectionOdd.iterator(), this.collectionEven.iterator());
        List result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals((int)12, (int)result.size());
        ArrayList<Integer> combinedList = new ArrayList<Integer>(this.collectionOdd);
        combinedList.addAll(this.collectionEven);
        Collections.sort(combinedList);
        Assertions.assertEquals(combinedList, (Object)result);
        it = IteratorUtils.collatedIterator(null, this.collectionOdd.iterator(), this.emptyCollection.iterator());
        result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals(this.collectionOdd, (Object)result);
        Comparator reverseComparator = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Collections.reverse(this.collectionOdd);
        Collections.reverse(this.collectionEven);
        Collections.reverse(combinedList);
        it = IteratorUtils.collatedIterator((Comparator)reverseComparator, this.collectionOdd.iterator(), this.collectionEven.iterator());
        result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals(combinedList, (Object)result);
    }

    @Test
    public void testCollatedIteratorCollectionNull() {
        ArrayList<Iterator<Integer>> coll = new ArrayList<Iterator<Integer>>();
        coll.add(this.collectionOdd.iterator());
        Iterator it = IteratorUtils.collatedIterator(null, coll);
        List result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals((int)6, (int)result.size());
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.collatedIterator(null, (Collection)null));
    }

    @Test
    public void testCollatedIteratorNull() {
        ArrayList arrayList = new ArrayList();
        Iterator it = IteratorUtils.collatedIterator(null, (Iterator[])new Iterator[]{this.collectionOdd.iterator(), this.collectionOdd.iterator(), this.collectionOdd.iterator()});
        List result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals((int)18, (int)result.size());
        it = IteratorUtils.collatedIterator(null, (Iterator[])new Iterator[]{this.collectionOdd.iterator()});
        result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals(this.collectionOdd, (Object)result);
        Comparator reverseComparator = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Collections.reverse(this.collectionOdd);
        it = IteratorUtils.collatedIterator((Comparator)reverseComparator, (Iterator[])new Iterator[]{this.collectionOdd.iterator()});
        result = IteratorUtils.toList((Iterator)it);
        Assertions.assertEquals(this.collectionOdd, (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.collatedIterator(null, (Iterator[])new Iterator[]{arrayList.iterator(), arrayList.listIterator(), null}));
    }

    @Test
    public void testEmptyIterator() {
        Assertions.assertSame((Object)EmptyIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ITERATOR);
        Assertions.assertSame((Object)EmptyIterator.RESETTABLE_INSTANCE, (Object)IteratorUtils.EMPTY_ITERATOR);
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ITERATOR instanceof Iterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ITERATOR instanceof ResettableIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_ITERATOR instanceof OrderedIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_ITERATOR instanceof ListIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_ITERATOR instanceof MapIterator));
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_ITERATOR.hasNext());
        IteratorUtils.EMPTY_ITERATOR.reset();
        Assertions.assertSame((Object)IteratorUtils.EMPTY_ITERATOR, (Object)IteratorUtils.EMPTY_ITERATOR);
        Assertions.assertSame((Object)IteratorUtils.EMPTY_ITERATOR, (Object)IteratorUtils.emptyIterator());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_ITERATOR.next());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_ITERATOR.remove());
    }

    @Test
    public void testEmptyListIterator() {
        Assertions.assertSame((Object)EmptyListIterator.INSTANCE, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        Assertions.assertSame((Object)EmptyListIterator.RESETTABLE_INSTANCE, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof Iterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ListIterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ResettableIterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof ResettableListIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_LIST_ITERATOR instanceof MapIterator));
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_LIST_ITERATOR.hasNext());
        Assertions.assertEquals((int)0, (int)IteratorUtils.EMPTY_LIST_ITERATOR.nextIndex());
        Assertions.assertEquals((int)-1, (int)IteratorUtils.EMPTY_LIST_ITERATOR.previousIndex());
        IteratorUtils.EMPTY_LIST_ITERATOR.reset();
        Assertions.assertSame((Object)IteratorUtils.EMPTY_LIST_ITERATOR, (Object)IteratorUtils.EMPTY_LIST_ITERATOR);
        Assertions.assertSame((Object)IteratorUtils.EMPTY_LIST_ITERATOR, (Object)IteratorUtils.emptyListIterator());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_LIST_ITERATOR.next());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_LIST_ITERATOR.previous());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_LIST_ITERATOR.remove());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.emptyListIterator().set(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> IteratorUtils.emptyListIterator().add(null));
    }

    @Test
    public void testEmptyMapIterator() {
        Assertions.assertSame((Object)EmptyMapIterator.INSTANCE, (Object)IteratorUtils.EMPTY_MAP_ITERATOR);
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof Iterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof MapIterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof ResettableIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof ListIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof OrderedIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_MAP_ITERATOR instanceof OrderedMapIterator));
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_MAP_ITERATOR.hasNext());
        ((ResettableIterator)IteratorUtils.EMPTY_MAP_ITERATOR).reset();
        Assertions.assertSame((Object)IteratorUtils.EMPTY_MAP_ITERATOR, (Object)IteratorUtils.EMPTY_MAP_ITERATOR);
        Assertions.assertSame((Object)IteratorUtils.EMPTY_MAP_ITERATOR, (Object)IteratorUtils.emptyMapIterator());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_MAP_ITERATOR.next());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_MAP_ITERATOR.remove());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_MAP_ITERATOR.getKey());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_MAP_ITERATOR.getValue());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_MAP_ITERATOR.setValue(null));
    }

    @Test
    public void testEmptyOrderedIterator() {
        Assertions.assertSame((Object)EmptyOrderedIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR);
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof Iterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof OrderedIterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof ResettableIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof ListIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_ORDERED_ITERATOR instanceof MapIterator));
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_ORDERED_ITERATOR.hasNext());
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_ORDERED_ITERATOR.hasPrevious());
        ((ResettableIterator)IteratorUtils.EMPTY_ORDERED_ITERATOR).reset();
        Assertions.assertSame((Object)IteratorUtils.EMPTY_ORDERED_ITERATOR, (Object)IteratorUtils.EMPTY_ORDERED_ITERATOR);
        Assertions.assertSame((Object)IteratorUtils.EMPTY_ORDERED_ITERATOR, (Object)IteratorUtils.emptyOrderedIterator());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_ORDERED_ITERATOR.next());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_ORDERED_ITERATOR.previous());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_ORDERED_ITERATOR.remove());
    }

    @Test
    public void testEmptyOrderedMapIterator() {
        Assertions.assertSame((Object)EmptyOrderedMapIterator.INSTANCE, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR);
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof Iterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof MapIterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof OrderedMapIterator));
        Assertions.assertTrue((boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof ResettableIterator));
        Assertions.assertFalse((boolean)(IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR instanceof ListIterator));
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.hasNext());
        Assertions.assertFalse((boolean)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.hasPrevious());
        ((ResettableIterator)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR).reset();
        Assertions.assertSame((Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR, (Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR);
        Assertions.assertSame((Object)IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR, (Object)IteratorUtils.emptyOrderedMapIterator());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.next());
        Assertions.assertThrows(NoSuchElementException.class, () -> IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.previous());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.remove());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.getKey());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.getValue());
        Assertions.assertThrows(IllegalStateException.class, () -> IteratorUtils.EMPTY_ORDERED_MAP_ITERATOR.setValue(null));
    }

    @Test
    public void testFilteredIterator() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = arrayList.iterator();
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.filteredIterator((Iterator)iterator, null));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.filteredIterator(null, null));
    }

    @Test
    public void testFilteredListIterator() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("test");
        Predicate predicate = TruePredicate.INSTANCE;
        Assertions.assertTrue((boolean)(IteratorUtils.filteredListIterator(arrayList.listIterator(), (Predicate)predicate) instanceof ListIterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.filteredListIterator(null, (Predicate)predicate));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.filteredListIterator(arrayList.listIterator(), null));
    }

    @Test
    public void testFind() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        Integer test = (Integer)IteratorUtils.find(this.iterableA.iterator(), (Predicate)testPredicate);
        Assertions.assertEquals((int)4, (int)test);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        test = (Integer)IteratorUtils.find(this.iterableA.iterator(), (Predicate)testPredicate);
        Assertions.assertNull((Object)test);
        Assertions.assertNull((Object)IteratorUtils.find(null, (Predicate)testPredicate));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.find(this.iterableA.iterator(), null));
    }

    @Test
    public void testFirstFromIterator() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)IteratorUtils.first(iterator)));
    }

    @Test
    public void testForEach() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        IteratorUtils.forEach(col.iterator(), (Closure)testClosure);
        Assertions.assertTrue((listA.isEmpty() && listB.isEmpty() ? 1 : 0) != 0);
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.forEach(col.iterator(), null));
        IteratorUtils.forEach(null, (Closure)testClosure);
        col.add(null);
        IteratorUtils.forEach(col.iterator(), (Closure)testClosure);
    }

    @Test
    public void testForEachButLast() {
        ArrayList<Integer> listA = new ArrayList<Integer>();
        listA.add(1);
        ArrayList<Integer> listB = new ArrayList<Integer>();
        listB.add(2);
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<ArrayList<Integer>> col = new ArrayList<ArrayList<Integer>>();
        col.add(listA);
        col.add(listB);
        List last = (List)IteratorUtils.forEachButLast(col.iterator(), (Closure)testClosure);
        Assertions.assertTrue((listA.isEmpty() && !listB.isEmpty() ? 1 : 0) != 0);
        Assertions.assertSame(listB, (Object)last);
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.forEachButLast(col.iterator(), null));
        IteratorUtils.forEachButLast(null, (Closure)testClosure);
        col.add(null);
        col.add(null);
        last = (List)IteratorUtils.forEachButLast(col.iterator(), (Closure)testClosure);
        Assertions.assertNull((Object)last);
    }

    @Test
    public void testGetAtIndexFromIterator() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)IteratorUtils.get(iterator, (int)0)));
        iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)2, (int)((Integer)IteratorUtils.get(iterator, (int)1)));
        Iterator<Integer> finalIterator = iterator;
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> IteratorUtils.get((Iterator)finalIterator, (int)10));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGetAtIndexFromIteratorDefault() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)IteratorUtils.get(iterator, (int)0, i -> 0)));
        iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)2, (int)((Integer)IteratorUtils.get(iterator, (int)1, i -> 0)));
        Assertions.assertEquals((int)111, (int)((Integer)IteratorUtils.get(iterator, (int)10, i -> 111)));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGetIterator() {
        Object[] objArray = new Object[]{"a", "b", "c"};
        HashMap inMap = new HashMap();
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator(null) instanceof EmptyIterator), (String)"returns empty iterator when null passed");
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator(this.iterableA.iterator()) instanceof Iterator), (String)"returns Iterator when Iterator directly ");
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator(this.iterableA) instanceof Iterator), (String)"returns Iterator when iterable passed");
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator((Object)objArray) instanceof ObjectArrayIterator), (String)"returns ObjectArrayIterator when Object array passed");
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator(inMap) instanceof Iterator), (String)"returns Iterator when Map passed");
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator((Object)nodeList) instanceof NodeListIterator), (String)"returns NodeListIterator when nodeList passed");
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator(new Vector().elements()) instanceof EnumerationIterator), (String)"returns EnumerationIterator when Enumeration passed");
        Node node1 = (Node)EasyMock.createMock(Node.class);
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator((Object)node1) instanceof NodeListIterator), (String)"returns NodeListIterator when nodeList passed");
        Dictionary dic = (Dictionary)EasyMock.createMock(Dictionary.class);
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator((Object)dic) instanceof EnumerationIterator), (String)"returns EnumerationIterator when Dictionary passed");
        int[] arr = new int[8];
        Assertions.assertTrue((boolean)(IteratorUtils.getIterator((Object)arr) instanceof ArrayIterator), (String)"returns ArrayIterator when array passed");
    }

    @Test
    public void testIndexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        int index = IteratorUtils.indexOf(this.iterableA.iterator(), (Predicate)testPredicate);
        Assertions.assertEquals((int)6, (int)index);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        index = IteratorUtils.indexOf(this.iterableA.iterator(), (Predicate)testPredicate);
        Assertions.assertEquals((int)-1, (int)index);
        Assertions.assertEquals((int)-1, (int)IteratorUtils.indexOf(null, (Predicate)testPredicate));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.indexOf(this.iterableA.iterator(), null));
    }

    @Test
    public void testLoopingIterator() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("test");
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("test");
        Iterator iterator = arrayList.iterator();
        Assertions.assertTrue((boolean)(IteratorUtils.loopingIterator(coll) instanceof ResettableIterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.loopingIterator(null));
    }

    @Test
    public void testLoopingListIterator() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("test");
        Iterator iterator = arrayList.iterator();
        Assertions.assertTrue((boolean)(IteratorUtils.loopingListIterator(arrayList) instanceof ResettableIterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.loopingListIterator(null));
    }

    @Test
    public void testNodeIterator() {
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        Node parentNode = (Node)EasyMock.createMock(Node.class);
        EasyMock.expect((Object)parentNode.getChildNodes()).andStubReturn((Object)nodeList);
        EasyMock.replay((Object[])new Object[]{parentNode});
        NodeListIterator iterator = IteratorUtils.nodeListIterator((Node)parentNode);
        int expectedNodeIndex = 0;
        for (Node actual : IteratorUtils.asIterable((Iterator)iterator)) {
            Assertions.assertEquals((Object)nodes[expectedNodeIndex], (Object)actual);
            ++expectedNodeIndex;
        }
        Assertions.assertTrue((expectedNodeIndex > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)IteratorUtils.asIterable((Iterator)iterator).iterator().hasNext(), (String)"should not be able to iterate twice");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.nodeListIterator((Node)null));
    }

    @Test
    public void testNodeListIterator() {
        Node[] nodes = this.createNodes();
        NodeList nodeList = this.createNodeList(nodes);
        NodeListIterator iterator = IteratorUtils.nodeListIterator((NodeList)nodeList);
        int expectedNodeIndex = 0;
        for (Node actual : IteratorUtils.asIterable((Iterator)iterator)) {
            Assertions.assertEquals((Object)nodes[expectedNodeIndex], (Object)actual);
            ++expectedNodeIndex;
        }
        Assertions.assertTrue((expectedNodeIndex > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)IteratorUtils.asIterable((Iterator)iterator).iterator().hasNext(), (String)"should not be able to iterate twice");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.nodeListIterator((NodeList)null));
    }

    @Test
    public void testObjectGraphIterator() {
        Assertions.assertTrue((boolean)(IteratorUtils.objectGraphIterator(null, null) instanceof Iterator), (String)"create instance fail");
    }

    @Test
    public void testPeekingIterator() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = arrayList.iterator();
        Assertions.assertTrue((boolean)(IteratorUtils.peekingIterator(iterator) instanceof Iterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.peekingIterator(null));
    }

    @Test
    public void testPushBackIterator() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = arrayList.iterator();
        Assertions.assertTrue((boolean)(IteratorUtils.pushbackIterator(iterator) instanceof Iterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.pushbackIterator(null));
    }

    @Test
    public void testSingletonIterator() {
        Assertions.assertTrue((boolean)(IteratorUtils.singletonIterator((Object)new Object()) instanceof ResettableIterator), (String)"create instance fail");
    }

    @Test
    public void testSingletonListIterator() {
        Assertions.assertTrue((boolean)(IteratorUtils.singletonListIterator((Object)new Object()) instanceof Iterator), (String)"create instance fail");
    }

    @Test
    public void testToArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(1);
        list.add("Two");
        list.add(null);
        Object[] result = IteratorUtils.toArray(list.iterator());
        Assertions.assertEquals(list, Arrays.asList(result));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.toArray(null));
    }

    @Test
    public void testToArray2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        list.add(null);
        String[] result = (String[])IteratorUtils.toArray(list.iterator(), String.class);
        Assertions.assertEquals(list, Arrays.asList(result));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.toArray(list.iterator(), null));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.toArray(null, String.class));
    }

    @Test
    public void testToList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(1);
        list.add("Two");
        list.add(null);
        List result = IteratorUtils.toList(list.iterator());
        Assertions.assertEquals(list, (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.toList(null, (int)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.toList(list.iterator(), (int)-1));
    }

    @Test
    public void testToSet() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(1);
        set.add("Two");
        set.add(null);
        Set result = IteratorUtils.toSet(set.iterator());
        Assertions.assertEquals(set, (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.toSet(null, (int)10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtils.toSet(set.iterator(), (int)-1));
    }

    @Test
    public void testToListIterator() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator iterator = list.iterator();
        ListIterator liItr = IteratorUtils.toListIterator(iterator);
        int expected = 0;
        while (liItr.hasNext()) {
            Assertions.assertEquals((int)expected, (int)((Integer)liItr.next()));
            ++expected;
        }
    }

    @Test
    public void testToListIteratorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.toListIterator(null));
    }

    @Test
    public void testTransformedIterator() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = arrayList.iterator();
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.transformedIterator((Iterator)iterator, null));
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.transformedIterator(null, null));
    }

    @Test
    public void testUnmodifiableIteratorImmutability() {
        Iterator<String> iterator = this.getImmutableIterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.remove());
        iterator.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.remove());
    }

    @Test
    public void testUnmodifiableIteratorIteration() {
        Iterator<String> iterator = this.getImmutableIterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"d", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testUnmodifiableListIteratorImmutability() {
        ListIterator<String> listIterator = this.getImmutableListIterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> listIterator.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> listIterator.set("a"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> listIterator.add("a"));
        listIterator.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> listIterator.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> listIterator.set("a"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> listIterator.add("a"));
    }

    @Test
    public void testUnmodifiableListIteratorIteration() {
        ListIterator<String> listIterator = this.getImmutableListIterator();
        Assertions.assertFalse((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)listIterator.next());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)listIterator.next());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)listIterator.next());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"d", (Object)listIterator.next());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertFalse((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"d", (Object)listIterator.previous());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)listIterator.previous());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)listIterator.previous());
        Assertions.assertTrue((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)listIterator.previous());
        Assertions.assertFalse((boolean)listIterator.hasPrevious());
        Assertions.assertTrue((boolean)listIterator.hasNext());
    }

    @Test
    public void testUnmodifiableMapIterator() {
        LinkedHashSet set = new LinkedHashSet();
        EntrySetToMapIteratorAdapter iterator = new EntrySetToMapIteratorAdapter(set);
        Assertions.assertTrue((boolean)(IteratorUtils.unmodifiableMapIterator((MapIterator)iterator) instanceof MapIterator), (String)"create instance fail");
        Assertions.assertThrows(NullPointerException.class, () -> IteratorUtils.unmodifiableMapIterator(null));
    }

    @Test
    public void testZippingIterator() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = arrayList.iterator();
        Assertions.assertTrue((boolean)(IteratorUtils.zippingIterator(iterator, iterator, iterator) instanceof ZippingIterator), (String)"create instance fail");
        Assertions.assertTrue((boolean)(IteratorUtils.zippingIterator(iterator, iterator) instanceof ZippingIterator), (String)"create instance fail");
    }
}

