/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiMapUtilsTest {
    @Test
    public void testEmptyIfNull() {
        Assertions.assertTrue((boolean)MultiMapUtils.emptyIfNull(null).isEmpty());
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        map.put((Object)"item", (Object)"value");
        Assertions.assertFalse((boolean)MultiMapUtils.emptyIfNull((MultiValuedMap)map).isEmpty());
    }

    @Test
    public void testEmptyUnmodifiableMultiValuedMap() {
        MultiValuedMap map = MultiMapUtils.EMPTY_MULTI_VALUED_MAP;
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put((Object)"key", (Object)"value"));
    }

    @Test
    public void testGetCollection() {
        Assertions.assertNull((Object)MultiMapUtils.getCollection(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
        }
        Collection col = MultiMapUtils.getCollection((MultiValuedMap)map, (Object)"key1");
        Assertions.assertEquals(Arrays.asList(values), (Object)col);
    }

    @Test
    public void testGetValuesAsBag() {
        Assertions.assertNull((Object)MultiMapUtils.getValuesAsBag(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
            map.put((Object)"key1", (Object)val);
        }
        Bag bag = MultiMapUtils.getValuesAsBag((MultiValuedMap)map, (Object)"key1");
        Assertions.assertEquals((int)6, (int)bag.size());
        for (String val : values) {
            Assertions.assertTrue((boolean)bag.contains((Object)val));
            Assertions.assertEquals((int)2, (int)bag.getCount((Object)val));
        }
    }

    @Test
    public void testGetValuesAsList() {
        Assertions.assertNull((Object)MultiMapUtils.getValuesAsList(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
        }
        List list = MultiMapUtils.getValuesAsList((MultiValuedMap)map, (Object)"key1");
        Assertions.assertEquals(Arrays.asList(values), (Object)list);
    }

    @Test
    public void testGetValuesAsSet() {
        Assertions.assertNull((Object)MultiMapUtils.getValuesAsList(null, (Object)"key1"));
        String[] values = new String[]{"v1", "v2", "v3"};
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (String val : values) {
            map.put((Object)"key1", (Object)val);
            map.put((Object)"key1", (Object)val);
        }
        Set set = MultiMapUtils.getValuesAsSet((MultiValuedMap)map, (Object)"key1");
        Assertions.assertEquals(new HashSet<String>(Arrays.asList(values)), (Object)set);
    }

    @Test
    public void testIsEmptyWithEmptyMap() {
        Assertions.assertTrue((boolean)MultiMapUtils.isEmpty((MultiValuedMap)new ArrayListValuedHashMap()));
    }

    @Test
    public void testIsEmptyWithNonEmptyMap() {
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        map.put((Object)"item", (Object)"value");
        Assertions.assertFalse((boolean)MultiMapUtils.isEmpty((MultiValuedMap)map));
    }

    @Test
    public void testIsEmptyWithNull() {
        Assertions.assertTrue((boolean)MultiMapUtils.isEmpty(null));
    }

    @Test
    public void testTypeSafeEmptyMultiValuedMap() {
        MultiValuedMap map = MultiMapUtils.emptyMultiValuedMap();
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put((Object)"key", (Object)"value"));
    }
}

