/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.collections4.bloomfilter.AbstractIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.CellExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCellExtractorTest
extends AbstractIndexExtractorTest {
    private static final CellExtractor.CellPredicate TRUE_CONSUMER = (i, j) -> true;
    private static final CellExtractor.CellPredicate FALSE_CONSUMER = (i, j) -> false;

    protected abstract CellExtractor createEmptyExtractor();

    protected abstract CellExtractor createExtractor();

    @Override
    protected final int getAsIndexArrayBehaviour() {
        return 3;
    }

    protected abstract int[] getExpectedValues();

    @Test
    public final void testBehaviourForEachCell() {
        AbstractIndexExtractorTest.IntList list = new AbstractIndexExtractorTest.IntList();
        this.createExtractor().processCells((i, j) -> list.add(i));
        int[] actual = list.toArray();
        int[] expected = Arrays.stream(actual).sorted().toArray();
        Assertions.assertArrayEquals((int[])expected, (int[])actual);
        long count = Arrays.stream(actual).distinct().count();
        Assertions.assertEquals((long)count, (long)actual.length);
    }

    @Test
    public final void testEmptyCellExtractor() {
        CellExtractor empty = this.createEmptyExtractor();
        int[] ary = empty.asIndexArray();
        Assertions.assertEquals((int)0, (int)ary.length);
        Assertions.assertTrue((boolean)empty.processCells((i, j) -> {
            Assertions.fail((String)"forEachCell consumer should not be called");
            return false;
        }));
    }

    @Test
    public void testForEachCellEarlyExit() {
        int[] passes = new int[1];
        Assertions.assertTrue((boolean)this.createEmptyExtractor().processCells((i, j) -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)0, (int)passes[0]);
        Assertions.assertFalse((boolean)this.createExtractor().processCells((i, j) -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
    }

    @Test
    public final void testForEachCellPredicates() {
        CellExtractor populated = this.createExtractor();
        CellExtractor empty = this.createEmptyExtractor();
        Assertions.assertFalse((boolean)populated.processCells(FALSE_CONSUMER), (String)"non-empty should be false");
        Assertions.assertTrue((boolean)empty.processCells(FALSE_CONSUMER), (String)"empty should be true");
        Assertions.assertTrue((boolean)populated.processCells(TRUE_CONSUMER), (String)"non-empty should be true");
        Assertions.assertTrue((boolean)empty.processCells(TRUE_CONSUMER), (String)"empty should be true");
    }

    @Test
    public void testForEachCellValues() {
        int[] expectedIdx = this.getExpectedIndices();
        int[] expectedValue = this.getExpectedValues();
        Assertions.assertEquals((int)expectedIdx.length, (int)expectedValue.length, (String)"expected index length and value length do not match");
        int[] idx = new int[]{0};
        this.createExtractor().processCells((i, j) -> {
            Assertions.assertEquals((int)expectedIdx[idx[0]], (int)i, (String)("bad index at " + idx[0]));
            Assertions.assertEquals((int)expectedValue[idx[0]], (int)j, (String)("bad value at " + idx[0]));
            idx[0] = idx[0] + 1;
            return true;
        });
    }

    @Test
    public final void testIndexConsistency() {
        CellExtractor extractor = this.createExtractor();
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        extractor.processIndices(i -> {
            bs1.set(i);
            return true;
        });
        extractor.processCells((i, j) -> {
            bs2.set(i);
            return true;
        });
        Assertions.assertEquals((Object)bs1, (Object)bs2);
    }
}

