/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ZippingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZippingIteratorTest
extends AbstractIteratorTest<Integer> {
    private ArrayList<Integer> evens;
    private ArrayList<Integer> odds;
    private ArrayList<Integer> fib;

    @Override
    public ZippingIterator<Integer> makeEmptyIterator() {
        return new ZippingIterator(new Iterator[]{IteratorUtils.emptyIterator()});
    }

    @Override
    public ZippingIterator<Integer> makeObject() {
        return new ZippingIterator(this.evens.iterator(), this.odds.iterator(), this.fib.iterator());
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.evens = new ArrayList();
        this.odds = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            if (0 == i % 2) {
                this.evens.add(i);
                continue;
            }
            this.odds.add(i);
        }
        this.fib = new ArrayList();
        this.fib.add(1);
        this.fib.add(1);
        this.fib.add(2);
        this.fib.add(3);
        this.fib.add(5);
        this.fib.add(8);
        this.fib.add(13);
        this.fib.add(21);
    }

    @Test
    public void testIterateEven() {
        ZippingIterator iter = new ZippingIterator(new Iterator[]{this.evens.iterator()});
        for (Integer even : this.evens) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)even, (Integer)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateEvenEven() {
        ZippingIterator iter = new ZippingIterator(this.evens.iterator(), this.evens.iterator());
        for (Integer even : this.evens) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)even, (Integer)((Integer)iter.next()));
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)even, (Integer)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateEvenOdd() {
        ZippingIterator iter = new ZippingIterator(this.evens.iterator(), this.odds.iterator());
        for (int i = 0; i < 20; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Integer)i, (Integer)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateFibEvenOdd() {
        ZippingIterator iter = new ZippingIterator(this.fib.iterator(), this.evens.iterator(), this.odds.iterator());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)7, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)8, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)8, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)10, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)11, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)13, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)13, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)21, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)14, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)16, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)17, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)18, (Integer)((Integer)iter.next()));
        Assertions.assertEquals((Integer)19, (Integer)((Integer)iter.next()));
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterateOddEven() {
        ZippingIterator iter = new ZippingIterator(this.odds.iterator(), this.evens.iterator());
        int j = 0;
        for (int i = 0; i < 20; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            int val = (Integer)iter.next();
            if (i % 2 == 0) {
                Assertions.assertEquals((int)this.odds.get(j), (int)val);
                continue;
            }
            Assertions.assertEquals((int)this.evens.get(j), (int)val);
            ++j;
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveFromDouble() {
        ZippingIterator iter = new ZippingIterator(this.evens.iterator(), this.odds.iterator());
        int expectedSize = this.evens.size() + this.odds.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0 && val % 3 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        Assertions.assertEquals((int)expectedSize, (int)(this.evens.size() + this.odds.size()));
    }

    @Test
    public void testRemoveFromSingle() {
        ZippingIterator iter = new ZippingIterator(new Iterator[]{this.evens.iterator()});
        int expectedSize = this.evens.size();
        while (iter.hasNext()) {
            Object o = iter.next();
            Integer val = (Integer)o;
            if (val % 4 != 0) continue;
            --expectedSize;
            iter.remove();
        }
        Assertions.assertEquals((int)expectedSize, (int)this.evens.size());
    }
}

