/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.PredicatedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    protected static final Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected static final Predicate<Object> testPredicate = String.class::isInstance;

    protected IterableMap<K, V> decorateMap(Map<K, V> map, Predicate<? super K> keyPredicate, Predicate<? super V> valuePredicate) {
        return PredicatedMap.predicatedMap(map, keyPredicate, valuePredicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return this.decorateMap(new HashMap(), truePredicate, truePredicate);
    }

    public IterableMap<K, V> makeTestMap() {
        return this.decorateMap(new HashMap(), testPredicate, testPredicate);
    }

    @Test
    public void testEntrySet() {
        IterableMap<String, String> map = this.makeTestMap();
        Assertions.assertNotNull(map.entrySet(), (String)"returned entryset should not be null");
        map = this.decorateMap(new HashMap(), null, null);
        map.put("oneKey", "oneValue");
        Assertions.assertEquals((int)1, (int)map.entrySet().size(), (String)"returned entryset should contain one entry");
        map = this.decorateMap((Map<K, V>)map, null, null);
    }

    @Test
    public void testPut() {
        Map.Entry entry;
        IterableMap<String, String> map = this.makeTestMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put("Hi", (String)3), (String)"Illegal value should raise IllegalArgument");
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put((String)3, "Hi"), (String)"Illegal key should raise IllegalArgument");
        Assertions.assertFalse((boolean)map.containsKey(3));
        Assertions.assertFalse((boolean)map.containsValue(3));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("A", "a");
        map2.put("B", "b");
        map2.put("C", "c");
        map2.put("c", 3);
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.putAll(map2), (String)"Illegal value should raise IllegalArgument");
        map.put("E", "e");
        Iterator iterator = map.entrySet().iterator();
        Map.Entry finalEntry = entry = iterator.next();
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalEntry.setValue((String)3), (String)"Illegal value should raise IllegalArgument");
        map.put("F", "f");
        iterator = map.entrySet().iterator();
        entry = iterator.next();
        entry.setValue("x");
    }
}

