/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircularFifoQueueTest<E>
extends AbstractQueueTest<E> {
    @Override
    public CircularFifoQueue<E> getCollection() {
        return (CircularFifoQueue)super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isFailFastSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        Collection c = this.makeConfirmedCollection();
        c.addAll(Arrays.asList(this.getFullElements()));
        return c;
    }

    @Override
    public Queue<E> makeObject() {
        return new CircularFifoQueue(100);
    }

    @Test
    public void testAddNull() {
        CircularFifoQueue b = new CircularFifoQueue(2);
        Assertions.assertThrows(NullPointerException.class, () -> b.add(null));
    }

    @Test
    public void testCircularFifoQueueCircular() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        CircularFifoQueue queue = new CircularFifoQueue(list);
        Assertions.assertTrue((boolean)queue.contains("A"));
        Assertions.assertTrue((boolean)queue.contains("B"));
        Assertions.assertTrue((boolean)queue.contains("C"));
        queue.add("D");
        Assertions.assertFalse((boolean)queue.contains("A"));
        Assertions.assertTrue((boolean)queue.contains("B"));
        Assertions.assertTrue((boolean)queue.contains("C"));
        Assertions.assertTrue((boolean)queue.contains("D"));
        Assertions.assertEquals((Object)"B", queue.peek());
        Assertions.assertEquals((Object)"B", queue.remove());
        Assertions.assertEquals((Object)"C", queue.remove());
        Assertions.assertEquals((Object)"D", queue.remove());
    }

    @Test
    public void testCircularFifoQueueRemove() {
        this.resetFull();
        int size = this.getConfirmed().size();
        for (int i = 0; i < size; ++i) {
            Object o1 = this.getCollection().remove();
            Object o2 = ((List)this.getConfirmed()).remove(0);
            Assertions.assertEquals((Object)o1, o2, (String)"Removed objects should be equal");
            this.verify();
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> this.getCollection().remove(), (String)"Empty queue should raise Underflow.");
    }

    @Test
    public void testConstructorException1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CircularFifoQueue(0));
    }

    @Test
    public void testConstructorException2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CircularFifoQueue(-20));
    }

    @Test
    public void testConstructorException3() {
        Assertions.assertThrows(NullPointerException.class, () -> new CircularFifoQueue(null));
    }

    @Test
    public void testDefaultSizeAndGetError1() {
        CircularFifoQueue fifo = new CircularFifoQueue();
        Assertions.assertEquals((int)32, (int)fifo.maxSize());
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        Assertions.assertEquals((int)5, (int)fifo.size());
        Assertions.assertThrows(NoSuchElementException.class, () -> fifo.get(5));
    }

    @Test
    public void testDefaultSizeAndGetError2() {
        CircularFifoQueue fifo = new CircularFifoQueue();
        Assertions.assertEquals((int)32, (int)fifo.maxSize());
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        Assertions.assertEquals((int)5, (int)fifo.size());
        Assertions.assertThrows(NoSuchElementException.class, () -> fifo.get(-2));
    }

    @Test
    public void testGetIndex() {
        int i;
        this.resetFull();
        CircularFifoQueue<E> queue = this.getCollection();
        List confirmed = (List)this.getConfirmed();
        for (i = 0; i < confirmed.size(); ++i) {
            Assertions.assertEquals(confirmed.get(i), (Object)queue.get(i));
        }
        queue.remove();
        queue.remove();
        for (i = 0; i < queue.size(); ++i) {
            Assertions.assertEquals(confirmed.get(i + 2), (Object)queue.get(i));
        }
    }

    @Test
    public void testRemoveError1() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)fifo.toString());
        fifo.remove((Object)"3");
        Assertions.assertEquals((Object)"[1, 2, 4, 5]", (Object)fifo.toString());
        fifo.remove((Object)"4");
        Assertions.assertEquals((Object)"[1, 2, 5]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError2() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        Assertions.assertEquals((int)5, (int)fifo.size());
        Assertions.assertEquals((Object)"[2, 3, 4, 5, 6]", (Object)fifo.toString());
        fifo.remove((Object)"3");
        Assertions.assertEquals((Object)"[2, 4, 5, 6]", (Object)fifo.toString());
        fifo.remove((Object)"4");
        Assertions.assertEquals((Object)"[2, 5, 6]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError3() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)fifo.toString());
        fifo.remove((Object)"3");
        Assertions.assertEquals((Object)"[1, 2, 4, 5]", (Object)fifo.toString());
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        Assertions.assertEquals((Object)"[2, 4, 5, 6, 7]", (Object)fifo.toString());
        fifo.remove((Object)"4");
        Assertions.assertEquals((Object)"[2, 5, 6, 7]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError4() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        Assertions.assertEquals((Object)"[3, 4, 5, 6, 7]", (Object)fifo.toString());
        fifo.remove((Object)"4");
        Assertions.assertEquals((Object)"[3, 5, 6, 7]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError5() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        Assertions.assertEquals((Object)"[3, 4, 5, 6, 7]", (Object)fifo.toString());
        fifo.remove((Object)"5");
        Assertions.assertEquals((Object)"[3, 4, 6, 7]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError6() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        Assertions.assertEquals((Object)"[3, 4, 5, 6, 7]", (Object)fifo.toString());
        fifo.remove((Object)"6");
        Assertions.assertEquals((Object)"[3, 4, 5, 7]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError7() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        Assertions.assertEquals((Object)"[3, 4, 5, 6, 7]", (Object)fifo.toString());
        fifo.remove((Object)"7");
        Assertions.assertEquals((Object)"[3, 4, 5, 6]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError8() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        fifo.add((Object)"8");
        Assertions.assertEquals((Object)"[4, 5, 6, 7, 8]", (Object)fifo.toString());
        fifo.remove((Object)"7");
        Assertions.assertEquals((Object)"[4, 5, 6, 8]", (Object)fifo.toString());
    }

    @Test
    public void testRemoveError9() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        fifo.add((Object)"8");
        Assertions.assertEquals((Object)"[4, 5, 6, 7, 8]", (Object)fifo.toString());
        fifo.remove((Object)"8");
        Assertions.assertEquals((Object)"[4, 5, 6, 7]", (Object)fifo.toString());
    }

    @Test
    public void testRepeatedSerialization() throws Exception {
        CircularFifoQueue b = new CircularFifoQueue(2);
        b.add((Object)"a");
        Assertions.assertEquals((int)1, (int)b.size());
        Assertions.assertTrue((boolean)b.contains((Object)"a"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new ObjectOutputStream(bos).writeObject(b);
        CircularFifoQueue b2 = (CircularFifoQueue)new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();
        Assertions.assertEquals((int)1, (int)b2.size());
        Assertions.assertTrue((boolean)b2.contains((Object)"a"));
        b2.add((Object)"b");
        Assertions.assertEquals((int)2, (int)b2.size());
        Assertions.assertTrue((boolean)b2.contains((Object)"a"));
        Assertions.assertTrue((boolean)b2.contains((Object)"b"));
        bos = new ByteArrayOutputStream();
        new ObjectOutputStream(bos).writeObject(b2);
        CircularFifoQueue b3 = (CircularFifoQueue)new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();
        Assertions.assertEquals((int)2, (int)b3.size());
        Assertions.assertTrue((boolean)b3.contains((Object)"a"));
        Assertions.assertTrue((boolean)b3.contains((Object)"b"));
        b3.add((Object)"c");
        Assertions.assertEquals((int)2, (int)b3.size());
        Assertions.assertTrue((boolean)b3.contains((Object)"b"));
        Assertions.assertTrue((boolean)b3.contains((Object)"c"));
    }

    @Override
    public void verify() {
        super.verify();
        Iterator iterator1 = this.getCollection().iterator();
        for (Object e : this.getConfirmed()) {
            Assertions.assertTrue((boolean)iterator1.hasNext());
            Object o1 = iterator1.next();
            Object o2 = e;
            Assertions.assertEquals(o1, o2);
        }
    }
}

