/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.ExpressionImpl;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.JexlThreadedArithmetic;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.ObjectContext;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.apache.commons.jexl2.internal.Introspector;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.jexl2.introspection.UberspectImpl;
import org.apache.commons.jexl2.parser.JexlNode;

public class IssuesTest
extends JexlTestCase {
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    public void test24() throws Exception {
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "{a = 10L; b = 10l; c = 42.0D; d = 42.0d; e=56.3F; f=56.3f; g=63.5; h=0x10; i=010; j=0x10L; k=010l}";
        Script expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        IssuesTest.assertEquals((Object)10L, vars.get("a"));
        IssuesTest.assertEquals((Object)10L, vars.get("b"));
        IssuesTest.assertEquals((Object)42.0, vars.get("c"));
        IssuesTest.assertEquals((Object)42.0, vars.get("d"));
        IssuesTest.assertEquals((Object)Float.valueOf(56.3f), vars.get("e"));
        IssuesTest.assertEquals((Object)Float.valueOf(56.3f), vars.get("f"));
        IssuesTest.assertEquals((Object)Float.valueOf(63.5f), vars.get("g"));
        IssuesTest.assertEquals((Object)16, vars.get("h"));
        IssuesTest.assertEquals((Object)8, vars.get("i"));
        IssuesTest.assertEquals((Object)16L, vars.get("j"));
        IssuesTest.assertEquals((Object)8L, vars.get("k"));
    }

    public void test24B() throws Exception {
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "{a = 10H; b = 10h; c = 42.0B; d = 42.0b;}";
        Script expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        IssuesTest.assertEquals((Object)new BigInteger("10"), vars.get("a"));
        IssuesTest.assertEquals((Object)new BigInteger("10"), vars.get("b"));
        IssuesTest.assertEquals((Object)new BigDecimal("42.0"), vars.get("c"));
        IssuesTest.assertEquals((Object)new BigDecimal("42.0"), vars.get("d"));
    }

    public void test24C() throws Exception {
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "{a = 42.0e1B; b = 42.0E+2B; c = 42.0e-1B; d = 42.0E-2b;}";
        Script expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        IssuesTest.assertEquals((Object)new BigDecimal("42.0e+1"), vars.get("a"));
        IssuesTest.assertEquals((Object)new BigDecimal("42.0e+2"), vars.get("b"));
        IssuesTest.assertEquals((Object)new BigDecimal("42.0e-1"), vars.get("c"));
        IssuesTest.assertEquals((Object)new BigDecimal("42.0e-2"), vars.get("d"));
    }

    public void test24D() throws Exception {
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "{a = 42.0e1D; b = 42.0E+2D; c = 42.0e-1d; d = 42.0E-2d;}";
        Script expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        IssuesTest.assertEquals((Object)Double.valueOf("42.0e+1"), vars.get("a"));
        IssuesTest.assertEquals((Object)Double.valueOf("42.0e+2"), vars.get("b"));
        IssuesTest.assertEquals((Object)Double.valueOf("42.0e-1"), vars.get("c"));
        IssuesTest.assertEquals((Object)Double.valueOf("42.0e-2"), vars.get("d"));
    }

    public void test49() throws Exception {
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "{a = 'b'; c = 'd';}";
        Script expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        IssuesTest.assertTrue((String)"JEXL-49 is not fixed", (vars.get("a").equals("b") && vars.get("c").equals("d") ? 1 : 0) != 0);
    }

    public void test48() throws Exception {
        JexlEngine jexl = new JexlEngine();
        jexl.setSilent(false);
        String jexlExp = "(foo.getInner().foo() eq true) and (foo.getInner().goo() = (foo.getInner().goo()+1-1))";
        Expression e = jexl.createExpression(jexlExp);
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        try {
            e.evaluate((JexlContext)jc);
            IssuesTest.fail((String)"Should have failed due to invalid assignment");
        }
        catch (JexlException xjexl) {
            // empty catch block
        }
    }

    public void test47() throws Exception {
        JexlEngine jexl = new JexlEngine();
        jexl.setSilent(false);
        MapContext ctxt = new MapContext();
        Expression expr = jexl.createExpression("true//false\n");
        Object value = expr.evaluate((JexlContext)ctxt);
        IssuesTest.assertTrue((String)"should be true", (boolean)((Boolean)value));
        expr = jexl.createExpression("/*true*/false");
        value = expr.evaluate((JexlContext)ctxt);
        IssuesTest.assertFalse((String)"should be false", (boolean)((Boolean)value));
        expr = jexl.createExpression("/*\"true\"*/false");
        value = expr.evaluate((JexlContext)ctxt);
        IssuesTest.assertFalse((String)"should be false", (boolean)((Boolean)value));
    }

    public void test42() throws Exception {
        JexlEngine jexl = new JexlEngine();
        UnifiedJEXL uel = new UnifiedJEXL(jexl);
        MapContext ctxt = new MapContext();
        ctxt.set("ax", (Object)"ok");
        UnifiedJEXL.Expression expr = uel.parse("${ax+(bx)}");
        Object value = expr.evaluate((JexlContext)ctxt);
        IssuesTest.assertTrue((String)"should be ok", (boolean)"ok".equals(value));
    }

    public void test40() throws Exception {
        JexlEngine jexl = new JexlEngine();
        jexl.setSilent(false);
        MapContext ctxt = new MapContext();
        ctxt.set("derived", (Object)new Derived());
        Expression expr = jexl.createExpression("derived.foo()");
        Object value = expr.evaluate((JexlContext)ctxt);
        IssuesTest.assertTrue((String)"should be true", (boolean)((Boolean)value));
    }

    public void test52base() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        Uberspect uber = jexl.getUberspect();
        String[] names = ((Introspector)uber).getMethodNames(Another.class);
        IssuesTest.assertTrue((String)"should find methods", (names.length > 0 ? 1 : 0) != 0);
        int found = 0;
        for (String name : names) {
            if (!"foo".equals(name) && !"goo".equals(name)) continue;
            ++found;
        }
        IssuesTest.assertTrue((String)"should have foo & goo", (found == 2 ? 1 : 0) != 0);
        names = ((UberspectImpl)uber).getFieldNames(Another.class);
        IssuesTest.assertTrue((String)"should find fields", (names.length > 0 ? 1 : 0) != 0);
        found = 0;
        for (String name : names) {
            if (!"name".equals(name)) continue;
            ++found;
        }
        IssuesTest.assertTrue((String)"should have name", (found == 1 ? 1 : 0) != 0);
    }

    public void test11() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        jexl.setSilent(false);
        MapContext ctxt = new MapContext();
        ctxt.set("a", null);
        String[] exprs = new String[]{"a % b"};
        for (int e = 0; e < exprs.length; ++e) {
            try {
                Expression expr = jexl.createExpression(exprs[e]);
                expr.evaluate((JexlContext)ctxt);
                IssuesTest.fail((String)(exprs[e] + " : should have failed due to null argument"));
                continue;
            }
            catch (JexlException xjexl) {
                // empty catch block
            }
        }
    }

    public void test62() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        jexl.setSilent(true);
        MapContext ctxt = new MapContext();
        Script jscript = jexl.createScript("dummy.hashCode()");
        IssuesTest.assertEquals((String)jscript.getText(), null, (Object)jscript.execute((JexlContext)ctxt));
        ctxt.set("dummy", (Object)"abcd");
        IssuesTest.assertEquals((String)jscript.getText(), (Object)"abcd".hashCode(), (Object)jscript.execute((JexlContext)ctxt));
        jscript = jexl.createScript("dummy.hashCode");
        IssuesTest.assertEquals((String)jscript.getText(), null, (Object)jscript.execute((JexlContext)ctxt));
        ctxt = new MapContext();
        Expression jexpr = jexl.createExpression("dummy.hashCode()");
        IssuesTest.assertEquals((String)jexpr.getExpression(), null, (Object)jexpr.evaluate((JexlContext)ctxt));
        ctxt.set("dummy", (Object)"abcd");
        IssuesTest.assertEquals((String)jexpr.getExpression(), (Object)"abcd".hashCode(), (Object)jexpr.evaluate((JexlContext)ctxt));
        jexpr = jexl.createExpression("dummy.hashCode");
        IssuesTest.assertEquals((String)jexpr.getExpression(), null, (Object)jexpr.evaluate((JexlContext)ctxt));
    }

    public void test73() throws Exception {
        String msg;
        MapContext ctxt = new MapContext();
        JexlEngine jexl = IssuesTest.createEngine(false);
        jexl.setSilent(false);
        Expression e = jexl.createExpression("c.e");
        try {
            e.evaluate((JexlContext)ctxt);
            IssuesTest.fail((String)"c.e not declared as variable");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            IssuesTest.assertTrue((msg.indexOf("c.e") > 0 ? 1 : 0) != 0);
        }
        ctxt.set("c", (Object)"{ 'a' : 3, 'b' : 5}");
        ctxt.set("e", (Object)2);
        try {
            e.evaluate((JexlContext)ctxt);
            IssuesTest.fail((String)"c.e not accessible as property");
        }
        catch (JexlException.Property xjexl) {
            msg = xjexl.getMessage();
            IssuesTest.assertTrue((msg.indexOf("c.e") > 0 ? 1 : 0) != 0);
        }
    }

    public void test87() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = IssuesTest.createEngine(false);
        jexl.setSilent(false);
        Expression divide = jexl.createExpression("l / r");
        Expression modulo = jexl.createExpression("l % r");
        ctxt.set("l", (Object)BigInteger.valueOf(7L));
        ctxt.set("r", (Object)BigInteger.valueOf(2L));
        IssuesTest.assertEquals((Object)BigInteger.valueOf(3L), (Object)divide.evaluate((JexlContext)ctxt));
        IssuesTest.assertTrue((boolean)jexl.getArithmetic().equals((Object)1, modulo.evaluate((JexlContext)ctxt)));
        ctxt.set("l", (Object)BigDecimal.valueOf(7L));
        ctxt.set("r", (Object)BigDecimal.valueOf(2L));
        IssuesTest.assertEquals((Object)BigDecimal.valueOf(3.5), (Object)divide.evaluate((JexlContext)ctxt));
        IssuesTest.assertTrue((boolean)jexl.getArithmetic().equals((Object)1, modulo.evaluate((JexlContext)ctxt)));
    }

    public void test90() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = IssuesTest.createEngine(false);
        jexl.setSilent(false);
        jexl.setCache(16);
        String[] fexprs = new String[]{"a=3 b=4", "while(a) while(a)", "1 2", "if (true) 2; 3 {}", "while (x) 1 if (y) 2 3"};
        for (int f = 0; f < fexprs.length; ++f) {
            try {
                jexl.createScript(fexprs[f]);
                IssuesTest.fail((String)(fexprs[f] + ": Should have failed in parse"));
                continue;
            }
            catch (JexlException xany) {
                // empty catch block
            }
        }
        String[] exprs = new String[]{"if (x) {1} if (y) {2}", "if (x) 1 if (y) 2", "while (x) 1 if (y) 2 else 3", "for(z : [3, 4, 5]) { z } y ? 2 : 1", "for(z : [3, 4, 5]) { z } if (y) 2 else 1"};
        ctxt.set("x", (Object)Boolean.FALSE);
        ctxt.set("y", (Object)Boolean.TRUE);
        for (int e = 0; e < exprs.length; ++e) {
            Script s = jexl.createScript(exprs[e]);
            IssuesTest.assertEquals((Object)2, (Object)s.execute((JexlContext)ctxt));
        }
        IssuesTest.debuggerCheck(jexl);
    }

    public void test44() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = IssuesTest.createEngine(false);
        jexl.setSilent(false);
        Script script = jexl.createScript("'hello world!'//commented");
        IssuesTest.assertEquals((Object)"hello world!", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!';//commented\n'bye...'");
        IssuesTest.assertEquals((Object)"bye...", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!'## commented");
        IssuesTest.assertEquals((Object)"hello world!", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!';## commented\n'bye...'");
        IssuesTest.assertEquals((Object)"bye...", (Object)script.execute((JexlContext)ctxt));
    }

    public void test97() throws Exception {
        MapContext ctxt = new MapContext();
        for (char v = 'a'; v <= 'z'; v = (char)(v + '\u0001')) {
            ctxt.set(Character.toString(v), (Object)10);
        }
        String input = "(((((((((((((((((((((((((z+y)/x)*w)-v)*u)/t)-s)*r)/q)+p)-o)*n)-m)+l)*k)+j)/i)+h)*g)+f)/e)+d)-c)/b)+a)";
        JexlEngine jexl = new JexlEngine();
        long start = System.nanoTime();
        Expression script = jexl.createExpression(input);
        Object value = script.evaluate((JexlContext)ctxt);
        IssuesTest.assertEquals((Object)11, (Object)value);
        long end = System.nanoTime();
        double millisec = (double)(end - start) / 1000000.0;
        double limit = 200.0;
        IssuesTest.assertTrue((String)("Expected parse to take less than " + limit + "ms, actual " + millisec), (millisec < limit ? 1 : 0) != 0);
    }

    public void test98() throws Exception {
        String[] exprs = new String[]{"fn:replace('DOMAIN\\somename', '\\\\', '\\\\\\\\')", "fn:replace(\"DOMAIN\\somename\", \"\\\\\", \"\\\\\\\\\")", "fn:replace('DOMAIN\\somename', '\\u005c', '\\u005c\\u005c')"};
        JexlEngine jexl = new JexlEngine();
        HashMap<String, fn98> funcs = new HashMap<String, fn98>();
        funcs.put("fn", new fn98());
        jexl.setFunctions(funcs);
        for (String expr : exprs) {
            Object value = jexl.createExpression(expr).evaluate(null);
            IssuesTest.assertEquals((String)expr, (Object)"DOMAIN\\\\somename", (Object)value);
        }
    }

    public void test100() throws Exception {
        JexlEngine jexl = new JexlEngine();
        jexl.setCache(4);
        MapContext ctxt = new MapContext();
        int[] foo = new int[]{42};
        ctxt.set("foo", (Object)foo);
        for (int l = 0; l < 2; ++l) {
            Object value = jexl.createExpression("foo[0]").evaluate((JexlContext)ctxt);
            IssuesTest.assertEquals((Object)42, (Object)value);
            value = jexl.createExpression("foo[0] = 43").evaluate((JexlContext)ctxt);
            IssuesTest.assertEquals((Object)43, (Object)value);
            value = jexl.createExpression("foo.0").evaluate((JexlContext)ctxt);
            IssuesTest.assertEquals((Object)43, (Object)value);
            value = jexl.createExpression("foo.0 = 42").evaluate((JexlContext)ctxt);
            IssuesTest.assertEquals((Object)42, (Object)value);
        }
    }

    public void test105() throws Exception {
        MapContext context = new MapContext();
        Expression selectExp = new JexlEngine().createExpression("[a.propA]");
        context.set("a", (Object)new A105("a1", "p1"));
        Object[] r = (Object[])selectExp.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"p1", (Object)r[0]);
        context.set("a", (Object)new A105("a2", "p2"));
        r = (Object[])selectExp.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"p2", (Object)r[0]);
    }

    public void test106() throws Exception {
        MapContext context = new MapContext();
        context.set("a", (Object)new BigDecimal(1));
        context.set("b", (Object)new BigDecimal(3));
        JexlEngine jexl = new JexlEngine();
        try {
            Object value = jexl.createExpression("a / b").evaluate((JexlContext)context);
            IssuesTest.assertNotNull((Object)value);
        }
        catch (JexlException xjexl) {
            IssuesTest.fail((String)"should not occur");
        }
        JexlArithmetic arithmetic = new JexlArithmetic(false, MathContext.UNLIMITED, 2);
        JexlEngine jexlX = new JexlEngine(null, arithmetic, null, null);
        try {
            jexlX.createExpression("a / b").evaluate((JexlContext)context);
            IssuesTest.fail((String)"should fail");
        }
        catch (JexlException xjexl) {
            // empty catch block
        }
    }

    public void test107() throws Exception {
        String[] exprs = new String[]{"'Q4'.toLowerCase()", "q4", "(Q4).toLowerCase()", "q4", "(4).toString()", "4", "(1 + 3).toString()", "4", "({ 'q' : 'Q4'}).get('q').toLowerCase()", "q4", "{ 'q' : 'Q4'}.get('q').toLowerCase()", "q4", "({ 'q' : 'Q4'})['q'].toLowerCase()", "q4", "(['Q4'])[0].toLowerCase()", "q4"};
        MapContext context = new MapContext();
        context.set("Q4", (Object)"Q4");
        JexlEngine jexl = new JexlEngine();
        for (int e = 0; e < exprs.length; e += 2) {
            Expression expr = jexl.createExpression(exprs[e]);
            String expected = exprs[e + 1];
            Object value = expr.evaluate((JexlContext)context);
            IssuesTest.assertEquals((Object)expected, (Object)value);
            expr = jexl.createExpression(expr.dump());
            value = expr.evaluate((JexlContext)context);
            IssuesTest.assertEquals((Object)expected, (Object)value);
        }
    }

    public void test108() throws Exception {
        JexlEngine jexl = new JexlEngine();
        Expression expr = jexl.createExpression("size([])");
        Object value = expr.evaluate(null);
        IssuesTest.assertEquals((Object)0, (Object)value);
        expr = jexl.createExpression(expr.dump());
        value = expr.evaluate(null);
        IssuesTest.assertEquals((Object)0, (Object)value);
        expr = jexl.createExpression("if (true) { [] } else { {:} }");
        value = expr.evaluate(null);
        IssuesTest.assertTrue((boolean)value.getClass().isArray());
        expr = jexl.createExpression(expr.dump());
        value = expr.evaluate(null);
        IssuesTest.assertTrue((boolean)value.getClass().isArray());
        expr = jexl.createExpression("size({:})");
        value = expr.evaluate(null);
        IssuesTest.assertEquals((Object)0, (Object)value);
        expr = jexl.createExpression(expr.dump());
        value = expr.evaluate(null);
        IssuesTest.assertEquals((Object)0, (Object)value);
        expr = jexl.createExpression("if (false) { [] } else { {:} }");
        value = expr.evaluate(null);
        IssuesTest.assertTrue((boolean)(value instanceof Map));
        expr = jexl.createExpression(expr.dump());
        value = expr.evaluate(null);
        IssuesTest.assertTrue((boolean)(value instanceof Map));
    }

    public void test109() throws Exception {
        JexlEngine jexl = new JexlEngine();
        MapContext context = new MapContext();
        context.set("foo.bar", (Object)40);
        Object value = jexl.createExpression("foo.bar + 2").evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)42, (Object)value);
    }

    public void test110() throws Exception {
        JexlEngine jexl = new JexlEngine();
        String[] names = new String[]{"foo"};
        MapContext context = new MapContext();
        Object value = jexl.createScript("foo + 2", null, names).execute((JexlContext)context, new Object[]{40});
        IssuesTest.assertEquals((Object)42, (Object)value);
        context.set("frak.foo", (Object)-40);
        value = jexl.createScript("frak.foo - 2", null, names).execute((JexlContext)context, new Object[]{40});
        IssuesTest.assertEquals((Object)-42, (Object)value);
    }

    public void testRichContext() throws Exception {
        A105 a105 = new A105("foo", "bar");
        JexlEngine jexl = new JexlEngine();
        RichContext context = new RichContext(jexl, a105);
        Object value = jexl.createScript("uppercase(nameA + propA)").execute((JexlContext)context);
        IssuesTest.assertEquals((Object)"FOOBAR", (Object)value);
    }

    public void test111() throws Exception {
        JexlEngine jexl = new JexlEngine();
        MapContext context = new MapContext();
        String strExpr = "((x>0)?\"FirstValue=\"+(y-x):\"SecondValue=\"+x)";
        Expression expr = jexl.createExpression(strExpr);
        context.set("x", (Object)1);
        context.set("y", (Object)10);
        Object value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"FirstValue=9", (Object)value);
        context.set("x", (Object)1.0);
        context.set("y", (Object)10.0);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"FirstValue=9.0", (Object)value);
        context.set("x", (Object)1);
        context.set("y", (Object)10.0);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"FirstValue=9.0", (Object)value);
        context.set("x", (Object)1.0);
        context.set("y", (Object)10);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"FirstValue=9.0", (Object)value);
        context.set("x", (Object)-10);
        context.set("y", (Object)1);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"SecondValue=-10", (Object)value);
        context.set("x", (Object)-10.0);
        context.set("y", (Object)1.0);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"SecondValue=-10.0", (Object)value);
        context.set("x", (Object)-10);
        context.set("y", (Object)1.0);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"SecondValue=-10", (Object)value);
        context.set("x", (Object)-10.0);
        context.set("y", (Object)1);
        value = expr.evaluate((JexlContext)context);
        IssuesTest.assertEquals((Object)"SecondValue=-10.0", (Object)value);
    }

    public void testScaleIssue() throws Exception {
        JexlThreadedArithmetic arithmetic = new JexlThreadedArithmetic(false);
        JexlEngine jexlX = new JexlEngine(null, (JexlArithmetic)arithmetic, null, null);
        String expStr1 = "result == salary/month * work.percent/100.00";
        Expression exp1 = jexlX.createExpression(expStr1);
        MapContext ctx = new MapContext();
        ctx.set("result", (Object)new BigDecimal("9958.33"));
        ctx.set("salary", (Object)new BigDecimal("119500.00"));
        ctx.set("month", (Object)new BigDecimal("12.00"));
        ctx.set("percent", (Object)new BigDecimal("100.00"));
        IssuesTest.assertFalse((boolean)((Boolean)exp1.evaluate((JexlContext)ctx)));
        JexlThreadedArithmetic.setMathScale((Integer)2);
        IssuesTest.assertTrue((boolean)((Boolean)exp1.evaluate((JexlContext)ctx)));
    }

    public void test112() throws Exception {
        JexlEngine jexl = new JexlEngine();
        Object result = jexl.createScript(Integer.toString(Integer.MAX_VALUE)).execute(null);
        IssuesTest.assertEquals((Object)Integer.MAX_VALUE, (Object)result);
        result = jexl.createScript(Integer.toString(-2147483647)).execute(null);
        IssuesTest.assertEquals((Object)-2147483647, (Object)result);
        result = jexl.createScript(Integer.toString(Integer.MIN_VALUE)).execute(null);
        IssuesTest.assertEquals((Object)Integer.MIN_VALUE, (Object)result);
    }

    public void test117() throws Exception {
        JexlEngine jexl = new JexlEngine();
        Expression e = jexl.createExpression("TIMESTAMP > 20100102000000");
        MapContext ctx = new MapContext();
        ctx.set("TIMESTAMP", (Object)new Long("20100103000000"));
        Object result = e.evaluate((JexlContext)ctx);
        IssuesTest.assertTrue((boolean)((Boolean)result));
    }

    public void testStringIdentifier() throws Exception {
        JexlEngine jexl = new JexlEngine();
        HashMap<String, String> foo = new HashMap<String, String>();
        MapContext jc = new MapContext();
        jc.set("foo", foo);
        foo.put("q u u x", "456");
        Expression e = jexl.createExpression("foo.\"q u u x\"");
        Object result = e.evaluate((JexlContext)jc);
        IssuesTest.assertEquals((Object)"456", (Object)result);
        e = jexl.createExpression("foo.'q u u x'");
        result = e.evaluate((JexlContext)jc);
        IssuesTest.assertEquals((Object)"456", (Object)result);
        Script s = jexl.createScript("foo.\"q u u x\"");
        result = s.execute((JexlContext)jc);
        IssuesTest.assertEquals((Object)"456", (Object)result);
        s = jexl.createScript("foo.'q u u x'");
        result = s.execute((JexlContext)jc);
        IssuesTest.assertEquals((Object)"456", (Object)result);
        Debugger dbg = new Debugger();
        dbg.debug((JexlNode)((ExpressionImpl)s).script);
        String dbgdata = dbg.data();
        IssuesTest.assertEquals((String)"foo.'q u u x';", (String)dbgdata);
    }

    public void test119() throws Exception {
        JexlEngine jexl = new JexlEngine();
        Container quux = new Container("quux", 42);
        Script getName = jexl.createScript("foo.property.name", new String[]{"foo"});
        Object result = getName.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)"quux", (Object)result);
        Script get0 = jexl.createScript("foo.property.0", new String[]{"foo"});
        result = get0.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)"quux", (Object)result);
        Script getNumber = jexl.createScript("foo.property.number", new String[]{"foo"});
        result = getNumber.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)42, (Object)result);
        Script get1 = jexl.createScript("foo.property.1", new String[]{"foo"});
        result = get1.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)42, (Object)result);
        Script setName = jexl.createScript("foo.property.name = $0", new String[]{"foo", "$0"});
        setName.execute(null, new Object[]{quux, "QUUX"});
        result = getName.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)"QUUX", (Object)result);
        result = get0.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)"QUUX", (Object)result);
        Script set0 = jexl.createScript("foo.property.0 = $0", new String[]{"foo", "$0"});
        set0.execute(null, new Object[]{quux, "BAR"});
        result = getName.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)"BAR", (Object)result);
        result = get0.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)"BAR", (Object)result);
        Script setNumber = jexl.createScript("foo.property.number = $0", new String[]{"foo", "$0"});
        setNumber.execute(null, new Object[]{quux, -42});
        result = getNumber.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)-42, (Object)result);
        result = get1.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)-42, (Object)result);
        Script set1 = jexl.createScript("foo.property.1 = $0", new String[]{"foo", "$0"});
        set1.execute(null, new Object[]{quux, 24});
        result = getNumber.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)24, (Object)result);
        result = get1.execute(null, new Object[]{quux});
        IssuesTest.assertEquals((Object)24, (Object)result);
    }

    public static class Container {
        String value0;
        int value1;

        public Container(String name, int number) {
            this.value0 = name;
            this.value1 = number;
        }

        public Object getProperty(String name) {
            if ("name".equals(name)) {
                return this.value0;
            }
            if ("number".equals(name)) {
                return this.value1;
            }
            return null;
        }

        public Object getProperty(int ref) {
            if (0 == ref) {
                return this.value0;
            }
            if (1 == ref) {
                return this.value1;
            }
            return null;
        }

        public void setProperty(String name, String value) {
            if ("name".equals(name)) {
                this.value0 = value;
            }
        }

        public void setProperty(String name, int value) {
            if ("number".equals(name)) {
                this.value1 = value;
            }
        }

        public void setProperty(int ref, String value) {
            if (0 == ref) {
                this.value0 = value;
            }
        }

        public void setProperty(int ref, int value) {
            if (1 == ref) {
                this.value1 = value;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RichContext
    extends ObjectContext<A105> {
        RichContext(JexlEngine jexl, A105 a105) {
            super(jexl, (Object)a105);
        }

        public String uppercase(String str) {
            return str.toUpperCase();
        }
    }

    public static class A105 {
        String nameA;
        String propA;

        public A105(String nameA, String propA) {
            this.nameA = nameA;
            this.propA = propA;
        }

        public String toString() {
            return "A [nameA=" + this.nameA + ", propA=" + this.propA + "]";
        }

        public String getNameA() {
            return this.nameA;
        }

        public String getPropA() {
            return this.propA;
        }
    }

    public static class fn98 {
        public String replace(String str, String target, String replacement) {
            return str.replace(target, replacement);
        }
    }

    class Derived
    extends Base {
        Derived() {
        }

        public boolean foo() {
            return true;
        }
    }

    public static abstract class Base {
        public abstract boolean foo();
    }

    public static class Foo {
        private Another inner = new Another();

        Foo() {
        }

        public Another getInner() {
            return this.inner;
        }
    }

    public static class Another {
        public String name = "whatever";
        private Boolean foo = Boolean.TRUE;

        public Boolean foo() {
            return this.foo;
        }

        public int goo() {
            return 100;
        }
    }
}

