/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnifiedJEXLTest
extends JexlTestCase {
    private static final JexlEngine ENGINE = UnifiedJEXLTest.createEngine(false);
    private static final UnifiedJEXL EL;
    private static final Log LOG;
    private JexlContext context = null;
    private Map<String, Object> vars = null;

    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
        this.vars = new HashMap<String, Object>();
        this.context = new MapContext(this.vars);
    }

    protected void tearDown() throws Exception {
        UnifiedJEXLTest.debuggerCheck(ENGINE);
        super.tearDown();
    }

    private String getSource(String tostring) {
        int len = tostring.length();
        int sc = tostring.lastIndexOf(" /*= ");
        if (sc >= 0) {
            sc += " /*= ".length();
        }
        int ec = tostring.lastIndexOf(" */");
        if (sc >= 0 && ec >= 0 && ec > sc && ec < len) {
            return tostring.substring(sc, ec);
        }
        return tostring;
    }

    public UnifiedJEXLTest(String testName) {
        super(testName);
    }

    public void testStatement() throws Exception {
        this.vars.put("froboz", new Froboz(123));
        UnifiedJEXL.Expression check = EL.parse("${froboz.value = 32; froboz.plus10(); froboz.value}");
        Object o = check.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        Set evars = check.getVariables();
        UnifiedJEXLTest.assertEquals((int)2, (int)evars.size());
    }

    public void testAssign() throws Exception {
        UnifiedJEXL.Expression assign = EL.parse("${froboz.value = 10}");
        UnifiedJEXL.Expression check = EL.parse("${froboz.value}");
        Object o = assign.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    public void testComposite() throws Exception {
        String source = "Dear ${p} ${name};";
        UnifiedJEXL.Expression expr = EL.parse(source);
        this.vars.put("p", "Mr");
        this.vars.put("name", "Doe");
        UnifiedJEXLTest.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Object o = expr.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        this.vars.put("p", "Ms");
        this.vars.put("name", "Jones");
        o = expr.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((Object)"Dear Ms Jones;", (Object)o);
        UnifiedJEXLTest.assertEquals((String)source, (String)this.getSource(expr.toString()));
    }

    public void testPrepareEvaluate() throws Exception {
        String source = "Dear #{p} ${name};";
        UnifiedJEXL.Expression expr = EL.parse("Dear #{p} ${name};");
        UnifiedJEXLTest.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Set evars = expr.getVariables();
        UnifiedJEXLTest.assertEquals((int)1, (int)evars.size());
        UnifiedJEXLTest.assertTrue((boolean)evars.contains(Arrays.asList("name")));
        this.vars.put("name", "Doe");
        UnifiedJEXL.Expression phase1 = expr.prepare(this.context);
        String as = phase1.asString();
        UnifiedJEXLTest.assertEquals((String)"Dear ${p} Doe;", (String)as);
        Set evars1 = phase1.getVariables();
        UnifiedJEXLTest.assertEquals((int)1, (int)evars1.size());
        UnifiedJEXLTest.assertTrue((boolean)evars1.contains(Arrays.asList("p")));
        this.vars.put("p", "Mr");
        this.vars.put("name", "Should not be used in 2nd phase");
        Object o = phase1.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        String p1 = this.getSource(phase1.toString());
        UnifiedJEXLTest.assertEquals((String)"Dear #{p} ${name};", (String)this.getSource(phase1.toString()));
        UnifiedJEXLTest.assertEquals((String)"Dear #{p} ${name};", (String)this.getSource(expr.toString()));
    }

    public void testNested() throws Exception {
        String source = "#{${hi}+'.world'}";
        UnifiedJEXL.Expression expr = EL.parse("#{${hi}+'.world'}");
        Set evars = expr.getVariables();
        UnifiedJEXLTest.assertEquals((int)1, (int)evars.size());
        UnifiedJEXLTest.assertTrue((boolean)evars.contains(Arrays.asList("hi")));
        this.vars.put("hi", "greeting");
        this.vars.put("greeting.world", "Hello World!");
        UnifiedJEXLTest.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Object o = expr.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((Object)"Hello World!", (Object)o);
        UnifiedJEXLTest.assertEquals((String)"#{${hi}+'.world'}", (String)this.getSource(expr.toString()));
    }

    public void testImmediate() throws Exception {
        JexlContext none = null;
        String source = "${'Hello ' + 'World!'}";
        UnifiedJEXL.Expression expr = EL.parse("${'Hello ' + 'World!'}");
        UnifiedJEXL.Expression prepared = expr.prepare(none);
        UnifiedJEXLTest.assertEquals((String)"prepare should return same expression", (String)"Hello World!", (String)prepared.asString());
        Object o = expr.evaluate(none);
        UnifiedJEXLTest.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        UnifiedJEXLTest.assertEquals((Object)"Hello World!", (Object)o);
        UnifiedJEXLTest.assertEquals((String)"${'Hello ' + 'World!'}", (String)this.getSource(expr.toString()));
    }

    public void testConstant() throws Exception {
        JexlContext none = null;
        String source = "Hello World!";
        UnifiedJEXL.Expression expr = EL.parse("Hello World!");
        UnifiedJEXLTest.assertTrue((String)"prepare should return same expression", (expr.prepare(none) == expr ? 1 : 0) != 0);
        Object o = expr.evaluate(none);
        UnifiedJEXLTest.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        UnifiedJEXLTest.assertEquals((Object)"Hello World!", (Object)o);
        UnifiedJEXLTest.assertEquals((String)"Hello World!", (String)this.getSource(expr.toString()));
    }

    public void testDeferred() throws Exception {
        JexlContext none = null;
        String source = "#{'world'}";
        UnifiedJEXL.Expression expr = EL.parse("#{'world'}");
        UnifiedJEXLTest.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        String as = expr.prepare(none).asString();
        UnifiedJEXLTest.assertEquals((String)"prepare should return immediate version", (String)"${'world'}", (String)as);
        Object o = expr.evaluate(none);
        UnifiedJEXLTest.assertEquals((Object)"world", (Object)o);
        UnifiedJEXLTest.assertEquals((String)"#{'world'}", (String)this.getSource(expr.toString()));
    }

    public void testEscape() throws Exception {
        JexlContext none = null;
        UnifiedJEXL.Expression expr = EL.parse("\\#{'world'}");
        Object o = expr.evaluate(none);
        UnifiedJEXLTest.assertEquals((Object)"#{'world'}", (Object)o);
        expr = EL.parse("\\${'world'}");
        o = expr.evaluate(none);
        UnifiedJEXLTest.assertEquals((Object)"${'world'}", (Object)o);
    }

    public void testEscapeString() throws Exception {
        UnifiedJEXL.Expression expr = EL.parse("\\\"${'world\\'s finest'}\\\"");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        UnifiedJEXLTest.assertEquals((Object)"\"world's finest\"", (Object)o);
    }

    public void testNonEscapeString() throws Exception {
        UnifiedJEXL.Expression expr = EL.parse("c:\\some\\windows\\path");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        UnifiedJEXLTest.assertEquals((Object)"c:\\some\\windows\\path", (Object)o);
    }

    public void testMalformed() throws Exception {
        try {
            UnifiedJEXL.Expression expr = EL.parse("${'world'");
            JexlContext none = null;
            expr.evaluate(none);
            UnifiedJEXLTest.fail((String)"should be malformed");
        }
        catch (UnifiedJEXL.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    public void testMalformedNested() throws Exception {
        try {
            UnifiedJEXL.Expression expr = EL.parse("#{${hi} world}");
            JexlContext none = null;
            expr.evaluate(none);
            UnifiedJEXLTest.fail((String)"should be malformed");
        }
        catch (UnifiedJEXL.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    public void testBadContextNested() throws Exception {
        try {
            UnifiedJEXL.Expression expr = EL.parse("#{${hi}+'.world'}");
            JexlContext none = null;
            expr.evaluate(none);
            UnifiedJEXLTest.fail((String)"should be malformed");
        }
        catch (UnifiedJEXL.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharAtBug() throws Exception {
        this.vars.put("foo", "abcdef");
        UnifiedJEXL.Expression expr = EL.parse("${foo.substring(2,4)/*comment*/}");
        Object o = expr.evaluate(this.context);
        UnifiedJEXLTest.assertEquals((Object)"cd", (Object)o);
        this.vars.put("bar", "foo");
        try {
            ENGINE.setSilent(true);
            expr = EL.parse("#{${bar}+'.charAt(-2)'}");
            expr = expr.prepare(this.context);
            o = expr.evaluate(this.context);
            UnifiedJEXLTest.assertEquals(null, (Object)o);
        }
        finally {
            ENGINE.setSilent(false);
        }
    }

    public void testTemplate0() throws Exception {
        String source = "   $$ if(x) {\nx is ${x}\n   $$ } else {\n${'no x'}\n$$ }\n";
        UnifiedJEXL.Template t = EL.createTemplate(source);
        this.vars.put("x", 42);
        StringWriter strw = new StringWriter();
        t.evaluate(this.context, (Writer)strw);
        String output = strw.toString();
        UnifiedJEXLTest.assertEquals((String)"x is 42\n", (String)output);
        strw = new StringWriter();
        this.vars.put("x", "");
        t.evaluate(this.context, (Writer)strw);
        output = strw.toString();
        UnifiedJEXLTest.assertEquals((String)"no x\n", (String)output);
        String dstr = t.toString();
        UnifiedJEXLTest.assertNotNull((Object)dstr);
    }

    public void testTemplate1() throws Exception {
        String source = "$$ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ }\n";
        UnifiedJEXL.Template t = EL.createTemplate("$$", (Reader)new StringReader(source), new String[]{"x"});
        String dstr = t.asString();
        UnifiedJEXLTest.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate(this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        UnifiedJEXLTest.assertEquals((String)"x is 42\n", (String)output);
        strw = new StringWriter();
        t.evaluate(this.context, (Writer)strw, new Object[]{""});
        output = strw.toString();
        UnifiedJEXLTest.assertEquals((String)"no x\n", (String)output);
    }

    public void testPrepareTemplate() throws Exception {
        String source = "$$ for(var x : list) {\n${l10n}=#{x}\n$$ }\n";
        int[] args = new int[]{42};
        UnifiedJEXL.Template tl10n = EL.createTemplate(source, new String[]{"list"});
        String dstr = tl10n.asString();
        UnifiedJEXLTest.assertNotNull((Object)dstr);
        this.context.set("l10n", (Object)"valeur");
        UnifiedJEXL.Template tpFR = tl10n.prepare(this.context);
        this.context.set("l10n", (Object)"value");
        UnifiedJEXL.Template tpEN = tl10n.prepare(this.context);
        this.context.set("l10n", null);
        StringWriter strw = new StringWriter();
        tpFR.evaluate(this.context, (Writer)strw, new Object[]{args});
        String outFR = strw.toString();
        UnifiedJEXLTest.assertEquals((String)"valeur=42\n", (String)outFR);
        this.context.set("l10n", null);
        strw = new StringWriter();
        tpEN.evaluate(this.context, (Writer)strw, new Object[]{args});
        String outEN = strw.toString();
        UnifiedJEXLTest.assertEquals((String)"value=42\n", (String)outEN);
    }

    public void test42() throws Exception {
        String test42 = "$$ for(var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n";
        UnifiedJEXL.Template t = EL.createTemplate("$$", (Reader)new StringReader(test42), new String[]{"list"});
        StringWriter strw = new StringWriter();
        int[] list = new int[]{1, 3, 5, 42, 169};
        t.evaluate(this.context, (Writer)strw, new Object[]{list});
        String output = strw.toString();
        String out42 = "The value 1 is under fourty-two\nThe value 3 is under fourty-two\nThe value 5 is under fourty-two\nLife, the universe, and everything\nThe value 169 is over fourty-two\n";
        UnifiedJEXLTest.assertEquals((String)out42, (String)output);
        String dstr = t.asString();
        UnifiedJEXLTest.assertNotNull((Object)dstr);
    }

    public void testWriter() throws Exception {
        Froboz froboz = new Froboz(42);
        FrobozWriter writer = new FrobozWriter(new StringWriter());
        UnifiedJEXL.Template t = EL.createTemplate("$$", (Reader)new StringReader("$$$jexl.print(froboz)"), new String[]{"froboz"});
        t.evaluate(this.context, (Writer)writer, new Object[]{froboz});
        UnifiedJEXLTest.assertEquals((String)"froboz{42}", (String)((Object)writer).toString());
    }

    static {
        ENGINE.setSilent(false);
        ENGINE.setCache(128);
        EL = new UnifiedJEXL(ENGINE);
        LOG = LogFactory.getLog(UnifiedJEXL.class);
    }

    public static class FrobozWriter
    extends PrintWriter {
        public FrobozWriter(Writer w) {
            super(w);
        }

        public void print(Froboz froboz) {
            super.print("froboz{");
            super.print(froboz.value);
            super.print("}");
        }

        public String toString() {
            return this.out.toString();
        }
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public void setValue(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public int plus10() {
            int i = this.value;
            this.value += 10;
            return i;
        }
    }
}

