/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class WhileTest
extends JexlTestCase {
    public WhileTest(String testName) {
        super(testName);
    }

    public void testSimpleWhileFalse() throws Exception {
        Expression e = this.JEXL.createExpression("while (false) ;");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        WhileTest.assertNull((String)"Result is not null", (Object)o);
    }

    public void testWhileExecutesExpressionWhenLooping() throws Exception {
        Expression e = this.JEXL.createExpression("while (x < 10) x = x + 1;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        Object o = e.evaluate((JexlContext)jc);
        WhileTest.assertEquals((String)"Result is wrong", (Object)new Integer(10), (Object)o);
    }

    public void testWhileWithBlock() throws Exception {
        Expression e = this.JEXL.createExpression("while (x < 10) { x = x + 1; y = y * 2; }");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        jc.set("y", (Object)new Integer(1));
        Object o = e.evaluate((JexlContext)jc);
        WhileTest.assertEquals((String)"Result is wrong", (Object)new Integer(512), (Object)o);
        WhileTest.assertEquals((String)"x is wrong", (Object)new Integer(10), (Object)jc.get("x"));
        WhileTest.assertEquals((String)"y is wrong", (Object)new Integer(512), (Object)jc.get("y"));
    }
}

