/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.examples;

import junit.framework.TestCase;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.examples.Output;

public class MethodPropertyTest
extends TestCase {
    public static void example(Output out) throws Exception {
        JexlEngine jexl = new JexlEngine();
        MapContext jc = new MapContext();
        Foo foo = new Foo();
        Integer number = new Integer(10);
        jc.set("foo", (Object)foo);
        jc.set("number", (Object)number);
        Expression e = jexl.createExpression("foo.getFoo()");
        Object o = e.evaluate((JexlContext)jc);
        out.print("value returned by the method getFoo() is : ", o, foo.getFoo());
        e = jexl.createExpression("foo.convert(1)");
        o = e.evaluate((JexlContext)jc);
        out.print("value of " + e.getExpression() + " is : ", o, foo.convert(1L));
        e = jexl.createExpression("foo.convert(1+7)");
        o = e.evaluate((JexlContext)jc);
        out.print("value of " + e.getExpression() + " is : ", o, foo.convert(8L));
        e = jexl.createExpression("foo.convert(1+number)");
        o = e.evaluate((JexlContext)jc);
        out.print("value of " + e.getExpression() + " is : ", o, foo.convert(1 + number));
        e = jexl.createExpression("foo.bar");
        o = e.evaluate((JexlContext)jc);
        out.print("value returned for the property 'bar' is : ", o, foo.get("bar"));
    }

    public void testExample() throws Exception {
        MethodPropertyTest.example(Output.JUNIT);
    }

    public static void main(String[] args) throws Exception {
        MethodPropertyTest.example(Output.SYSTEM);
    }

    public static class Foo {
        public String getFoo() {
            return "This is from getFoo()";
        }

        public String get(String arg) {
            return "This is the property " + arg;
        }

        public String convert(long i) {
            return "The value is : " + i;
        }
    }
}

